/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.Component;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.Transaction;
import jgnash.text.CommodityFormat;
import jgnash.ui.components.ColoredTableCellRenderer;
import jgnash.ui.register.table.AbstractRegisterTableModel;

public class ColoredQuantityTableCellRenderer
extends ColoredTableCellRenderer {
    public ColoredQuantityTableCellRenderer() {
        this.setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table.getModel() instanceof AbstractRegisterTableModel) {
            Transaction t = ((AbstractRegisterTableModel)table.getModel()).getTransactionAt(row);
            if (t.getDate().after(new Date())) {
                c.setFont(c.getFont().deriveFont(2));
            }
            if (value != null && t instanceof InvestmentTransaction && c instanceof JLabel) {
                InvestmentTransaction it = (InvestmentTransaction)t;
                JLabel label = (JLabel)c;
                NumberFormat nformat = CommodityFormat.getShortNumberFormat(it.getSecurityNode());
                label.setText(nformat.format(value));
            }
        }
        return c;
    }
}

