/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.EngineFactory;
import jgnash.engine.RootAccount;
import jgnash.engine.SecurityNode;
import jgnash.message.Message;
import jgnash.message.MessageProperty;
import jgnash.text.CommodityFormat;
import jgnash.ui.account.AbstractAccountListPane;
import jgnash.ui.account.AccountTreeTableModel;
import jgnash.ui.treetable.JTreeTable;

public class AccountListTreeTablePane
extends AbstractAccountListPane
implements TreeSelectionListener {
    JTreeTable treeTable;

    AccountListTreeTablePane(String identifier, boolean rootVisable) {
        super(identifier, rootVisable);
    }

    @Override
    public JComponent createModelAndView() {
        this.model = new AccountTreeTableModel();
        this.treeTable = new JTreeTable((AccountTreeTableModel)this.model);
        this.treeTable.setBorder(null);
        this.treeTable.setRootVisible(this.rootVisible);
        this.treeTable.getTree().setShowsRootHandles(true);
        this.treeTable.setDefaultRenderer(AccountBalanceCellRenderer.class, new AccountBalanceCellRenderer());
        this.treeTable.setDefaultRenderer(ReconciledAccountBalanceCellRenderer.class, new ReconciledAccountBalanceCellRenderer());
        this.treeTable.addTreeSelectionListener(this);
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ActionListener[] list = (ActionListener[])AccountListTreeTablePane.this.listenerList.getListeners(ActionListener.class);
                    ActionEvent evt = new ActionEvent(AccountListTreeTablePane.this, 1001, "double-click");
                    for (ActionListener listener : list) {
                        listener.actionPerformed(evt);
                    }
                }
            }
        });
        return this.treeTable;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object o = this.treeTable.getLastSelectedPathComponent();
        if (o != null) {
            this.selectedAccount = (Account)((DefaultMutableTreeNode)o).getUserObject();
        }
    }

    @Override
    public void scrollToTop() {
        RootAccount rootAccount = EngineFactory.getEngine("default").getRootAccount();
        if (rootAccount != null) {
            this.treeTable.scrollPathToVisible(new TreePath(rootAccount));
        }
    }

    @Override
    public void setSelectedAccount(Account account) {
        DefaultMutableTreeNode node;
        if (account != null && (node = this.model.findAccountNode(account)) != null) {
            this.treeTable.setSelectionPath(new TreePath(node));
        }
    }

    @Override
    protected void _expand() {
        for (int i = 0; i < this.treeTable.getRowCount(); ++i) {
            this.treeTable.expandRow(i);
        }
    }

    @Override
    public void messagePosted(final Message event) {
        super.messagePosted(event);
        if (EngineFactory.getEngine("default") == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case COMMODITY_HISTORY_ADD: 
                    case COMMODITY_HISTORY_REMOVE: {
                        AccountListTreeTablePane.this.updateInvestmentAccounts((SecurityNode)event.getObject(MessageProperty.COMMODITY));
                        break;
                    }
                }
            }
        });
    }

    private void updateInvestmentAccounts(SecurityNode node) {
        Set<Account> accounts = EngineFactory.getEngine("default").getInvestmentAccountList(node);
        for (Account account : accounts) {
            this.accountChanged(account);
        }
    }

    private void accountChanged(Account account) {
        DefaultMutableTreeNode treeNode = this.model.findAccountNode(account);
        this.model.nodeChanged(treeNode);
        if (account.getParent() != null && account.getParent().getAccountType() != AccountType.ROOT) {
            this.accountChanged(account.getParent());
        }
    }

    static final class ReconciledAccountBalanceCellRenderer
    extends DefaultTableCellRenderer {
        private CommodityFormat formatter = CommodityFormat.getFullFormat();

        ReconciledAccountBalanceCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                if (((Account)value).getReconciledTreeBalance().signum() < 0) {
                    c.setForeground(Color.RED);
                } else {
                    c.setForeground(table.getForeground());
                }
            } else {
                c.setForeground(table.getSelectionForeground());
            }
            return c;
        }

        @Override
        public void setValue(Object value) {
            this.setText(value != null ? this.formatter.format(((Account)value).getReconciledTreeBalance(), ((Account)value).getCurrencyNode()) : "");
        }
    }

    static final class AccountBalanceCellRenderer
    extends DefaultTableCellRenderer {
        private CommodityFormat formatter = CommodityFormat.getFullFormat();

        AccountBalanceCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                if (((Account)value).getTreeBalance().signum() < 0) {
                    c.setForeground(Color.RED);
                } else {
                    c.setForeground(table.getForeground());
                }
            } else {
                c.setForeground(table.getSelectionForeground());
            }
            return c;
        }

        @Override
        public void setValue(Object value) {
            this.setText(value != null ? this.formatter.format(((Account)value).getTreeBalance(), ((Account)value).getCurrencyNode()) : "");
        }
    }
}

