/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.ui.account.AbstractAccountListPane;
import jgnash.ui.account.AccountListFilterDialog;
import jgnash.ui.account.AccountListPanePopUp;
import jgnash.ui.account.AccountTools;
import jgnash.ui.components.RollOverButton;
import jgnash.ui.register.RegisterFrame;
import jgnash.util.Resource;

public class AccountListPanel
extends JPanel
implements ActionListener,
MessageListener,
TreeSelectionListener {
    private Resource rb = Resource.get();
    private AccountListPanePopUp accountList;
    private JButton deleteButton;
    private JButton filterButton;
    private JButton modifyButton;
    private JButton newButton;
    private JButton reconcileButton;
    private JButton zoomButton;

    public AccountListPanel() {
        this.initComponents();
        MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
        this.deleteButton.addActionListener(this);
        this.filterButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.reconcileButton.addActionListener(this);
        this.zoomButton.addActionListener(this);
        this.accountList.treeTable.addTreeSelectionListener(this);
        if (AccountListPanel.getEngine() == null || AccountListPanel.getEngine().getRootAccount() == null) {
            this.enableButtons(false);
        }
        Logger log = Logger.getLogger(AccountListPanel.class.getName());
        log.fine("AccountListPanel construction complete");
    }

    private static Engine getEngine() {
        return EngineFactory.getEngine("default");
    }

    private void initComponents() {
        this.accountList = new AccountListPanePopUp();
        JPanel toolPanel = new JPanel();
        JToolBar toolBar = new JToolBar();
        this.setLayout(new BorderLayout());
        toolPanel.setLayout(new BorderLayout());
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.newButton = new RollOverButton(this.rb.getString("Button.New"), Resource.getIcon("/jgnash/resource/document-new.png"));
        this.newButton.setToolTipText(this.rb.getString("ToolTip.NewAccount"));
        toolBar.add(this.newButton);
        this.modifyButton = new RollOverButton(this.rb.getString("Button.Modify"), Resource.getIcon("/jgnash/resource/document-properties.png"));
        this.modifyButton.setToolTipText(this.rb.getString("ToolTip.ModifyAccount"));
        toolBar.add(this.modifyButton);
        this.reconcileButton = new RollOverButton(this.rb.getString("Button.Reconcile"), Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.reconcileButton.setToolTipText(this.rb.getString("ToolTip.ReconcileAccount"));
        toolBar.add(this.reconcileButton);
        this.deleteButton = new RollOverButton(this.rb.getString("Button.Delete"), Resource.getIcon("/jgnash/resource/edit-delete.png"));
        this.deleteButton.setToolTipText(this.rb.getString("ToolTip.DeleteAccount"));
        toolBar.add(this.deleteButton);
        this.filterButton = new RollOverButton(this.rb.getString("Button.Filter"), Resource.getIcon("/jgnash/resource/preferences-system.png"));
        this.filterButton.setToolTipText(this.rb.getString("ToolTip.FilterAccount"));
        toolBar.add(this.filterButton);
        this.zoomButton = new RollOverButton(this.rb.getString("Button.Zoom"), Resource.getIcon("/jgnash/resource/edit-find.png"));
        toolBar.add(this.zoomButton);
        toolPanel.add((Component)toolBar, "North");
        toolPanel.add((Component)new JSeparator(), "Center");
        this.add((Component)toolPanel, "North");
        this.accountList.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.accountList.setMinimumSize(new Dimension(200, 100));
        this.accountList.setAutoscrolls(true);
        this.accountList.expand();
        this.add((Component)this.accountList, "Center");
    }

    private void deleteAccount() {
        Account account;
        if (AccountListPanel.getEngine().getRootAccount() != null && (account = this.accountList.getSelectedAccount()) != null) {
            AccountListPanel.getEngine().removeAccount(account);
        }
    }

    private void createAccount() {
        if (AccountListPanel.getEngine().getRootAccount() != null) {
            AccountTools.createAccount(this.accountList.getSelectedAccount());
        }
    }

    private void modifyAccount() {
        Account account;
        if (AccountListPanel.getEngine().getRootAccount() != null && (account = this.accountList.getSelectedAccount()) != null) {
            AccountTools.modifyAccount(account);
        }
    }

    private void zoomAction() {
        Account account;
        if (AccountListPanel.getEngine().getRootAccount() != null && (account = this.accountList.getSelectedAccount()) != null) {
            RegisterFrame.showDialog(account);
        }
    }

    public AbstractAccountListPane getAccountListPane() {
        return this.accountList;
    }

    public void showAccountFilterDialog() {
        AccountListFilterDialog dlg = new AccountListFilterDialog(this.accountList);
        dlg.setVisible(true);
    }

    private void enableButtons(final boolean e) {
        final JButton[] list = new JButton[]{this.newButton, this.modifyButton, this.reconcileButton, this.deleteButton, this.filterButton, this.zoomButton};
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (JButton button : list) {
                    button.setEnabled(e);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.modifyButton) {
            this.modifyAccount();
        } else if (e.getSource() == this.newButton) {
            this.createAccount();
        } else if (e.getSource() == this.deleteButton) {
            this.deleteAccount();
        } else if (e.getSource() == this.reconcileButton) {
            this.accountList.reconcileAccount();
        } else if (e.getSource() == this.filterButton) {
            this.showAccountFilterDialog();
        } else if (e.getSource() == this.zoomButton) {
            this.zoomAction();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object o = this.accountList.treeTable.getLastSelectedPathComponent();
        if (o != null) {
            Account a = (Account)((DefaultMutableTreeNode)o).getUserObject();
            int count = a.getTransactionCount();
            this.deleteButton.setEnabled(count == 0 && a.getChildCount() == 0);
            this.reconcileButton.setEnabled(count > 0);
        }
    }

    @Override
    public void messagePosted(Message event) {
        if (event.getEvent() == ChannelEvent.FILE_NEW_SUCCESS) {
            this.enableButtons(true);
        } else if (event.getEvent() == ChannelEvent.FILE_LOAD_SUCCESS) {
            this.enableButtons(true);
        } else if (event.getEvent() == ChannelEvent.FILE_CLOSING) {
            this.enableButtons(false);
        }
    }
}

