/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import jgnash.engine.Account;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.account.AccountListTreeTablePane;
import jgnash.ui.account.AccountTools;
import jgnash.ui.actions.ReconcileAccountAction;
import jgnash.ui.register.RegisterFrame;
import jgnash.ui.util.JTableUtils;
import jgnash.util.Resource;

public final class AccountListPanePopUp
extends AccountListTreeTablePane {
    private AccountPopup popup;
    private Resource rb = Resource.get();
    private static final String MODIFY = "mod";
    private static final String NEW = "new";
    private static final String COL_POS = "columnPositions";

    public AccountListPanePopUp() {
        super("list", false);
        MessageBus.getInstance().registerListener(this, MessageChannel.TRANSACTION);
        this.popup = new AccountPopup();
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AccountListPanePopUp.this.checkForPopup(e);
                AccountListPanePopUp.this.checkForDoubleClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AccountListPanePopUp.this.checkForPopup(e);
            }
        });
        JTableUtils.setColumnWidths(this.treeTable, this.p.get(COL_POS, null));
        this.treeTable.setToggleClickCount(10);
    }

    private void checkForPopup(final MouseEvent e) {
        Object o;
        if (e.isPopupTrigger() && (o = this.treeTable.getPathForLocation(e.getX(), e.getY()).getLastPathComponent()) instanceof Account) {
            this.setSelectedAccount((Account)o);
        }
        if (this.getSelectedAccount() != null && this.treeTable.getPathForLocation(e.getX(), e.getY()) != null && e.isPopupTrigger()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountListPanePopUp.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            });
        }
    }

    private void checkForDoubleClick(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            final Object o = this.treeTable.getPathForLocation(e.getX(), e.getY()).getLastPathComponent();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Account a;
                    if (o instanceof DefaultMutableTreeNode && (a = (Account)((DefaultMutableTreeNode)o).getUserObject()) != null) {
                        AccountListPanePopUp.this.setSelectedAccount(a);
                        if (!a.isPlaceHolder()) {
                            RegisterFrame.showDialog(a);
                        }
                    }
                }
            });
        }
    }

    void newAccount() {
        AccountTools.createAccount(this.getSelectedAccount());
    }

    void modifyAccount() {
        if (this.getSelectedAccount() != null) {
            AccountTools.modifyAccount(this.getSelectedAccount());
        }
    }

    void removeAccount() {
        Account account = this.getSelectedAccount();
        if (account != null) {
            if (!account.isLocked()) {
                AccountListPanePopUp.getEngine().removeAccount(account);
            } else {
                StaticUIMethods.displayError(this.rb.getString("Message.AccountLocked"));
            }
        }
    }

    void toggleAccountVisibility() {
        if (this.getSelectedAccount() != null) {
            AccountListPanePopUp.getEngine().toggleAccountVisibility(this.getSelectedAccount());
        }
    }

    void reconcileAccount() {
        ReconcileAccountAction.reconcileAccount(this.getSelectedAccount());
    }

    private void close() {
        this.p.put(COL_POS, JTableUtils.getColumnWidths(this.treeTable));
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccountListPanePopUp.super.messagePosted(event);
                switch (event.getEvent()) {
                    case FILE_CLOSING: {
                        AccountListPanePopUp.this.close();
                        break;
                    }
                    case CURRENCY_MODIFY: 
                    case TRANSACTION_ADD: 
                    case TRANSACTION_REMOVE: {
                        AccountListPanePopUp.this.treeTable.repaint();
                        break;
                    }
                }
            }
        });
    }

    private class AccountPopup
    extends JPopupMenu
    implements ActionListener {
        JMenuItem menuVisible;
        JMenuItem reconcile;
        JMenuItem delete;

        public AccountPopup() {
            JMenuItem menuItem = new JMenuItem(AccountListPanePopUp.this.rb.getString("Menu.New.Name"));
            menuItem.setActionCommand(AccountListPanePopUp.NEW);
            menuItem.addActionListener(this);
            this.add(menuItem);
            menuItem = new JMenuItem(AccountListPanePopUp.this.rb.getString("Menu.Modify.Name"));
            menuItem.setActionCommand(AccountListPanePopUp.MODIFY);
            menuItem.addActionListener(this);
            this.add(menuItem);
            this.delete = new JMenuItem(AccountListPanePopUp.this.rb.getString("Menu.Delete.Name"));
            this.delete.addActionListener(this);
            this.add(this.delete);
            this.addSeparator();
            this.menuVisible = new JMenuItem(AccountListPanePopUp.this.rb.getString("Menu.Hide.Name"));
            this.menuVisible.addActionListener(this);
            this.add(this.menuVisible);
            this.addSeparator();
            this.reconcile = new JMenuItem(AccountListPanePopUp.this.rb.getString("Menu.Reconcile.Name"));
            this.reconcile.addActionListener(this);
            this.add(this.reconcile);
        }

        @Override
        public void show(Component invoker, int x, int y) {
            Account acc = AccountListPanePopUp.this.getSelectedAccount();
            if (acc != null) {
                if (acc.isVisible()) {
                    this.menuVisible.setText(AccountListPanePopUp.this.rb.getString("Menu.Hide.Name"));
                } else {
                    this.menuVisible.setText(AccountListPanePopUp.this.rb.getString("Menu.Show.Name"));
                }
                int count = acc.getTransactionCount();
                this.delete.setEnabled(count == 0 && acc.getChildCount() == 0);
                this.reconcile.setEnabled(count > 0);
            }
            super.show(invoker, x, y);
        }

        @Override
        public void actionPerformed(final ActionEvent actionEvent) {
            final String command = actionEvent.getActionCommand();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (command.equals(AccountListPanePopUp.NEW)) {
                        AccountListPanePopUp.this.newAccount();
                    } else if (actionEvent.getSource() == AccountPopup.this.delete) {
                        AccountListPanePopUp.this.removeAccount();
                    } else if (command.equals(AccountListPanePopUp.MODIFY)) {
                        AccountListPanePopUp.this.modifyAccount();
                    } else if (actionEvent.getSource() == AccountPopup.this.menuVisible) {
                        AccountListPanePopUp.this.toggleAccountVisibility();
                    } else if (actionEvent.getSource() == AccountPopup.this.reconcile) {
                        AccountListPanePopUp.this.reconcileAccount();
                    }
                }
            });
        }
    }
}

