/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RepaintManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultEditorKit;
import jgnash.Main;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.net.currency.CurrencyUpdateFactory;
import jgnash.net.security.AbstractYahooParser;
import jgnash.net.security.SecurityUpdateFactory;
import jgnash.ui.ConsoleDialog;
import jgnash.ui.EDTCheckingRepaintManager;
import jgnash.ui.MainViewPanel;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.ThemeManager;
import jgnash.ui.UIApplication;
import jgnash.ui.account.AccountListPanel;
import jgnash.ui.actions.CloseEngineAction;
import jgnash.ui.actions.ExportAccountsAction;
import jgnash.ui.actions.HelpAction;
import jgnash.ui.actions.ImportAccountsAction;
import jgnash.ui.actions.ImportJgnashAction;
import jgnash.ui.actions.ImportMt940Action;
import jgnash.ui.actions.ImportOfxAction;
import jgnash.ui.actions.ImportQifAction;
import jgnash.ui.actions.OpenAction;
import jgnash.ui.actions.PortfolioReportAction;
import jgnash.ui.actions.SaveFileAsAction;
import jgnash.ui.checks.CheckDesignDialog;
import jgnash.ui.checks.PrintCheckFactory;
import jgnash.ui.commodity.CurrenciesPanel;
import jgnash.ui.commodity.CurrencyExchangeDialog;
import jgnash.ui.commodity.CurrencyModifyDialog;
import jgnash.ui.commodity.SecuritiesHistoryDialog;
import jgnash.ui.commodity.SecurityModifyPanel;
import jgnash.ui.commodity.YahooSecurityHistoryImportDialog;
import jgnash.ui.components.MemoryMonitor;
import jgnash.ui.components.WaitMessagePanel;
import jgnash.ui.option.OptionDialog;
import jgnash.ui.recurring.RecurringPanel;
import jgnash.ui.register.MainRegisterPanel;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterFrame;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.report.compiled.AccountRegisterReport;
import jgnash.ui.report.compiled.BalanceSheetReport;
import jgnash.ui.report.compiled.IncomeExpensePieChart;
import jgnash.ui.report.compiled.MonthBalanceCSV;
import jgnash.ui.report.compiled.MonthlyAccountBalanceChart;
import jgnash.ui.report.compiled.NetWorthReport;
import jgnash.ui.report.compiled.PayeePieChart;
import jgnash.ui.report.compiled.ProfitLossReport;
import jgnash.ui.report.compiled.ProfitLossTXT;
import jgnash.ui.report.compiled.RunningAccountBalanceChart;
import jgnash.ui.report.compiled.SecurityHighLowChart;
import jgnash.ui.splash.AboutDialog;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.builder.ActionParser;
import jgnash.ui.wizards.file.NewFileDialog;
import jgnash.util.DefaultDaemonThreadFactory;
import jgnash.util.Resource;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXStatusBar;

public class MainFrame
extends JXFrame
implements MessageListener,
ActionListener {
    private static final String REGISTER_KEY = "register";
    private static final String JAVASCRIPT_DIR = "javascriptdir";
    private static final String REGSITER_FOLLOWS_LIST = "RegisterFollowsList";
    private JMenu windowMenu;
    private JMenu viewMenu;
    private JMenu reportMenu;
    private MainViewPanel mainView;
    private final Preferences pref = Preferences.userNodeForPackage(MainFrame.class);
    private final Resource rb = Resource.get();
    private WaitMessagePanel waitPanel;
    private static boolean registerFollowsTree = MainFrame.doesRegisterFollowTree();
    private MainRegisterPanel registerTreePanel;
    private Action editAction;
    private Action filterAction;
    private Action toolAction;
    private AccountListPanel treePane;
    private JTextField statusField;
    private final Logger log = Logger.getLogger(MainFrame.class.getName());
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new DefaultDaemonThreadFactory());
    private static final int SCHEDULED_DELAY = 10;
    private JXBusyLabel backgroundOperationLabel;
    private LogHandler logHandler = new LogHandler();
    private Color infoColor = null;

    public MainFrame() {
        ThemeManager themeManager = new ThemeManager((JFrame)((Object)this));
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Resource.getLocale()));
        this.setIconImage(Resource.getImage("/jgnash/resource/gnome-money.png"));
        this.buildUI();
        this.setDefaultCloseOperation(2);
        if (Main.checkEDT()) {
            this.log.info("Installing Event Dispatch Thread Checker into RepaintManager");
            RepaintManager.setCurrentManager(new EDTCheckingRepaintManager());
        }
        this.viewMenu.insertSeparator(this.viewMenu.getComponentCount() + 1);
        this.viewMenu.add(themeManager.buildLookAndFeelMenu());
        this.viewMenu.add(themeManager.buildThemeMenu());
        this.addWindowListener(new ShutdownAdapter());
        RegisterFrame.addRegisterListener(new RegisterListener(){

            @Override
            public void registerEvent(RegisterEvent e) {
                if (e.getAction() == RegisterEvent.Action.OPEN) {
                    MainFrame.this.addWindowItem(e);
                } else if (e.getAction() == RegisterEvent.Action.CLOSE) {
                    MainFrame.this.removeWindowItem(e);
                }
            }
        });
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT);
        MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
        this.registerLogHandler(Engine.class);
        this.registerLogHandler(EngineFactory.class);
        this.registerLogHandler(AbstractYahooParser.class);
        this.registerLogHandler(UIApplication.class);
        SecurityUpdateFactory.getUpdateOnStartup();
        this.registerLogHandler(SecurityUpdateFactory.class);
        this.pack();
        DialogUtils.addBoundsListener((Window)((Object)this));
        this.log.fine("UI Construction is complete");
        if (EngineFactory.getEngine("default") != null) {
            this.setOpenState(true);
            this.addViews();
            this.updateTitle();
        }
    }

    private void registerLogHandler(Class<?> clazz) {
        Logger.getLogger(clazz.getName()).addHandler(this.logHandler);
    }

    private void displayWarning(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.statusField.setForeground(Color.RED);
                MainFrame.this.statusField.setText(message);
            }
        });
    }

    final void displayStatus(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.statusField.setForeground(MainFrame.this.infoColor);
                MainFrame.this.statusField.setText(message);
            }
        });
    }

    public void displayWaitMessage(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.waitPanel.setMessage(message);
                MainFrame.this.waitPanel.setWaiting(true);
                MainFrame.this.setWaiting(true);
            }
        });
    }

    public void setNetworkBusy(boolean busy) {
        this.backgroundOperationLabel.setBusy(busy);
    }

    public void stopWaitMessage() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.waitPanel.setWaiting(false);
                MainFrame.this.setWaiting(false);
            }
        });
    }

    public static void setRegisterFollowsTree(boolean follow) {
        Preferences pref = Preferences.userNodeForPackage(MainFrame.class);
        registerFollowsTree = follow;
        pref.putBoolean(REGSITER_FOLLOWS_LIST, follow);
    }

    public static boolean doesRegisterFollowTree() {
        Preferences pref = Preferences.userNodeForPackage(MainFrame.class);
        return pref.getBoolean(REGSITER_FOLLOWS_LIST, true);
    }

    public void addRemoveCurrencies() {
        CurrenciesPanel.showDialog((JFrame)((Object)this));
    }

    private void buildMainView() {
        this.mainView = new MainViewPanel();
        this.mainView.setBorder(new EmptyBorder(new Insets(5, 2, 3, 0)));
        this.mainView.addActionListener(this);
    }

    private void addViews() {
        this.treePane = new AccountListPanel();
        this.registerTreePanel = new MainRegisterPanel();
        ImageIcon list = Resource.getIcon("/jgnash/resource/account-list.png");
        this.mainView.addView(this.treePane, list, this.rb.getString("Button.Accounts"), this.rb.getString("ToolTip.AccountList"));
        ImageIcon register = Resource.getIcon("/jgnash/resource/register.png");
        this.mainView.addView(this.registerTreePanel, register, this.rb.getString("Button.Register"), this.rb.getString("ToolTip.AccountRegister"));
        ImageIcon recurring = Resource.getIcon("/jgnash/resource/gnome-calendar.png");
        this.mainView.addView(new RecurringPanel(), recurring, this.rb.getString("Button.Reminders"), this.rb.getString("ToolTip.Reminders"));
    }

    private void removeViews() {
        this.mainView.removeAll();
        this.treePane = null;
        this.registerTreePanel = null;
    }

    private void buildUI() {
        ActionParser actionParser = new ActionParser(this, Resource.get());
        actionParser.preLoadAction("copy-command", new DefaultEditorKit.CopyAction());
        actionParser.preLoadAction("cut-command", new DefaultEditorKit.CutAction());
        actionParser.preLoadAction("paste-command", new DefaultEditorKit.PasteAction());
        actionParser.preLoadAction("qifimport-command", new ImportQifAction());
        actionParser.preLoadAction("mt940import-command", new ImportMt940Action());
        actionParser.preLoadAction("ofximport-command", new ImportOfxAction());
        actionParser.preLoadAction("accountsimport-command", new ImportAccountsAction());
        actionParser.preLoadAction("exportAccounts-command", new ExportAccountsAction());
        actionParser.preLoadAction("report-portfolio-command", new PortfolioReportAction());
        actionParser.preLoadAction("close-command", new CloseEngineAction());
        actionParser.preLoadAction("saveas-command", new SaveFileAsAction());
        actionParser.preLoadAction("help-command", new HelpAction());
        actionParser.loadFile("/jgnash/resource/main-frame-actions.xml");
        JMenuBar menuBar = actionParser.createMenuBar("main-menu");
        JToolBar toolBar = actionParser.createToolBar("main-toolbar");
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.viewMenu = (JMenu)actionParser.getJMenuItem("view-menu-command");
        this.reportMenu = (JMenu)actionParser.getJMenuItem("report-menu-command");
        this.windowMenu = (JMenu)actionParser.getJMenuItem("window-menu-command");
        this.windowMenu.setEnabled(false);
        this.editAction = actionParser.getAction("edit-menu-command");
        this.filterAction = actionParser.getAction("filter-menu-command");
        this.toolAction = actionParser.getAction("tools-menu-command");
        if (EngineFactory.getEngine("default") == null) {
            this.setOpenState(false);
        }
        this.setTitle(Main.VERSION);
        this.buildMainView();
        this.backgroundOperationLabel = new JXBusyLabel(new Dimension(18, 18));
        this.statusField = new JTextField();
        this.statusField.setEditable(false);
        this.statusField.setFont(this.statusField.getFont().deriveFont(this.statusField.getFont().getSize2D() - 1.0f));
        this.infoColor = this.statusField.getForeground();
        JXStatusBar statusBar = new JXStatusBar();
        JXStatusBar.Constraint c1 = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
        statusBar.add((Component)this.statusField, (Object)c1);
        statusBar.setResizeHandleEnabled(true);
        statusBar.add((Component)this.backgroundOperationLabel);
        statusBar.add((Component)new MemoryMonitor(), (Object)new JXStatusBar.Constraint(120));
        this.setToolBar(toolBar);
        this.setStatusBar(statusBar);
        this.setJMenuBar(menuBar);
        this.getContentPane().add((Component)this.mainView, "Center");
        this.waitPanel = new WaitMessagePanel();
        this.setWaitPane((Component)((Object)this.waitPanel));
    }

    void loadLast() {
        OpenAction.openLastAction();
        this.startBackgroundUpdates();
    }

    void loadFile(File file) {
        OpenAction.openAction(file);
        this.startBackgroundUpdates();
    }

    void openRemote(String host, int port, String user, String password) {
        OpenAction.openRemote(host, port, user, password);
        this.startBackgroundUpdates();
    }

    private void startBackgroundUpdates() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SecurityUpdateFactory.getUpdateOnStartup()) {
                    MainFrame.this.executor.schedule(SecurityUpdateFactory.getUpdateWorker(), 10L, TimeUnit.SECONDS);
                }
                if (CurrencyUpdateFactory.getUpdateOnStartup()) {
                    MainFrame.this.executor.schedule(CurrencyUpdateFactory.getUpdateWorker(), 10L, TimeUnit.SECONDS);
                }
            }
        });
    }

    public void startBackgroundSecurityUpdate() {
        this.executor.schedule(SecurityUpdateFactory.getUpdateWorker(), 1L, TimeUnit.SECONDS);
    }

    public void startBackgroundCurrencyUpdate() {
        this.executor.schedule(CurrencyUpdateFactory.getUpdateWorker(), 1L, TimeUnit.SECONDS);
    }

    private void mainViewAction() {
        if (this.mainView.getVisibleComponent() == this.registerTreePanel && registerFollowsTree) {
            this.registerTreePanel.setAccount(this.treePane.getAccountListPane().getSelectedAccount());
        }
    }

    public void modifyCurrencies() {
        CurrencyModifyDialog.showDialog((JFrame)((Object)this));
    }

    public void newFile() {
        NewFileDialog.showDialog((Frame)((Object)this));
    }

    public void openFile() {
        OpenAction.openAction();
        this.startBackgroundUpdates();
    }

    public void runJavaScript() {
        JFileChooser chooser = new JFileChooser(this.pref.get(JAVASCRIPT_DIR, null));
        if (chooser.showOpenDialog((Component)((Object)this)) == 0) {
            this.pref.put(JAVASCRIPT_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            final String file = chooser.getSelectedFile().getAbsolutePath();
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FileReader reader = null;
                    try {
                        reader = new FileReader(file);
                        new ScriptEngineManager().getEngineByName("JavaScript").eval(reader);
                    }
                    catch (Exception e) {
                        MainFrame.this.log.log(Level.SEVERE, e.toString(), e);
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
    }

    private void setOpenState(boolean state) {
        this.editAction.setEnabled(state);
        this.filterAction.setEnabled(state);
        this.toolAction.setEnabled(state);
        this.reportMenu.setEnabled(state);
    }

    private void updateTitle() {
        Engine e = EngineFactory.getEngine("default");
        if (e != null) {
            this.setTitle(Main.VERSION + "  [" + EngineFactory.getActiveDatabase() + "]");
        } else {
            this.setTitle(Main.VERSION);
        }
    }

    public void showAboutDialog() {
        AboutDialog.showDialog((Frame)((Object)this));
    }

    public void showAccountListFilter() {
        this.treePane.showAccountFilterDialog();
    }

    public void showCommodityHistoryDialog() {
        SecuritiesHistoryDialog.showDialog((JFrame)((Object)this));
    }

    public void showCommodityHistoryImportDialog() {
        new YahooSecurityHistoryImportDialog().setVisible(true);
    }

    public void showCommodityModifyDialog() {
        SecurityModifyPanel.showDialog((JFrame)((Object)this));
    }

    public void showCurrencyExchangeDialog() {
        CurrencyExchangeDialog.showDialog((JFrame)((Object)this));
    }

    public void showDefaultCurrencyDialog() {
        StaticUIMethods.setDefaultCurrency((JFrame)((Object)this));
    }

    public void showDefaultLocaleDialog() {
        StaticUIMethods.setDefaultLocale((JFrame)((Object)this));
    }

    public void showConsoleWindow() {
        ConsoleDialog.show();
    }

    public void showAccountRegisterReport() {
        new AccountRegisterReport(null).showReport();
    }

    public void showBalanceSheetReport() {
        new BalanceSheetReport().showReport();
    }

    public void showIncomeExpenseChart() {
        IncomeExpensePieChart.show();
    }

    public void showPayeePieChart() {
        PayeePieChart.show();
    }

    public void showRunningAccountBalanceChart() {
        RunningAccountBalanceChart.show();
    }

    public void showMonthlyAccountBalanceChart() {
        MonthlyAccountBalanceChart.show();
    }

    public void showMonthBalanceCSV() {
        MonthBalanceCSV.run();
    }

    public void showNetWorthReport() {
        new NetWorthReport().showReport();
    }

    public void showProfitLossReport() {
        new ProfitLossReport().showReport();
    }

    public void showProfitLossTXTReport() {
        new ProfitLossTXT();
    }

    public void showSecurityHighLowChart() {
        SecurityHighLowChart.show();
    }

    public void showDesignChecksDialog() {
        new CheckDesignDialog((Frame)((Object)this), true).setVisible(true);
    }

    public void showPrintChecksDialog() {
        PrintCheckFactory.showDialog();
    }

    public void showOptionsDialog() {
        OptionDialog.showDialog();
    }

    public void showRecurringDialog() {
        RecurringPanel.showDialog((Frame)((Object)this));
    }

    public void showRegisterFilter() {
        this.registerTreePanel.showAccountFilterDialog();
    }

    public void shutDown() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.dispatchEvent(new WindowEvent((Window)((Object)MainFrame.this), 201));
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.mainView) {
            this.mainViewAction();
        }
    }

    private void addWindowItem(final RegisterEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegisterFrame d = (RegisterFrame)e.getSource();
                JMenuItem mi = new JMenuItem(new WindowAction(d));
                int size = MainFrame.this.windowMenu.getMenuComponentCount();
                MainFrame.this.windowMenu.insert(mi, size - 2);
                MainFrame.this.windowMenu.setEnabled(true);
            }
        });
    }

    private void removeWindowItem(final RegisterEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegisterFrame d = (RegisterFrame)e.getSource();
                for (Component c : MainFrame.this.windowMenu.getMenuComponents()) {
                    JMenuItem m;
                    if (!(c instanceof JMenuItem) || !((m = (JMenuItem)c).getAction() instanceof WindowAction) || d != m.getAction().getValue(MainFrame.REGISTER_KEY)) continue;
                    MainFrame.this.windowMenu.remove(c);
                    if (MainFrame.this.windowMenu.getItemCount() < 3) {
                        MainFrame.this.windowMenu.setEnabled(false);
                    }
                    return;
                }
            }
        });
    }

    public void closeAllWindows() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : MainFrame.this.windowMenu.getMenuComponents()) {
                    JMenuItem m;
                    if (!(c instanceof JMenuItem) || !((m = (JMenuItem)c).getAction() instanceof WindowAction)) continue;
                    RegisterFrame d = (RegisterFrame)m.getAction().getValue(MainFrame.REGISTER_KEY);
                    d.dispatchEvent(new WindowEvent(d, 201));
                }
            }
        });
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case FILE_CLOSING: {
                        MainFrame.this.setOpenState(false);
                        MainFrame.this.updateTitle();
                        MainFrame.this.removeViews();
                        break;
                    }
                    case FILE_NOT_FOUND: {
                        break;
                    }
                    case FILE_IO_ERROR: {
                        break;
                    }
                    case FILE_LOAD_FAILED: {
                        break;
                    }
                    case ACCOUNT_REMOVE_FAILED: {
                        StaticUIMethods.displayError(MainFrame.this.rb.getString("Message.ErrorAccoutRemove"));
                        break;
                    }
                    case FILE_LOAD_SUCCESS: 
                    case FILE_NEW_SUCCESS: {
                        MainFrame.this.setOpenState(true);
                        MainFrame.this.addViews();
                        MainFrame.this.updateTitle();
                        break;
                    }
                }
            }
        });
    }

    public void importOldJgnash() {
        ImportJgnashAction.importAction((JFrame)((Object)this));
    }

    void dispose(boolean shutDown) {
        if (!shutDown) {
            for (WindowListener listener : this.getWindowListeners()) {
                if (!(listener instanceof ShutdownAdapter)) continue;
                this.removeWindowListener(listener);
            }
        }
        super.dispose();
    }

    private class LogHandler
    extends Handler {
        private LogHandler() {
        }

        @Override
        public synchronized void publish(final LogRecord record) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (record.getLevel() == Level.WARNING || record.getLevel() == Level.SEVERE) {
                        MainFrame.this.displayWarning(record.getMessage());
                    } else {
                        MainFrame.this.displayStatus(record.getMessage());
                    }
                }
            });
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private class ShutdownAdapter
    extends WindowAdapter {
        private ShutdownAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.closeAllWindows();
                    MainFrame.this.removeViews();
                    EngineFactory.closeEngine("default");
                    System.exit(0);
                }
            });
        }
    }

    private static class WindowAction
    extends AbstractAction {
        private static final long serialVersionUID = -598477156303870342L;

        protected WindowAction(RegisterFrame d) {
            super(d.toString());
            this.putValue(MainFrame.REGISTER_KEY, d);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final RegisterFrame d = (RegisterFrame)this.getValue(MainFrame.REGISTER_KEY);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (d.getExtendedState() == 1) {
                        d.setExtendedState(0);
                    }
                    d.toFront();
                }
            });
        }
    }
}

