/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.db4o;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.CommodityNode;
import jgnash.engine.CurrencyNode;
import jgnash.engine.ExchangeRate;
import jgnash.engine.ExchangeRateHistoryNode;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.engine.dao.CommodityDAO;
import jgnash.engine.db4o.AbstractDb4oDAO;

class Db4oCommodityDAO
extends AbstractDb4oDAO
implements CommodityDAO {
    private Logger logger = Logger.getLogger(Db4oCommodityDAO.class.getName());

    Db4oCommodityDAO(ObjectContainer container, boolean isRemote) {
        super(container, isRemote);
    }

    @Override
    public synchronized boolean addCommodity(CommodityNode node) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set((Object)node);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public boolean addSecurityHistory(SecurityNode node, SecurityHistoryNode hNode) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set((Object)hNode);
            this.container.set((Object)node);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public boolean addExchangeRateHistory(ExchangeRate rate, ExchangeRateHistoryNode hNode) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set((Object)rate);
            this.container.set((Object)hNode);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public boolean removeExchangeRateHistory(ExchangeRate rate, ExchangeRateHistoryNode hNode) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.delete((Object)hNode);
            this.container.ext().purge((Object)hNode);
            this.container.set((Object)rate);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public synchronized List<CurrencyNode> getCurrencies() {
        List<CurrencyNode> list = Collections.emptyList();
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            Query query = this.container.query();
            query.constrain(CurrencyNode.class);
            query.descend("markedForRemoval").constrain((Object)Boolean.FALSE);
            list = new ArrayList<CurrencyNode>((Collection<CurrencyNode>)query.execute());
            this.container.ext().releaseSemaphore("Lock");
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return list;
    }

    @Override
    public ExchangeRate getExchangeNode(String rateId) {
        ExchangeRate rate = null;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            Query query = this.container.query();
            query.constrain(ExchangeRate.class);
            query.descend("rateId").constrain((Object)rateId);
            ObjectSet result = query.execute();
            if (result.size() == 1) {
                rate = (ExchangeRate)result.get(0);
            }
            this.container.ext().releaseSemaphore("Lock");
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return rate;
    }

    @Override
    public synchronized List<SecurityNode> getSecurities() {
        List<SecurityNode> list = Collections.emptyList();
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            list = Db4oCommodityDAO.stripMarkedForRemoval(new ArrayList(this.container.query(SecurityNode.class)));
            this.container.ext().releaseSemaphore("Lock");
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return list;
    }

    @Override
    public synchronized List<ExchangeRate> getExchangeRates() {
        List<ExchangeRate> list = Collections.emptyList();
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            list = Db4oCommodityDAO.stripMarkedForRemoval(new ArrayList(this.container.query(ExchangeRate.class)));
            this.container.ext().releaseSemaphore("Lock");
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return list;
    }

    @Override
    public boolean removeSecurityHistory(SecurityNode node, SecurityHistoryNode hNode) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.delete((Object)hNode);
            this.container.ext().purge((Object)hNode);
            this.container.set((Object)node);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public void addExchangeRate(ExchangeRate eRate) {
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set((Object)eRate);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
    }

    @Override
    public void refreshCommodityNode(CommodityNode node) {
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.ext().refresh((Object)node, 2);
            this.container.ext().releaseSemaphore("Lock");
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
    }

    @Override
    public void refreshExchangeRate(ExchangeRate rate) {
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.ext().refresh((Object)rate, 2);
            this.container.ext().releaseSemaphore("Lock");
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
    }

    @Override
    public synchronized boolean updateCommodityNode(CommodityNode node) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set((Object)node);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public Set<CurrencyNode> getActiveCurrencies() {
        HashSet<CurrencyNode> currencies = new HashSet<CurrencyNode>();
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            ActiveAccountCurrencyPredicate accountPredicate = new ActiveAccountCurrencyPredicate();
            ActiveSecurityCurrencyPredicate securityPredicate = new ActiveSecurityCurrencyPredicate();
            this.container.query((Predicate)accountPredicate);
            this.container.query((Predicate)securityPredicate);
            this.container.ext().releaseSemaphore("Lock");
            currencies.addAll(accountPredicate.getCurrencyNodes());
            currencies.addAll(securityPredicate.getCurrencyNodes());
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return currencies;
    }

    private static class ActiveSecurityCurrencyPredicate
    extends Predicate<SecurityNode> {
        private static final long serialVersionUID = -652916106551112316L;
        private Set<CurrencyNode> set = new HashSet<CurrencyNode>();

        private ActiveSecurityCurrencyPredicate() {
        }

        public boolean match(SecurityNode node) {
            this.set.add(node.getReportedCurrencyNode());
            return false;
        }

        public Set<CurrencyNode> getCurrencyNodes() {
            return this.set;
        }
    }

    private static class ActiveAccountCurrencyPredicate
    extends Predicate<Account> {
        private static final long serialVersionUID = -652916106551112316L;
        private Set<CurrencyNode> set = new HashSet<CurrencyNode>();

        private ActiveAccountCurrencyPredicate() {
        }

        public boolean match(Account account) {
            this.set.add(account.getCurrencyNode());
            return false;
        }

        public Set<CurrencyNode> getCurrencyNodes() {
            return this.set;
        }
    }
}

