/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import jgnash.engine.StoredObject;

public abstract class CommodityNode
extends StoredObject
implements Comparable<CommodityNode> {
    private static final long serialVersionUID = -8694706937407227601L;
    private String symbol;
    private byte scale = (byte)2;
    private String prefix = "";
    private String suffix = "";
    private String description;

    public void setScale(byte scale) {
        this.scale = scale;
    }

    public byte getScale() {
        return this.scale;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        if (this.description != null) {
            return this.symbol + " (" + this.description + ")";
        }
        return this.symbol;
    }

    @Override
    public int compareTo(CommodityNode node) {
        return this.symbol.compareTo(node.symbol);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof CommodityNode && this.getUuid().equals(((CommodityNode)other).getUuid());
    }

    @Override
    public int hashCode() {
        return this.getUuid().hashCode();
    }

    public boolean matches(CommodityNode other) {
        boolean result = this.equals(other);
        if (!result) {
            result = this.getSymbol().equals(other.getSymbol());
        }
        return result;
    }

    public BigDecimal round(double value) {
        return new BigDecimal(value).setScale((int)this.scale, 6);
    }
}

