/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import jgnash.engine.Account;
import jgnash.engine.AccountType;

public class AccountUtils {
    protected static Account searchTree(Account root, String name, AccountType type, int depth) {
        Account match = null;
        for (Account a : root.getChildren()) {
            if (a.getName().equals(name) && a.getAccountType().equals((Object)type) && AccountUtils.getDepth(a) == depth) {
                match = a;
            } else if (a.getChildCount() > 0) {
                match = AccountUtils.searchTree(a, name, type, depth);
            }
            if (match == null) continue;
            break;
        }
        return match;
    }

    protected static int getDepth(Account account) {
        int depth = 0;
        if (account.getParent() != null) {
            ++depth;
            depth += AccountUtils.getDepth(account.getParent());
        }
        return depth;
    }

    private AccountUtils() {
    }
}

