/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import jgnash.engine.SecurityNode;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionTag;
import jgnash.engine.TransactionType;

public abstract class AbstractInvestmentTransactionEntry
extends TransactionEntry {
    private SecurityNode securityNode;
    private BigDecimal price;
    private BigDecimal quantity;

    AbstractInvestmentTransactionEntry() {
        this.setTransactionTag(TransactionTag.INVESTMENT);
    }

    public BigDecimal getTotal() {
        return this.getQuantity().multiply(this.getPrice());
    }

    public SecurityNode getSecurityNode() {
        return this.securityNode;
    }

    void setSecurityNode(SecurityNode securityNode) {
        this.securityNode = securityNode;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    void setPrice(BigDecimal price) {
        this.price = price;
    }

    void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public abstract BigDecimal getSignedQuantity();

    public abstract TransactionType getTransactionType();

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(super.toString());
        b.append("Security:       ").append(this.getSecurityNode().getSymbol()).append("\n");
        b.append("Quantity:       ").append(this.getQuantity().toPlainString()).append("\n");
        b.append("Price:          ").append(this.getPrice().toPlainString()).append("\n");
        return b.toString();
    }
}

