/*
 * Decompiled with CFR 0.152.
 */
package jgnash;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import jgnash.engine.Engine;
import jgnash.engine.db4o.Db4oNetworkServer;
import jgnash.net.NetworkAuthenticator;
import jgnash.net.security.AbstractYahooParser;
import jgnash.ui.MainFrame;
import jgnash.ui.UIApplication;
import jgnash.ui.account.AccountListPanel;
import jgnash.ui.actions.OpenAction;
import jgnash.util.FileUtils;
import jgnash.util.Resource;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class Main {
    public static final String VERSION;
    @Option(name="-opengl", usage="Enable OpenGL acceleration")
    private boolean opengl;
    @Option(name="-uninstall", usage="Remove registry settings")
    private boolean uninstall;
    @Option(name="-portable", usage="Enable portable preferences")
    private boolean portable;
    @Option(name="-portableFile", usage="Location for portable file")
    private String portableFile;
    @Option(name="-port", usage="Network port")
    private int port;
    @Option(name="-client", usage="Server host name or address")
    private String host;
    @Option(name="-file", usage="File to load at start")
    private File file;
    @Option(name="-server", usage="Act as a server using the specified file")
    private File server;
    @Option(name="-user", usage="Client or Server user name")
    private String user;
    @Option(name="-password", usage="Client or Server password")
    private String password;
    @Option(name="-enableEDT", usage="Check for EDT violations")
    private static boolean enableEDT;
    private static final int DEFAULT_PORT = 5300;

    public static boolean checkEDT() {
        return enableEDT;
    }

    private static boolean checkJVMVersion() {
        float version = Main.getJVMVersion();
        boolean result = true;
        if (version < 1.6f) {
            System.out.println(Resource.get().getString("Message.JVM6"));
            System.out.println(Resource.get().getString("Message.Version") + System.getProperty("java.version") + "\n");
            result = false;
        }
        return result;
    }

    private static float getJVMVersion() {
        return Float.parseFloat(System.getProperty("java.version").substring(0, 3));
    }

    public static synchronized void shutDown() {
        System.out.println(Resource.get().getString("Message.Shutdown"));
        System.exit(0);
    }

    public static boolean isSystemOSX() {
        String os = System.getProperty("os.name");
        return os.startsWith("Darwin") || os.startsWith("Mac");
    }

    public static boolean isSystemWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static void configureLogging() {
        Handler[] handlers;
        for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
            handler.setLevel(Level.ALL);
        }
        Logger.getLogger(AccountListPanel.class.getName()).setLevel(Level.ALL);
        Logger.getLogger(Engine.class.getName()).setLevel(Level.ALL);
        Logger.getLogger(MainFrame.class.getName()).setLevel(Level.ALL);
        Logger.getLogger(OpenAction.class.getName()).setLevel(Level.ALL);
        Logger.getLogger(AbstractYahooParser.class.getName()).setLevel(Level.ALL);
    }

    private static void enableAntialiasing() {
        System.out.println(Resource.get().getString("Message.Antialias"));
        System.setProperty("swing.aatext", "true");
    }

    public static void main(String[] args) {
        if (Main.checkJVMVersion()) {
            new Main(args);
        }
    }

    private static void setupNetworking() {
        Preferences auth = Preferences.userRoot().node("/jgnash/http");
        if (auth.getBoolean("useproxy", false)) {
            String proxyHost = auth.get("proxyhost", "");
            String proxyPort = auth.get("proxyport", "");
            System.getProperties().put("http.proxyHost", proxyHost);
            System.getProperties().put("http.proxyPort", proxyPort);
            Authenticator.setDefault(new NetworkAuthenticator());
            System.out.println(Resource.get().getString("Message.Proxy") + proxyHost + ":" + proxyPort);
        }
    }

    private static void deleteUserPreferences() {
        try {
            Preferences prefs = Preferences.userRoot();
            if (prefs.nodeExists("/jgnash")) {
                Preferences jgnash = prefs.node("/jgnash");
                jgnash.removeNode();
                prefs.flush();
            } else {
                System.err.println(Resource.get().getString("Message.PrefFail"));
            }
        }
        catch (BackingStoreException bse) {
            System.err.println(Resource.get().getString("Message.UninstallBad"));
        }
    }

    private Main(String[] args) {
        block20: {
            Main.configureLogging();
            CmdLineParser parser = new CmdLineParser(this);
            try {
                parser.parseArgument(args);
                if (args.length == 1 && !args[0].startsWith("-")) {
                    File testFile = new File(args[0]);
                    if (testFile.exists()) {
                        this.file = testFile;
                    } else {
                        System.err.println(args[0] + " was not a valid file");
                    }
                }
                if (this.port <= 0) {
                    this.port = 5300;
                }
                if (this.uninstall) {
                    Main.deleteUserPreferences();
                    break block20;
                }
                if (this.server != null) {
                    try {
                        if (!FileUtils.isFileLocked(this.server.getAbsolutePath())) {
                            Db4oNetworkServer netserver = new Db4oNetworkServer();
                            netserver.runServer(this.server.getAbsolutePath(), this.port, this.user, this.password);
                            break block20;
                        }
                        System.err.println(Resource.get().getString("Message.FileIsLocked"));
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("File " + this.server.getAbsolutePath() + " was not found");
                    }
                    break block20;
                }
                if (this.portable || this.portableFile != null) {
                    System.setProperty("java.util.prefs.PreferencesFactory", "jgnash.util.prefs.MapPreferencesFactory");
                    try {
                        this.importPreferences();
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Preferences file " + this.getPreferenceFile().getAbsolutePath() + " was not found");
                    }
                    Runtime.getRuntime().addShutdownHook(new ExportPreferencesThread());
                }
                Main.enableAntialiasing();
                if (this.opengl) {
                    System.out.println(Resource.get().getString("Message.OpenGL"));
                    System.setProperty("sun.java2d.opengl", "true");
                }
                if (Main.isSystemOSX()) {
                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                }
                Main.setupNetworking();
                if (this.host != null) {
                    new UIApplication(this.host, this.port, this.user, this.password);
                } else if (this.file != null && this.file.exists()) {
                    new UIApplication(this.file);
                } else {
                    new UIApplication(null);
                }
            }
            catch (CmdLineException e) {
                System.err.println(e.getMessage());
                parser.printUsage(System.err);
            }
        }
    }

    private File getPreferenceFile() {
        File exportFile;
        if (this.portableFile != null && !this.portableFile.isEmpty()) {
            exportFile = new File(this.portableFile);
        } else {
            String base = System.getProperty("user.dir");
            String filesep = System.getProperty("file.separator");
            exportFile = new File(base + filesep + "pref.xml");
        }
        return exportFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPreferences() throws FileNotFoundException {
        File importFile = this.getPreferenceFile();
        if (importFile.canRead()) {
            Logger.getLogger(Main.class.getName()).info("Importing preferences");
            FileInputStream is = new FileInputStream(importFile);
            try {
                Preferences.importPreferences(is);
            }
            catch (FileNotFoundException e) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
            }
            catch (IOException e) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
            }
            catch (InvalidPreferencesFormatException e) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    static {
        ResourceBundle rb = ResourceBundle.getBundle("jgnash/resource/constants");
        VERSION = rb.getString("name") + " - " + rb.getString("version");
    }

    private class ExportPreferencesThread
    extends Thread {
        private ExportPreferencesThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger.getLogger(Main.class.getName()).info("Exporting preferences");
            File exportFile = Main.this.getPreferenceFile();
            Preferences prefs = Preferences.userRoot();
            try {
                FileOutputStream os = new FileOutputStream(exportFile);
                try {
                    if (prefs.nodeExists("/jgnash")) {
                        Preferences p = prefs.node("/jgnash");
                        p.exportSubtree(os);
                    }
                    Main.deleteUserPreferences();
                }
                catch (BackingStoreException e) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
                catch (FileNotFoundException e) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
                catch (IOException e) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
            }
        }
    }
}

