/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jgnash.util.FileUtils;

public class FileMagic {
    public static FileType magic(File file) {
        if (FileMagic.isdb4o(file)) {
            return FileType.db4o;
        }
        if (FileMagic.isValidjGnash1File(file)) {
            return FileType.jGnash1XML;
        }
        if (FileMagic.isValidjGnash2File(file)) {
            return FileType.jGnash2XML;
        }
        if (FileMagic.isOfxV1(file)) {
            return FileType.OfxV1;
        }
        if (FileMagic.isOfxV2(file)) {
            return FileType.OfxV2;
        }
        return FileType.unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOfxV1Encoding(File file) {
        String encoding = null;
        String charset = null;
        if (file.exists()) {
            Logger logger = Logger.getLogger(FileUtils.class.getName());
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0) {
                        String[] splits;
                        if (line.startsWith("ENCODING:")) {
                            splits = line.split(":");
                            if (splits.length == 2) {
                                encoding = splits[1];
                            }
                        } else if (line.startsWith("CHARSET:") && (splits = line.split(":")).length == 2) {
                            charset = splits[1];
                        }
                        if (encoding != null && charset != null) {
                            break;
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        }
        if (encoding != null && charset != null) {
            if (encoding.equals("UTF-8")) {
                return "UTF-8";
            }
            if (encoding.equals("USASCII") && charset.equals("1252")) {
                return "windows-1252";
            }
            if (encoding.equals("USASCII") && charset.equals("ISO-8859-1")) {
                return "ISO-8859-1";
            }
            if (encoding.equals("USASCII") && charset.equals("NONE")) {
                return "windows-1252";
            }
        }
        return "windows-1252";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOfxV1(File file) {
        boolean result = false;
        if (file.exists()) {
            Logger logger = Logger.getLogger(FileUtils.class.getName());
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0) {
                        if (line.startsWith("OFXHEADER:")) {
                            result = true;
                        }
                        break;
                    }
                    line = reader.readLine();
                }
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOfxV2(File file) {
        boolean result = false;
        if (!file.exists()) return result;
        Logger logger = Logger.getLogger(FileUtils.class.getName());
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && line.startsWith("<?")) {
                    if (line.startsWith("<?OFX") && line.contains("OFXHEADER=\"200\"")) {
                        result = true;
                        return result;
                    }
                } else if (line.length() > 0) {
                    if (!line.startsWith("<OFX>")) return result;
                    result = true;
                    return result;
                }
                line = reader.readLine();
            }
            return result;
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            return result;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            return result;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isdb4o(File file) {
        boolean result = false;
        if (file.exists()) {
            Logger log = Logger.getLogger(FileUtils.class.getName());
            RandomAccessFile di = null;
            try {
                byte[] header = new byte[4];
                di = new RandomAccessFile(file, "r");
                if (di.length() > 0L) {
                    di.readFully(header);
                    if (new String(header).equals("db4o")) {
                        result = true;
                    }
                }
                di.close();
            }
            catch (FileNotFoundException ex) {
                log.log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
            }
            finally {
                if (di != null) {
                    try {
                        di.close();
                    }
                    catch (IOException ex) {
                        log.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return result;
    }

    public static boolean isValidjGnash1File(File file) {
        return FileMagic.isValidjGnashX(file, "1");
    }

    private static boolean isValidjGnash2File(File file) {
        return FileMagic.isValidjGnashX(file, "2");
    }

    private static boolean isValidjGnashX(File file, String majorVersion) {
        return FileMagic.getjGnashXMLVersion(file).startsWith(majorVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getjGnashXMLVersion(File file) {
        String version = "";
        Logger logger = Logger.getLogger(FileUtils.class.getName());
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream input = null;
        XMLStreamReader reader = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            reader = inputFactory.createXMLStreamReader(input, "UTF-8");
            block32: while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 3: {
                        String name = reader.getPITarget();
                        String data = reader.getPIData();
                        if (name.equals("fileVersion")) {
                            version = data;
                            return version;
                        }
                    }
                    default: {
                        continue block32;
                    }
                }
            }
            return version;
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            return version;
        }
        catch (XMLStreamException e) {
            return version;
        }
        catch (IllegalStateException e) {
            logger.log(Level.SEVERE, e.toString(), e);
            return version;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private FileMagic() {
    }

    public static enum FileType {
        db4o,
        OfxV1,
        OfxV2,
        jGnash1XML,
        jGnash2XML,
        unknown;

    }
}

