/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.math.BigDecimal;

public class BigDecimalCache {
    private BigDecimal[] cache = new BigDecimal[0];

    public BigDecimalCache(int capacity) {
        this.ensureCapacity(capacity);
    }

    public void trimToSize(int size) {
        int oldCapacity = this.cache.length;
        if (size < oldCapacity) {
            BigDecimal[] oldData = this.cache;
            this.cache = new BigDecimal[size];
            System.arraycopy(oldData, 0, this.cache, 0, size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.cache.length) {
            int oldCapacity = this.cache.length;
            BigDecimal[] oldCache = this.cache;
            int newCapacity = oldCapacity + 5;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.cache = new BigDecimal[newCapacity];
            System.arraycopy(oldCache, 0, this.cache, 0, oldCapacity);
        }
    }

    public final BigDecimal get(int index) {
        return this.cache[index];
    }

    public void set(int index, BigDecimal element) {
        this.ensureCapacity(index + 1);
        this.cache[index] = element;
    }

    public void clear() {
        this.cache = new BigDecimal[this.cache.length];
    }

    public void clear(int fromIndex) {
        if (fromIndex >= 0 && fromIndex < this.cache.length - 1) {
            int toIndex = this.cache.length;
            for (int i = fromIndex; i < toIndex; ++i) {
                this.cache[i] = null;
            }
        } else {
            this.ensureCapacity(fromIndex + 1);
        }
    }
}

