/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.splash;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import jgnash.ui.util.HTMLResource;
import jgnash.util.Resource;
import org.jfree.ui.about.SystemPropertiesPanel;

public class AboutDialog
extends JDialog
implements ActionListener {
    private final Resource rb = Resource.get();
    private JTabbedPane tabbedPane;
    private final boolean acceptLicense;
    private JCheckBox acceptBox;
    private JButton closeButton;

    public static void showDialog(final Frame parent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AboutDialog dlg = new AboutDialog(parent, false);
                dlg.setVisible(true);
            }
        });
    }

    public static boolean showAcceptLicenseDialog() {
        AboutDialog dlg = new AboutDialog(null, true);
        dlg.setVisible(true);
        return dlg.isAccepted();
    }

    private AboutDialog(Frame parent, boolean acceptLicense) {
        super(parent, true);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Resource.getLocale()));
        this.acceptLicense = acceptLicense;
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min(600, res.width - 80), Math.min(600, res.height - 80));
        this.setSize(size);
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setTitle(this.rb.getString("Title.About"));
        this.addHTMLTab(this.rb.getString("Menu.About.Name"), "notice.html");
        this.addHTMLTab(this.rb.getString("Tab.Credits"), "credits.html");
        JComponent defaultTab = this.addHTMLTab("jGnash License", "jgnash-license.html");
        this.addHTMLTab(this.rb.getString("Tab.GPLLicense"), "gpl-license.html");
        this.addHTMLTab(this.rb.getString("Tab.LGPLLicense"), "lgpl.html");
        this.addHTMLTab("Apache License", "apache-license.html");
        this.addHTMLTab("JGoodies Forms License", "jgoodies-forms-license.html");
        this.addHTMLTab("JGoodies Looks License", "jgoodies-looks-license.html");
        this.addHTMLTab("Tango Icons License", "sharealike-license.html");
        this.addHTMLTab("XStream License", "xstream-license.html");
        this.tabbedPane.addTab(this.rb.getString("Tab.SysInfo"), (Component)new SystemPropertiesPanel());
        this.tabbedPane.setSelectedComponent(defaultTab);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("200dlu:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendRow(RowSpec.decode((String)"fill:200dlu:g"));
        builder.append((Component)this.tabbedPane);
        if (this.acceptLicense) {
            this.acceptBox = new JCheckBox(this.rb.getString("Message.AcceptLicense"));
            this.closeButton = new JButton(this.rb.getString("Button.Close"));
            this.closeButton.addActionListener(this);
            builder.nextLine();
            builder.appendUnrelatedComponentsGapRow();
            builder.nextLine();
            builder.append((Component)this.acceptBox);
            builder.nextLine();
            builder.appendUnrelatedComponentsGapRow();
            builder.nextLine();
            builder.append((Component)ButtonBarFactory.buildCloseBar((JButton)this.closeButton));
        }
        this.getContentPane().add(builder.getPanel());
        this.pack();
    }

    private JComponent addHTMLTab(String name, String url) {
        try {
            URL noticeURL = HTMLResource.getURL(url);
            JEditorPane p = new JEditorPane(noticeURL);
            Font font = UIManager.getFont("Label.font");
            String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
            ((HTMLDocument)p.getDocument()).getStyleSheet().addRule(bodyRule);
            p.setEditable(false);
            p.setAutoscrolls(true);
            JScrollPane pane = new JScrollPane(p);
            this.tabbedPane.add(name, pane);
            return pane;
        }
        catch (Exception e) {
            System.err.println("Could not create " + url + " URL");
            return null;
        }
    }

    private boolean isAccepted() {
        return this.acceptBox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

