/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jgnash.engine.Engine;
import jgnash.ui.report.compiled.Item;

class SecurityTransactionHelper {
    private static final BigDecimal NEGATIVE_SIGMA = new BigDecimal("-0.0001");
    private static final BigDecimal POSITIVE_SIGMA = new BigDecimal("0.0001");
    private BigDecimal realizedGains = BigDecimal.ZERO;
    private BigDecimal currentQuantity = BigDecimal.ZERO;
    private BigDecimal realizedCost = BigDecimal.ZERO;
    private BigDecimal totalQuantity = BigDecimal.ZERO;
    private List<Item> itemList = new ArrayList<Item>();

    SecurityTransactionHelper() {
    }

    public void buy(BigDecimal qty, BigDecimal price, BigDecimal fee) {
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal avgPrice = price.multiply(qty).add(fee).divide(qty, Engine.getRoundingMode());
        Item it = new Item();
        it.qty = qty;
        it.avgprice = avgPrice;
        this.itemList.add(it);
        this.currentQuantity = this.currentQuantity.add(qty);
        this.totalQuantity = this.totalQuantity.add(qty);
    }

    public void reinvdividend(BigDecimal qty, BigDecimal price, BigDecimal fee) {
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal avgPrice = price.multiply(qty).add(fee).divide(qty, Engine.getRoundingMode());
        Item it = new Item();
        it.qty = qty;
        it.avgprice = avgPrice;
        this.itemList.add(it);
        this.currentQuantity = this.currentQuantity.add(qty);
        this.totalQuantity = this.totalQuantity.add(qty);
    }

    public BigDecimal sell(BigDecimal qty, BigDecimal price, BigDecimal fee) {
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        this.currentQuantity = this.currentQuantity.subtract(qty);
        BigDecimal drawnqty = qty;
        BigDecimal rGains = BigDecimal.ZERO;
        for (Item item : this.itemList) {
            if (drawnqty.compareTo(item.qty) < 0) {
                rGains = rGains.add(drawnqty.multiply(price).subtract(drawnqty.multiply(item.avgprice)));
                this.realizedCost = this.realizedCost.add(drawnqty.multiply(item.avgprice));
                item.qty = item.qty.subtract(drawnqty);
                break;
            }
            rGains = rGains.add(item.qty.multiply(price).subtract(item.qty.multiply(item.avgprice)));
            this.realizedCost = this.realizedCost.add(item.qty.multiply(item.avgprice));
            drawnqty = drawnqty.subtract(item.qty);
            item.qty = BigDecimal.ZERO;
            if (drawnqty.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        rGains = rGains.subtract(fee);
        this.realizedGains = this.realizedGains.add(rGains);
        this.realizedCost = this.realizedCost.add(fee);
        return rGains;
    }

    public BigDecimal getUnRealizedGain(BigDecimal marketPrice) {
        BigDecimal cumulativePurchasePrice = BigDecimal.ZERO;
        BigDecimal itemCount = BigDecimal.ZERO;
        for (Item item : this.itemList) {
            itemCount = itemCount.add(item.qty);
            cumulativePurchasePrice = cumulativePurchasePrice.add(item.qty.multiply(item.avgprice));
        }
        return marketPrice.multiply(itemCount).subtract(cumulativePurchasePrice);
    }

    BigDecimal getUnrealizedCost() {
        BigDecimal cumulativePurchasePrice = BigDecimal.ZERO;
        for (Item item : this.itemList) {
            cumulativePurchasePrice = cumulativePurchasePrice.add(item.qty.multiply(item.avgprice));
        }
        return cumulativePurchasePrice;
    }

    BigDecimal getRealizedCost() {
        return this.realizedCost;
    }

    BigDecimal getTotalCost() {
        return this.getRealizedCost().add(this.getUnrealizedCost());
    }

    public BigDecimal getCurrentQuantity() {
        return this.currentQuantity;
    }

    public BigDecimal getTotalQuantity() {
        return this.totalQuantity;
    }

    public BigDecimal getTotalGains(BigDecimal marketPrice) {
        return this.realizedGains.add(this.getUnRealizedGain(marketPrice));
    }

    public BigDecimal getRealizedGains() {
        return this.realizedGains;
    }

    public BigDecimal getRealizedGainsPercentage() {
        if (this.getRealizedCost().compareTo(NEGATIVE_SIGMA) == 1 && this.getRealizedCost().compareTo(POSITIVE_SIGMA) == -1) {
            return BigDecimal.ZERO;
        }
        return this.getRealizedGains().divide(this.getRealizedCost(), Engine.getRoundingMode());
    }

    public BigDecimal getUnrealizedGainsPercentage(BigDecimal marketPrice) {
        if (this.getUnrealizedCost().compareTo(NEGATIVE_SIGMA) == 1 && this.getUnrealizedCost().compareTo(POSITIVE_SIGMA) == -1) {
            return BigDecimal.ZERO;
        }
        return this.getUnRealizedGain(marketPrice).divide(this.getUnrealizedCost(), Engine.getRoundingMode());
    }

    public BigDecimal getTotalGainsPercentage(BigDecimal marketPrice) {
        if (this.getTotalCost().compareTo(NEGATIVE_SIGMA) == 1 && this.getTotalCost().compareTo(POSITIVE_SIGMA) == -1) {
            return BigDecimal.ZERO;
        }
        return this.getTotalGains(marketPrice).divide(this.getTotalCost(), Engine.getRoundingMode());
    }
}

