/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.CurrencyNode;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.SecurityNode;
import jgnash.engine.TransactionType;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.report.AbstractReportTableModel;
import jgnash.ui.report.ColumnHeaderStyle;
import jgnash.ui.report.ColumnStyle;
import jgnash.ui.report.compiled.SecurityTransactionHelper;
import jgnash.ui.report.jasper.DynamicJasperReport;
import jgnash.util.Resource;
import net.sf.jasperreports.engine.JasperPrint;

public class PortfolioReport
extends DynamicJasperReport {
    private JCheckBox subAccountCheckBox;
    private JCheckBox verboseCheckBox;
    private AccountListComboBox accountCombo;
    private JButton refreshButton;
    private static final String USE_LONG_NAMES = "useLongNames";
    private static final String RECURSIVE = "recursive";

    public PortfolioReport() {
        Preferences p = this.getPreferences();
        this.subAccountCheckBox = new JCheckBox(this.rb.getString("Button.IncludeSubAccounts"));
        this.subAccountCheckBox.setSelected(p.getBoolean(RECURSIVE, false));
        this.verboseCheckBox = new JCheckBox(this.rb.getString("Button.UseLongNames"));
        this.verboseCheckBox.setSelected(p.getBoolean(USE_LONG_NAMES, false));
        this.accountCombo = AccountListComboBox.getInstanceByType(AccountGroup.getAccountTypes(AccountGroup.INVEST));
        this.refreshButton = new JButton(this.rb.getString("Button.Refresh"), Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.refreshButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                PortfolioReport.this.refreshReport();
            }
        });
    }

    public PortfolioReport(Account account) {
        this();
        this.accountCombo.setSelectedAccount(account);
    }

    @Override
    protected void refreshReport() {
        Preferences p = this.getPreferences();
        p.putBoolean(RECURSIVE, this.subAccountCheckBox.isSelected());
        p.putBoolean(USE_LONG_NAMES, this.verboseCheckBox.isSelected());
        super.refreshReport();
    }

    @Override
    public JasperPrint createJasperPrint(boolean formatForCSV) {
        this.logger.info(this.rb.getString("Message.CollectingReportData"));
        Account account = this.accountCombo.getSelectedAccount();
        Map<SecurityNode, SecurityTransactionHelper> securities = this.getSecuritiesForAccount(account, this.subAccountCheckBox.isSelected());
        PortfolioReportTableModel model = new PortfolioReportTableModel(securities, account.getCurrencyNode());
        model.verbose = this.verboseCheckBox.isSelected();
        return this.createJasperPrint(model, formatForCSV);
    }

    @Override
    public JPanel getReportController() {
        FormLayout layout = new FormLayout("p, 4dlu, p:g, 8dlu, p", "f:d, 3dlu, f:d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append(this.rb.getString("Label.Account"), (Component)this.accountCombo);
        builder.append((Component)this.refreshButton);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)this.buildOptionPanel(), 5);
        layout.addGroupedRow(1);
        layout.addGroupedRow(3);
        return builder.getPanel();
    }

    private JPanel buildOptionPanel() {
        FormLayout layout = new FormLayout("p, 8dlu, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.subAccountCheckBox);
        builder.append((Component)this.verboseCheckBox);
        return builder.getPanel();
    }

    private Map<SecurityNode, SecurityTransactionHelper> getSecuritiesForAccount_inner(Map<SecurityNode, SecurityTransactionHelper> mapOfCommodities, Account a, boolean recursive) {
        if (recursive) {
            for (Account child : a.getChildren()) {
                this.getSecuritiesForAccount_inner(mapOfCommodities, child, recursive);
            }
        }
        for (int i = 0; i < a.getTransactionCount(); ++i) {
            SecurityTransactionHelper sth;
            if (!(a.getTransactionAt(i) instanceof InvestmentTransaction)) continue;
            InvestmentTransaction t = (InvestmentTransaction)a.getTransactionAt(i);
            SecurityNode c = t.getSecurityNode();
            TransactionType type = t.getTransactionType();
            if (mapOfCommodities.get(c) == null) {
                sth = new SecurityTransactionHelper();
                mapOfCommodities.put(c, sth);
            } else {
                sth = mapOfCommodities.get(c);
            }
            if (type == TransactionType.ADDSHARE || type == TransactionType.BUYSHARE || type == TransactionType.SPLITSHARE) {
                sth.buy(t.getQuantity(), t.getPrice(), t.getFees());
            }
            if (type == TransactionType.REMOVESHARE || type == TransactionType.SELLSHARE || type == TransactionType.MERGESHARE) {
                sth.sell(t.getQuantity(), t.getPrice(), t.getFees());
            }
            if (type != TransactionType.REINVESTDIV) continue;
            sth.reinvdividend(t.getQuantity(), t.getPrice(), t.getFees());
        }
        return mapOfCommodities;
    }

    private Map<SecurityNode, SecurityTransactionHelper> getSecuritiesForAccount(Account a, boolean recursive) {
        TreeMap<SecurityNode, SecurityTransactionHelper> mapOfCommodities = new TreeMap<SecurityNode, SecurityTransactionHelper>();
        return this.getSecuritiesForAccount_inner(mapOfCommodities, a, recursive);
    }

    @Override
    public String getReportName() {
        return this.accountCombo.getSelectedAccount().getName() + " - " + this.rb.getString("Title.PortfolioReport");
    }

    @Override
    public String getGrandTotalLegend() {
        return "";
    }

    @Override
    public String getGroupFooterLabel() {
        return null;
    }

    public class PortfolioReportTableModel
    extends AbstractReportTableModel {
        private static final long serialVersionUID = 568338829426628458L;
        private Set<SecurityNode> keys;
        private Map<SecurityNode, SecurityTransactionHelper> mapOfCommodities;
        boolean verbose;
        private CurrencyNode baseCurrency;

        public PortfolioReportTableModel(Map<SecurityNode, SecurityTransactionHelper> mapOfCommodities, CurrencyNode baseCurrency) {
            this.mapOfCommodities = mapOfCommodities;
            this.baseCurrency = baseCurrency;
            this.keys = mapOfCommodities.keySet();
            this.verbose = true;
        }

        @Override
        public int getColumnCount() {
            return 11;
        }

        @Override
        public int getRowCount() {
            return this.mapOfCommodities.keySet().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SecurityNode[] cns = this.keys.toArray(new SecurityNode[this.keys.size()]);
            SecurityNode cn = cns[row];
            SecurityTransactionHelper sth = this.mapOfCommodities.get(cn);
            switch (col) {
                case 0: {
                    if (this.verbose) {
                        return cn.getDescription();
                    }
                    return cn.getSymbol();
                }
                case 1: {
                    return sth.getCurrentQuantity();
                }
                case 2: {
                    return cn.getMarketPrice(this.baseCurrency);
                }
                case 3: {
                    return cn.getMarketPrice(this.baseCurrency).multiply(sth.getCurrentQuantity());
                }
                case 4: {
                    return sth.getUnRealizedGain(cn.getMarketPrice(this.baseCurrency));
                }
                case 5: {
                    return sth.getUnrealizedGainsPercentage(cn.getMarketPrice(this.baseCurrency));
                }
                case 6: {
                    return sth.getRealizedGains();
                }
                case 7: {
                    return sth.getRealizedGainsPercentage();
                }
                case 8: {
                    return sth.getTotalGains(cn.getMarketPrice(this.baseCurrency));
                }
                case 9: {
                    return sth.getTotalGainsPercentage(cn.getMarketPrice(this.baseCurrency));
                }
                case 10: {
                    return "group";
                }
            }
            return "ERR";
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PortfolioReport.this.rb.getString("Column.Security");
                }
                case 1: {
                    return PortfolioReport.this.rb.getString("Column.Short.Quantity");
                }
                case 2: {
                    return PortfolioReport.this.rb.getString("Column.Price");
                }
                case 3: {
                    return PortfolioReport.this.rb.getString("Column.Value");
                }
                case 4: {
                    return PortfolioReport.this.rb.getString("Column.Short.UnrealizedGain");
                }
                case 5: {
                    return PortfolioReport.this.rb.getString("Column.Short.UnrealizedGainPercentage");
                }
                case 6: {
                    return PortfolioReport.this.rb.getString("Column.Short.RealizedGain");
                }
                case 7: {
                    return PortfolioReport.this.rb.getString("Column.Short.RealizedGainPercentage");
                }
                case 8: {
                    return PortfolioReport.this.rb.getString("Column.Short.TotalGain");
                }
                case 9: {
                    return PortfolioReport.this.rb.getString("Column.Short.TotalGainPercentage");
                }
                case 10: {
                    return "group";
                }
            }
            return "ERR";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0 || columnIndex == 10) {
                return String.class;
            }
            return BigDecimal.class;
        }

        @Override
        public CurrencyNode getCurrency() {
            return this.baseCurrency;
        }

        @Override
        public ColumnStyle getColumnStyle(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ColumnStyle.STRING;
                }
                case 1: {
                    return ColumnStyle.QUANTITY;
                }
                case 2: {
                    return ColumnStyle.BALANCE;
                }
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    return ColumnStyle.AMOUNT_SUM;
                }
                case 5: 
                case 7: 
                case 9: {
                    return ColumnStyle.PERCENTAGE;
                }
                case 10: {
                    return ColumnStyle.GROUP_NO_HEADER;
                }
            }
            return ColumnStyle.STRING;
        }

        @Override
        public ColumnHeaderStyle getColumnHeaderStyle(int columnIndex) {
            if (columnIndex == 0) {
                return ColumnHeaderStyle.LEFT;
            }
            return ColumnHeaderStyle.RIGHT;
        }

        @Override
        public boolean isColumnFixedWidth(int columnIndex) {
            return columnIndex > 0;
        }
    }
}

