/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.CurrencyNode;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.components.DatePanel;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.register.table.ClippingModel;
import jgnash.ui.register.table.FullCommodityRenderer;
import jgnash.ui.register.table.QuantityRenderer;
import jgnash.ui.register.table.ShortCommodityRenderer;
import jgnash.ui.report.AbstractReportTableModel;
import jgnash.ui.report.ColumnHeaderStyle;
import jgnash.ui.report.ColumnStyle;
import jgnash.ui.report.jasper.DynamicJasperReport;
import jgnash.util.Resource;
import net.sf.jasperreports.engine.JasperPrint;

public class AccountRegisterReport
extends DynamicJasperReport {
    private AccountListComboBox accountCombo = new AccountListComboBox();
    private JButton refreshButton;
    private DatePanel startDateField;
    private DatePanel endDateField;
    private JCheckBox detailSplitsCheckBox;
    private static final String SHOW_DETAILS = "showDetails";
    private int startIndex;
    private int endIndex;

    public AccountRegisterReport(Account account) {
        if (account != null) {
            this.accountCombo.setSelectedAccount(account);
        }
        Account a = this.accountCombo.getSelectedAccount();
        this.refreshButton = new JButton(this.rb.getString("Button.Refresh"));
        this.refreshButton.setIcon(Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.startDateField = new DatePanel();
        if (a.getTransactionCount() > 0) {
            this.startDateField.setDate(a.getTransactionAt(0).getDate());
        }
        this.endDateField = new DatePanel();
        this.detailSplitsCheckBox = new JCheckBox(this.rb.getString("Button.DetailSplits"));
        this.detailSplitsCheckBox.setSelected(this.getPreferences().getBoolean(SHOW_DETAILS, false));
        this.detailSplitsCheckBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountRegisterReport.this.getPreferences().putBoolean(AccountRegisterReport.SHOW_DETAILS, AccountRegisterReport.this.detailSplitsCheckBox.isSelected());
            }
        });
        this.refreshButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountRegisterReport.this.refreshReport();
            }
        });
    }

    public AccountRegisterReport(Account account, int startIndex, int endIndex) {
        this(account);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        try {
            this.startDateField.setDate(account.getTransactionAt(startIndex).getDate());
            this.endDateField.setDate(account.getTransactionAt(endIndex).getDate());
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    @Override
    public JasperPrint createJasperPrint(boolean formatForCSV) {
        this.logger.info(this.rb.getString("Message.CollectingReportData"));
        ClippingModel model = RegisterFactory.getClippingTableModel(this.accountCombo.getSelectedAccount(), this.detailSplitsCheckBox.isSelected());
        model.setReconcileSymbol("C");
        if (this.endIndex > 0) {
            model.setStartIndex(this.startIndex);
            model.setEndIndex(this.endIndex);
            this.endIndex = 0;
            this.startIndex = 0;
        } else {
            model.setStartDate(this.startDateField.getDate());
            model.setEndDate(this.endDateField.getDate());
        }
        return this.createJasperPrint(new ReportTableModel(model), formatForCSV);
    }

    @Override
    public JPanel getReportController() {
        FormLayout layout = new FormLayout("p, 4dlu, p:g, 8dlu, p, 8dlu, p", "f:d, 3dlu, f:d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append(this.rb.getString("Label.Account"), (Component)this.accountCombo);
        builder.append((Component)this.refreshButton, 3);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)this.createDatePanel(), 5);
        builder.append((Component)this.detailSplitsCheckBox);
        layout.addGroupedRow(1);
        layout.addGroupedRow(3);
        return builder.getPanel();
    }

    private JPanel createDatePanel() {
        FormLayout layout = new FormLayout("p, 4dlu, max(48dlu;min), 8dlu, p, 4dlu, max(48dlu;min)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append(this.rb.getString("Label.StartDate"), (Component)this.startDateField);
        builder.append(this.rb.getString("Label.EndDate"), (Component)this.endDateField);
        return builder.getPanel();
    }

    @Override
    public String getReportName() {
        return this.accountCombo.getSelectedAccount().getName();
    }

    @Override
    public String getGrandTotalLegend() {
        return null;
    }

    @Override
    public String getGroupFooterLabel() {
        return null;
    }

    private class ReportTableModel
    extends AbstractReportTableModel {
        private ClippingModel model;
        private static final long serialVersionUID = 1L;

        protected ReportTableModel(ClippingModel model) {
            this.model = model;
        }

        @Override
        public CurrencyNode getCurrency() {
            return AccountRegisterReport.this.accountCombo.getSelectedAccount().getCurrencyNode();
        }

        @Override
        public boolean isColumnFixedWidth(int columnIndex) {
            return this.model.getPreferedColumnWeights()[columnIndex] == 0;
        }

        @Override
        public ColumnStyle getColumnStyle(int columnIndex) {
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(Date.class)) {
                return ColumnStyle.SHORT_DATE;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(FullCommodityRenderer.class)) {
                return ColumnStyle.BALANCE;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(ShortCommodityRenderer.class)) {
                return ColumnStyle.SHORT_AMOUNT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(QuantityRenderer.class)) {
                return ColumnStyle.QUANTITY;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(String.class)) {
                return ColumnStyle.STRING;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(BigDecimal.class)) {
                return ColumnStyle.SHORT_AMOUNT;
            }
            return ColumnStyle.STRING;
        }

        @Override
        public ColumnHeaderStyle getColumnHeaderStyle(int columnIndex) {
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(Date.class)) {
                return ColumnHeaderStyle.LEFT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(ShortCommodityRenderer.class)) {
                return ColumnHeaderStyle.RIGHT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(FullCommodityRenderer.class)) {
                return ColumnHeaderStyle.RIGHT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(QuantityRenderer.class)) {
                return ColumnHeaderStyle.RIGHT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(String.class)) {
                return ColumnHeaderStyle.LEFT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(BigDecimal.class)) {
                return ColumnHeaderStyle.RIGHT;
            }
            return ColumnHeaderStyle.LEFT;
        }

        @Override
        public String getColumnName(int col) {
            return this.model.getColumnName(col);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(ShortCommodityRenderer.class)) {
                return BigDecimal.class;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(FullCommodityRenderer.class)) {
                return BigDecimal.class;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(QuantityRenderer.class)) {
                return BigDecimal.class;
            }
            return this.model.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.model.getValueAt(rowIndex, columnIndex);
        }
    }
}

