/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import jgnash.engine.Account;
import jgnash.engine.CurrencyNode;
import jgnash.text.CommodityFormat;
import jgnash.ui.components.ColoredCommodityTableCellRenderer;
import jgnash.ui.components.ColoredQuantityTableCellRenderer;
import jgnash.ui.components.ColoredTableCellRenderer;
import jgnash.ui.components.ColoredTransactionDateTableCellRenderer;
import jgnash.ui.components.ColoredTransactionTableCellRenderer;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.register.table.AccountTableModel;
import jgnash.ui.register.table.FullCommodityRenderer;
import jgnash.ui.register.table.QuantityRenderer;
import jgnash.ui.register.table.ShortCommodityRenderer;

public class RegisterTable
extends JTable {
    RegisterTable() {
    }

    public RegisterTable(AbstractTableModel dm) {
        super(dm);
        this.init();
    }

    private void init() {
        AccountTableModel model;
        this.setAutoResizeMode(1);
        this.setCellSelectionEnabled(true);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.getSelectionModel().setSelectionMode(2);
        this.setShowGrid(false);
        this.setFillsViewportHeight(true);
        this.setDefaultRenderer(String.class, new ColoredTransactionTableCellRenderer());
        this.setDefaultRenderer(Date.class, new ColoredTransactionDateTableCellRenderer());
        this.setDefaultRenderer(BigDecimal.class, new ColoredTableCellRenderer());
        if (this.getModel() instanceof AccountTableModel) {
            model = (AccountTableModel)this.getModel();
            CurrencyNode node = model.getAccount().getCurrencyNode();
            this.setDefaultRenderer(FullCommodityRenderer.class, ColoredCommodityTableCellRenderer.getFullTransactionRenderer(node));
            this.setDefaultRenderer(ShortCommodityRenderer.class, ColoredCommodityTableCellRenderer.getSimpleTransactionRenderer(node));
            this.setDefaultRenderer(QuantityRenderer.class, new ColoredQuantityTableCellRenderer());
        }
        if (this.getModel() instanceof AbstractRegisterTableModel) {
            model = (AbstractRegisterTableModel)this.getModel();
            int count = ((AbstractRegisterTableModel)model).getColumnCount();
            for (int i = 0; i < count; ++i) {
                TableCellRenderer renderer = this.getDefaultRenderer(((AbstractRegisterTableModel)model).getColumnClass(i));
                this.getColumnModel().getColumn(i).setCellRenderer(renderer);
            }
        }
        ToolTipManager.sharedInstance().unregisterComponent(this.getTableHeader());
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int[] rows = this.getSelectedRows();
        if (rows.length > 1 && this.getModel() instanceof AccountTableModel) {
            AccountTableModel model = (AccountTableModel)this.getModel();
            Account account = model.getAccount();
            CurrencyNode node = model.getAccount().getCurrencyNode();
            BigDecimal amount = BigDecimal.ZERO;
            for (int row : rows) {
                amount = amount.add(account.getTransactionAt(row).getAmount(account));
            }
            return CommodityFormat.getFullNumberFormat(node).format(amount);
        }
        return null;
    }
}

