/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import jgnash.engine.Account;
import jgnash.engine.CommodityNode;
import jgnash.engine.EngineFactory;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionType;
import jgnash.message.MessageListener;
import jgnash.ui.UIApplication;
import jgnash.ui.components.YesNoDialog;
import jgnash.ui.register.DuplicateTransactionDialog;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.register.RegisterFrame;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.register.table.RegisterTable;
import jgnash.ui.util.JTableUtils;
import jgnash.util.EncodeDecode;
import jgnash.util.Resource;

public abstract class AbstractRegisterPanel
extends JPanel
implements MessageListener,
KeyListener {
    private static final String NODEREGPOS = "/jgnash/ui/register/positions";
    private static final String NODEREGWIDTH = "/jgnash/ui/register/widths";
    private static final String NODEREGVIS = "/jgnash/ui/register/visability";
    protected final Resource rb = Resource.get();
    private TransactionPopup popup = new TransactionPopup();

    protected abstract Account getAccount();

    protected abstract void modifyTransaction(int var1);

    public abstract AbstractRegisterTableModel getTableModel();

    public abstract RegisterTable getTable();

    protected void installPopupHandler() {
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractRegisterPanel.this.checkForPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractRegisterPanel.this.checkForPopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = AbstractRegisterPanel.this.getTable().rowAtPoint(e.getPoint());
                if (row >= 0) {
                    AbstractRegisterPanel.this.modifyTransaction(row);
                }
            }
        });
    }

    private void checkForPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupAction(e);
        }
    }

    private void popupAction(MouseEvent e) {
        int row = this.getTable().rowAtPoint(e.getPoint());
        if (row >= 0) {
            this.getTable().getSelectionModel().setSelectionInterval(row, row);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private String getColumnPositions() {
        return JTableUtils.getColumnOrder(this.getTable());
    }

    private void setColumnPositions(String positions) {
        JTableUtils.setColumnOrder(this.getTable(), positions);
    }

    private String getColumnWidths() {
        return JTableUtils.getColumnWidths(this.getTable());
    }

    private void setColumnWidths(String widths) {
        JTableUtils.setColumnWidths(this.getTable(), widths);
    }

    protected boolean restoreColumnLayout() {
        String id;
        boolean result = false;
        Preferences pwidth = Preferences.userRoot().node(NODEREGWIDTH);
        Preferences ppos = Preferences.userRoot().node(NODEREGPOS);
        Preferences pvis = Preferences.userRoot().node(NODEREGVIS);
        String colVis = pvis.get(id = this.getAccount().getUuid(), null);
        if (colVis != null) {
            this.getTableModel().setColumnVisibility(EncodeDecode.decodeBooleanArray(colVis));
            this.setColumnPositions(ppos.get(id, null));
            this.setColumnWidths(pwidth.get(id, null));
            result = true;
        }
        return result;
    }

    protected void saveColumnLayout() {
        Preferences pwidth = Preferences.userRoot().node(NODEREGWIDTH);
        Preferences ppos = Preferences.userRoot().node(NODEREGPOS);
        Preferences pvis = Preferences.userRoot().node(NODEREGVIS);
        String id = this.getAccount().getUuid();
        ppos.put(id, this.getColumnPositions());
        pwidth.put(id, this.getColumnWidths());
        pvis.put(id, EncodeDecode.encodeBooleanArray(this.getTableModel().getColumnVisibility()));
    }

    private boolean confirmTransactionRemoval(int count) {
        String message = count == 1 ? this.rb.getString("Message.ConfirmTransDelete") : this.rb.getString("Message.ConfirmMultipleTransDelete");
        return YesNoDialog.showYesNoDialog((Frame)((Object)UIApplication.getFrame()), new JLabel(this.rb.getString(message)), this.rb.getString("Title.Confirm"));
    }

    protected void deleteAction() {
        Transaction[] trans = this.getSelectedTransactions();
        if (RegisterFactory.isConfirmTransactionDeleteEnabled() && !this.confirmTransactionRemoval(trans.length)) {
            return;
        }
        for (Transaction tran : trans) {
            EngineFactory.getEngine("default").removeTransaction(tran);
        }
    }

    protected void duplicateAction() {
        Transaction[] trans;
        for (Transaction tran : trans = this.getSelectedTransactions()) {
            DuplicateTransactionDialog.showDialog(this.getAccount(), tran);
        }
    }

    void jumpAction() {
        Transaction t = this.getSelectedTransaction();
        if (t != null) {
            if (t.getTransactionType() == TransactionType.DOUBLEENTRY) {
                Set<Account> set = t.getAccounts();
                for (Account a : set) {
                    if (this.getAccount().equals(a)) continue;
                    RegisterFrame.showDialog(a, t);
                }
            } else if (t.getTransactionType() == TransactionType.SPLITENTRY) {
                Account common = t.getCommonAccount();
                if (!this.getAccount().equals(common)) {
                    RegisterFrame.showDialog(common, t);
                }
            } else if (t instanceof InvestmentTransaction) {
                Account invest = ((InvestmentTransaction)t).getInvestmentAccount();
                if (!this.getAccount().equals(invest)) {
                    RegisterFrame.showDialog(invest, t);
                }
            }
        }
    }

    void reconcileAction(ReconciledState reconciled) {
        Transaction t = this.getSelectedTransaction();
        if (t != null) {
            EngineFactory.getEngine("default").setTransactionReconciled(t, this.getAccount(), reconciled);
        }
    }

    private Transaction getSelectedTransaction() {
        int index = this.getTable().getSelectedRow();
        if (index >= 0) {
            return this.getTableModel().getTransactionAt(index);
        }
        return null;
    }

    private Transaction[] getSelectedTransactions() {
        int[] rows = this.getTable().getSelectedRows();
        Transaction[] trans = new Transaction[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            trans[i] = this.getTableModel().getTransactionAt(rows[i]);
        }
        return trans;
    }

    public void setSelectedTransaction(Transaction t) {
        int index = this.getTableModel().indexOf(t);
        if (index >= 0) {
            RegisterTable table = this.getTable();
            if (index > 0) {
                table.scrollRectToVisible(table.getCellRect(index - 1, 0, true));
            } else {
                table.scrollRectToVisible(table.getCellRect(index, 0, true));
            }
            table.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    protected CommodityNode getAccountCurrencyNode() {
        return this.getAccount().getCurrencyNode();
    }

    protected String getAccountPath() {
        return this.getAccount().getPathName();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.deleteAction();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected class TransactionPopup
    extends JPopupMenu
    implements ActionListener {
        private JMenuItem duplicate;
        private JMenuItem delete;
        private JRadioButtonMenuItem reconciled;
        private JRadioButtonMenuItem unreconciled;
        private JMenuItem jump;

        public TransactionPopup() {
            JMenu markSub = new JMenu(AbstractRegisterPanel.this.rb.getString("Menu.MarkAs.Name"));
            this.reconciled = new JRadioButtonMenuItem(AbstractRegisterPanel.this.rb.getString("Menu.Reconciled.Name"));
            this.reconciled.addActionListener(this);
            this.unreconciled = new JRadioButtonMenuItem(AbstractRegisterPanel.this.rb.getString("Menu.Unreconciled.Name"));
            this.unreconciled.addActionListener(this);
            ButtonGroup g = new ButtonGroup();
            g.add(this.reconciled);
            g.add(this.unreconciled);
            markSub.add(this.reconciled);
            markSub.add(this.unreconciled);
            this.add(markSub);
            this.addSeparator();
            this.duplicate = new JMenuItem(AbstractRegisterPanel.this.rb.getString("Menu.Duplicate.Name"));
            this.duplicate.addActionListener(this);
            this.add(this.duplicate);
            this.jump = new JMenuItem(AbstractRegisterPanel.this.rb.getString("Menu.Jump.Name"));
            this.jump.addActionListener(this);
            this.add(this.jump);
            this.addSeparator();
            this.delete = new JMenuItem(AbstractRegisterPanel.this.rb.getString("Menu.Delete.Name"));
            this.delete.addActionListener(this);
            this.add(this.delete);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.delete) {
                AbstractRegisterPanel.this.deleteAction();
            } else if (e.getSource() == this.duplicate) {
                AbstractRegisterPanel.this.duplicateAction();
            } else if (e.getSource() == this.jump) {
                AbstractRegisterPanel.this.jumpAction();
            } else if (e.getSource() == this.reconciled) {
                AbstractRegisterPanel.this.reconcileAction(ReconciledState.RECONCILED);
            } else if (e.getSource() == this.unreconciled) {
                AbstractRegisterPanel.this.reconcileAction(ReconciledState.NOT_RECONCILED);
            }
        }

        @Override
        public void show(Component invoker, int x, int y) {
            Transaction t = AbstractRegisterPanel.this.getSelectedTransaction();
            if (t != null) {
                if (t.getReconciled(AbstractRegisterPanel.this.getAccount()) == ReconciledState.RECONCILED) {
                    this.reconciled.setSelected(true);
                } else {
                    this.unreconciled.setSelected(true);
                }
            }
            super.show(invoker, x, y);
        }
    }
}

