/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.commodity;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import jgnash.engine.CommodityNode;
import jgnash.engine.EngineFactory;
import jgnash.engine.QuoteSource;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.net.security.SecurityUpdateFactory;
import jgnash.ui.components.ColoredDateTableCellRenderer;
import jgnash.ui.components.ColoredTableCellRenderer;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JFloatField;
import jgnash.ui.components.JIntegerField;
import jgnash.ui.components.LongTableCellRenderer;
import jgnash.ui.components.SecurityComboBox;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class SecuritiesHistoryDialog
extends JDialog
implements ActionListener {
    private DatePanel dateField;
    private JFloatField priceField;
    private JFloatField lowField;
    private JFloatField highField;
    private SecurityComboBox securityCombo;
    private JIntegerField volumeField;
    private HistoryModel model;
    private JButton closeButton;
    private JButton applyButton;
    private JButton clearButton;
    private JButton deleteButton;
    private JTable table;
    private JButton updateButton;
    private final Resource rb = Resource.get();

    public static void showDialog(final JFrame parent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SecuritiesHistoryDialog d = new SecuritiesHistoryDialog(parent);
                d.setVisible(true);
            }
        });
    }

    private SecuritiesHistoryDialog(JFrame parent) {
        super(parent);
        this.setTitle(this.rb.getString("Title.ModifySecHistory"));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.layoutMainPanel(), "Center");
        this.changeNode();
        this.pack();
        this.setMinimumSize(this.getSize());
        DialogUtils.addBoundsListener(this);
    }

    private void initComponents() {
        this.dateField = new DatePanel();
        this.priceField = new JFloatField();
        this.lowField = new JFloatField();
        this.highField = new JFloatField();
        this.securityCombo = new SecurityComboBox();
        this.volumeField = new JIntegerField();
        this.model = new HistoryModel();
        this.table = new JTable(this.model);
        this.updateButton = new JButton(this.rb.getString("Button.UpdateOnline"), Resource.getIcon("/jgnash/resource/applications-internet.png"));
        this.deleteButton = new JButton(this.rb.getString("Button.Delete"));
        this.clearButton = new JButton(this.rb.getString("Button.Clear"));
        this.applyButton = new JButton(this.rb.getString("Button.Add"));
        this.closeButton = new JButton(this.rb.getString("Button.Close"));
        this.table.setPreferredScrollableViewportSize(new Dimension(150, 180));
        this.table.setDefaultRenderer(Object.class, new ColoredTableCellRenderer());
        this.table.setDefaultRenderer(Date.class, new ColoredDateTableCellRenderer());
        this.table.setDefaultRenderer(Long.class, new LongTableCellRenderer());
        this.table.setCellSelectionEnabled(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.getSelectionModel().setSelectionMode(2);
        this.table.setRowSorter(new TableRowSorter<HistoryModel>(this.model));
        this.table.setFillsViewportHeight(true);
        this.applyButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.securityCombo.addActionListener(this);
        this.closeButton.addActionListener(this);
    }

    private JPanel layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("r:p, $lcgap, max(75dlu;p):g(0.5), 8dlu, r:p, $lcgap, max(75dlu;p):g(0.5)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendRow(RowSpec.decode((String)"f:p:g"));
        builder.append((Component)new JScrollPane(this.table), 7);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.setRowGroupingEnabled(true);
        builder.append(this.rb.getString("Label.Security"), (Component)this.securityCombo, 5);
        builder.nextLine();
        builder.append(this.rb.getString("Label.Date"), (Component)this.dateField);
        builder.append("", (Component)this.updateButton);
        builder.nextLine();
        builder.append(this.rb.getString("Label.Price"), (Component)this.priceField);
        builder.append(this.rb.getString("Label.Volume"), (Component)this.volumeField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.High"), (Component)this.highField);
        builder.append(this.rb.getString("Label.Low"), (Component)this.lowField);
        builder.setRowGroupingEnabled(false);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.buildButtonBar(), 7);
        return builder.getPanel();
    }

    private JPanel buildButtonBar() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addGridded((JComponent)this.deleteButton);
        builder.addRelatedGap();
        builder.addGridded((JComponent)this.clearButton);
        builder.addRelatedGap();
        builder.addGridded((JComponent)this.applyButton);
        builder.addGlue();
        builder.addGridded((JComponent)this.closeButton);
        return builder.getPanel();
    }

    private void clearForm() {
        this.dateField.setDate(new Date());
        this.priceField.setDecimal(null);
        this.volumeField.setText(null);
        this.lowField.setDecimal(null);
        this.highField.setDecimal(null);
    }

    private void changeNode() {
        SecurityNode node = this.securityCombo.getSelectedSecurityNode();
        if (node != null) {
            this.model.setSecurity(node);
            this.priceField.setScale(node.getScale());
            this.lowField.setScale(node.getScale());
            this.highField.setScale(node.getScale());
            this.updateButton.setEnabled(node.getQuoteSource() != QuoteSource.NONE);
        }
    }

    private void netAddNode() {
        SecurityNode node = this.securityCombo.getSelectedSecurityNode();
        if (node != null) {
            SecurityUpdateFactory.updateOne(node);
        }
    }

    private void addNode() {
        SecurityHistoryNode history = new SecurityHistoryNode();
        history.setDate(this.dateField.getDate());
        history.setPrice(this.priceField.getDecimal());
        history.setVolume(this.volumeField.longValue());
        if (this.highField.getText().length() > 0) {
            history.setHigh(this.highField.getDecimal());
        }
        if (this.lowField.getText().length() > 0) {
            history.setLow(this.lowField.getDecimal());
        }
        EngineFactory.getEngine("default").addSecurityHistory(this.securityCombo.getSelectedSecurityNode(), history);
    }

    private void removeNode() {
        int i;
        SecurityNode node = this.securityCombo.getSelectedSecurityNode();
        int[] selection = this.table.getSelectedRows();
        for (int i2 = 0; i2 < selection.length; ++i2) {
            selection[i2] = this.table.convertRowIndexToModel(selection[i2]);
        }
        List<SecurityHistoryNode> history = EngineFactory.getEngine("default").getSecurityHistory(node);
        SecurityHistoryNode[] temp = new SecurityHistoryNode[selection.length];
        for (i = 0; i < selection.length; ++i) {
            temp[i] = history.get(selection[i]);
        }
        for (i = selection.length - 1; i >= 0; --i) {
            EngineFactory.getEngine("default").removeSecurityHistory(node, temp[i]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.addNode();
        } else if (e.getSource() == this.clearButton) {
            this.clearForm();
        } else if (e.getSource() == this.deleteButton) {
            this.removeNode();
        } else if (e.getSource() == this.updateButton) {
            this.netAddNode();
        } else if (e.getSource() == this.securityCombo) {
            this.changeNode();
        } else if (e.getSource() == this.closeButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }

    static /* synthetic */ Resource access$100(SecuritiesHistoryDialog x0) {
        return x0.rb;
    }

    private class HistoryModel
    extends DefaultTableModel
    implements MessageListener {
        private static final long serialVersionUID = -1928531589902526946L;
        SecurityNode node = null;
        List<SecurityHistoryNode> history;
        private final String[] cNames = new String[]{SecuritiesHistoryDialog.access$100(SecuritiesHistoryDialog.this).getString("Column.Date"), SecuritiesHistoryDialog.access$100(SecuritiesHistoryDialog.this).getString("Column.Price"), SecuritiesHistoryDialog.access$100(SecuritiesHistoryDialog.this).getString("Column.Low"), SecuritiesHistoryDialog.access$100(SecuritiesHistoryDialog.this).getString("Column.High"), SecuritiesHistoryDialog.access$100(SecuritiesHistoryDialog.this).getString("Column.Volume")};
        private final Class<?>[] cClass = new Class[]{Date.class, String.class, String.class, String.class, String.class};
        private final NumberFormat decimalFormat;
        private final NumberFormat integerFormat;

        public HistoryModel() {
            MessageBus.getInstance().registerListener(this, MessageChannel.COMMODITY);
            this.decimalFormat = NumberFormat.getInstance();
            if (this.decimalFormat instanceof DecimalFormat) {
                this.decimalFormat.setMinimumFractionDigits(2);
                this.decimalFormat.setMaximumFractionDigits(2);
            }
            this.integerFormat = NumberFormat.getIntegerInstance();
        }

        public void setSecurity(SecurityNode node) {
            this.node = node;
            this.history = EngineFactory.getEngine("default").getSecurityHistory(node);
            if (this.decimalFormat instanceof DecimalFormat) {
                this.decimalFormat.setMinimumFractionDigits(node.getScale());
                this.decimalFormat.setMaximumFractionDigits(node.getScale());
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.cClass[column];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.node != null) {
                switch (col) {
                    case 0: {
                        return this.history.get(row).getDate();
                    }
                    case 1: {
                        return this.decimalFormat.format(this.history.get(row).getPrice());
                    }
                    case 2: {
                        return this.decimalFormat.format(this.history.get(row).getLow());
                    }
                    case 3: {
                        return this.decimalFormat.format(this.history.get(row).getHigh());
                    }
                    case 4: {
                        return this.integerFormat.format(this.history.get(row).getVolume());
                    }
                }
                return "Error";
            }
            return null;
        }

        @Override
        public int getRowCount() {
            if (this.node != null) {
                return this.history.size();
            }
            return 0;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void messagePosted(final Message event) {
            CommodityNode eNode = (CommodityNode)event.getObject(MessageProperty.COMMODITY);
            if (this.node != null && this.node.equals(eNode)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        switch (event.getEvent()) {
                            case COMMODITY_HISTORY_ADD: 
                            case COMMODITY_HISTORY_REMOVE: {
                                HistoryModel.this.history = EngineFactory.getEngine("default").getSecurityHistory(HistoryModel.this.node);
                                HistoryModel.this.fireTableDataChanged();
                                return;
                            }
                        }
                    }
                });
            }
        }
    }
}

