/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.checks;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgnash.engine.checks.CheckLayout;
import jgnash.engine.checks.CheckLayoutSerializationFactory;
import jgnash.ui.UIApplication;
import jgnash.ui.components.JTextFieldEx;
import jgnash.util.Resource;

class PrintCheckDialog
extends JDialog
implements ActionListener {
    private Resource rb = Resource.get();
    private JButton cancelButton;
    private JCheckBox incCheckBox;
    private JTextField layoutField;
    private JButton printButton;
    private JButton selectButton;
    private JSpinner startSpinner;
    private CheckLayout checkLayout;
    private static final String LAST_LAYOUT = "lastlayout";
    private static final String CURRENT_DIR = "cwd";
    private static final String INC_NUM = "incrementNumbers";
    private boolean returnStatus = false;
    private Preferences pref = Preferences.userNodeForPackage(PrintCheckDialog.class);

    public PrintCheckDialog() {
        super((Frame)((Object)UIApplication.getFrame()), true);
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
        this.setLocationRelativeTo((Component)((Object)UIApplication.getFrame()));
        if (this.pref.get(LAST_LAYOUT, null) != null) {
            this.loadLayout(this.pref.get(LAST_LAYOUT, null));
        }
    }

    private void initComponents() {
        this.layoutField = new JTextFieldEx();
        this.selectButton = new JButton(this.rb.getString("Button.Select"));
        this.startSpinner = new JSpinner();
        this.incCheckBox = new JCheckBox(this.rb.getString("Button.IncCheckNums"));
        this.printButton = new JButton(this.rb.getString("Button.Print"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.startSpinner.getModel().setValue(1);
        this.cancelButton.addActionListener(this);
        this.printButton.addActionListener(this);
        this.selectButton.addActionListener(this);
        this.incCheckBox.setSelected(this.pref.getBoolean(INC_NUM, false));
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, 4dlu, 85dlu:g, 4dlu, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setRowGroupingEnabled(true);
        builder.append(this.rb.getString("Label.CheckLayout"), (Component)this.layoutField, (Component)this.selectButton);
        builder.append(this.rb.getString("Label.StartPos"), (Component)this.startSpinner);
        builder.nextLine();
        builder.append((Component)this.incCheckBox, 5);
        builder.setRowGroupingEnabled(false);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.printButton, (JButton)this.cancelButton), 5);
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
    }

    private void closeDialog() {
        this.pref.putBoolean(INC_NUM, this.incCheckBox.isSelected());
        this.setVisible(false);
        this.dispose();
    }

    private void setupSpinner() {
        ((SpinnerNumberModel)this.startSpinner.getModel()).setMinimum(Integer.valueOf(1));
        ((SpinnerNumberModel)this.startSpinner.getModel()).setMaximum(Integer.valueOf(this.checkLayout.getNumberOfChecks()));
    }

    private JFileChooser createFileChooser(String dir) {
        JFileChooser chooser = new JFileChooser(dir);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter(this.rb.getString("Label.jGnashFiles") + " (*.xml)", "xml"));
        return chooser;
    }

    private void selectLayout() {
        JFileChooser chooser = this.createFileChooser(this.pref.get(CURRENT_DIR, null));
        if (chooser.showOpenDialog(this) == 0) {
            this.pref.put(CURRENT_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            String file = chooser.getSelectedFile().getAbsolutePath();
            this.pref.put(LAST_LAYOUT, file);
            this.loadLayout(file);
        }
    }

    public int getStartPosition() {
        return ((Number)this.startSpinner.getValue()).intValue() - 1;
    }

    public boolean getReturnStatus() {
        return this.returnStatus;
    }

    public CheckLayout getCheckLayout() {
        return this.checkLayout;
    }

    protected boolean incrementCheckNumbers() {
        return this.incCheckBox.isSelected();
    }

    private void loadLayout(String file) {
        CheckLayout o;
        if (new File(file).exists() && (o = CheckLayoutSerializationFactory.loadLayout(file)) != null) {
            this.checkLayout = o;
            this.setupSpinner();
            this.layoutField.setText(file);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.printButton) {
            this.returnStatus = this.checkLayout != null;
            this.closeDialog();
        } else if (e.getSource() == this.selectButton) {
            this.selectLayout();
        }
    }
}

