/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import jgnash.engine.Account;

abstract class AbstractAccountEnabledTreeCellRenderer
extends DefaultTreeCellRenderer {
    private boolean drawsFocusBorderAroundIcon;

    AbstractAccountEnabledTreeCellRenderer() {
    }

    protected abstract boolean isAccountEnabled(Account var1);

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        Account a = (Account)((DefaultMutableTreeNode)value).getUserObject();
        if (this.isAccountEnabled(a)) {
            this.selected = sel;
            this.setEnabled(true);
            this.hasFocus = focus;
        } else {
            this.selected = false;
            this.setEnabled(false);
            this.hasFocus = false;
        }
        String stringValue = tree.convertValueToText(value, this.selected, expanded, leaf, row, this.hasFocus);
        this.setText(stringValue);
        if (this.selected) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (this.isEnabled()) {
            if (leaf) {
                this.setIcon(this.getLeafIcon());
            } else if (expanded) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        } else if (leaf) {
            this.setDisabledIcon(this.getLeafIcon());
        } else if (expanded) {
            this.setDisabledIcon(this.getOpenIcon());
        } else {
            this.setDisabledIcon(this.getClosedIcon());
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Color bColor;
        if (this.selected) {
            bColor = this.getBackgroundSelectionColor();
        } else {
            bColor = this.getBackgroundNonSelectionColor();
            if (bColor == null) {
                bColor = this.getBackground();
            }
        }
        int imageOffset = -1;
        if (bColor != null) {
            imageOffset = this.getLabelStart();
            g.setColor(bColor);
            if (this.getComponentOrientation().isLeftToRight()) {
                g.fillRect(imageOffset, 0, this.getWidth() - 1 - imageOffset, this.getHeight());
            } else {
                g.fillRect(0, 0, this.getWidth() - 1 - imageOffset, this.getHeight());
            }
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                imageOffset = 0;
            } else if (imageOffset == -1) {
                imageOffset = this.getLabelStart();
            }
            Color bsColor = this.getBorderSelectionColor();
            if (bsColor != null) {
                g.setColor(bsColor);
                if (this.getComponentOrientation().isLeftToRight()) {
                    g.drawRect(imageOffset, 0, this.getWidth() - 1 - imageOffset, this.getHeight() - 1);
                } else {
                    g.drawRect(0, 0, this.getWidth() - 1 - imageOffset, this.getHeight() - 1);
                }
            }
        }
        super.paint(g);
    }

    private int getLabelStart() {
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = value != null && (Boolean)value != false;
    }

    public DefaultTreeSelectionModel getSelectionModel() {
        return new SelectionModel();
    }

    private class SelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -1484099294329591524L;

        public SelectionModel() {
            this.setSelectionMode(1);
        }

        @Override
        public void setSelectionPath(TreePath path) {
            if (path != null) {
                Account a;
                Object o = path.getLastPathComponent();
                if (o != null && (a = (Account)((DefaultMutableTreeNode)o).getUserObject()) != null && AbstractAccountEnabledTreeCellRenderer.this.isAccountEnabled(a)) {
                    super.setSelectionPath(path);
                }
            } else {
                super.setSelectionPath(null);
            }
        }
    }
}

