/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import jgnash.ui.MainFrame;
import jgnash.ui.components.ExceptionDialog;
import jgnash.ui.report.FontRegistry;
import jgnash.ui.splash.AboutDialog;
import jgnash.util.Resource;

public class UIApplication
implements Thread.UncaughtExceptionHandler {
    private static final String helpHS = "default/jhelpset.hs";
    private static final String ACCEPT_LICENSE = "licenseaccepted";
    private final Preferences pref = Preferences.userNodeForPackage(UIApplication.class);
    private static MainFrame frame;
    private static HelpBroker helpBroker;
    private static Logger logger;

    public UIApplication(final File file) {
        if (this.initFrame()) {
            FontRegistry.registerFonts();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (file != null) {
                        frame.loadFile(file);
                    } else {
                        frame.loadLast();
                    }
                }
            });
        }
    }

    public UIApplication(final String host, final int port, final String user, final String password) {
        if (this.initFrame()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.openRemote(host, port, user, password);
                }
            });
        }
    }

    private boolean initFrame() {
        boolean result = false;
        Thread.setDefaultUncaughtExceptionHandler(this);
        if (!this.pref.getBoolean(ACCEPT_LICENSE, false)) {
            if (AboutDialog.showAcceptLicenseDialog()) {
                this.pref.putBoolean(ACCEPT_LICENSE, true);
            } else {
                System.err.println(Resource.get().getString("Message.ErrorLicense"));
            }
        }
        if (this.pref.getBoolean(ACCEPT_LICENSE, false)) {
            result = true;
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        frame = new MainFrame();
                        frame.setVisible(true);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static MainFrame getFrame() {
        return frame;
    }

    public static HelpBroker getHelpBroker() {
        if (helpBroker == null) {
            ClassLoader cl = UIApplication.class.getClassLoader();
            try {
                URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpHS);
                HelpSet hs = new HelpSet(null, hsURL);
                helpBroker = hs.createHelpBroker();
            }
            catch (Exception ee) {
                System.err.println("HelpSet " + ee.getMessage());
                System.err.println("HelpSet default/jhelpset.hs not found");
            }
        }
        return helpBroker;
    }

    public static void repaint() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.repaint();
            }
        });
    }

    @Override
    public void uncaughtException(Thread t, final Throwable e) {
        e.printStackTrace();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ExceptionDialog((Frame)((Object)UIApplication.getFrame()), e).setVisible(true);
            }
        });
    }

    static void restartUI() {
        final MainFrame old = frame;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame = new MainFrame();
                old.setVisible(false);
                old.dispose(false);
                frame.setVisible(true);
            }
        });
    }

    public static Logger getLogger() {
        return logger;
    }

    static {
        logger = Logger.getLogger(UIApplication.class.getName());
    }
}

