/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import com.jgoodies.looks.Options;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import jgnash.ui.MainFrame;
import jgnash.ui.UIApplication;
import jgnash.util.Resource;

public class ThemeManager
implements ActionListener {
    private final Resource rb = Resource.get();
    private String currentLookAndFeel;
    private String currentTheme;
    private JFrame frame;
    private JMenu themesMenu = null;
    private ArrayList<Object> themeList = new ArrayList();
    private static final String STEEL = "javax.swing.plaf.metal.DefaultMetalTheme";
    private static final String OCEAN = "javax.swing.plaf.metal.OceanTheme";
    private static String DEFAULT_THEME = "javax.swing.plaf.metal.OceanTheme";
    private static final String LF = "lookandfeel2";
    private static final String THEME = "theme2";
    private static final String JGOODIESPLASTICLF = "com.jgoodies.looks.plastic.PlasticLookAndFeel";
    private static final String JGOODIESPLASTIC3DLF = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    private static final String JGOODIESPLASTICXPLF = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    private static final String JGOODIESEXTWINDOWS = "com.jgoodies.looks.windows.WindowsLookAndFeel";
    private static final String MAC = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String SUBSTANCE_BUS = "org.jvnet.substance.skin.SubstanceBusinessLookAndFeel";
    private static final String SUBSTANCE_EMERALD = "org.jvnet.substance.skin.SubstanceEmeraldDuskLookAndFeel";
    private static final String SUBSTANCE_MODERATE = "org.jvnet.substance.skin.SubstanceModerateLookAndFeel";
    private static final String SUBSTANCE_RAVEN = "org.jvnet.substance.skin.SubstanceRavenLookAndFeel";
    private static final String NIMROD = "com.nilo.plaf.nimrod.NimRODLookAndFeel";
    private static final String TINY = "de.muntjak.tinylookandfeel.TinyLookAndFeel";

    protected ThemeManager(JFrame frame) {
        this.frame = frame;
        try {
            Options.setPopupDropShadowEnabled((boolean)true);
        }
        catch (Exception e) {
            // empty catch block
        }
        Preferences pref = Preferences.userNodeForPackage(ThemeManager.class);
        this.currentLookAndFeel = pref.get(LF, UIManager.getCrossPlatformLookAndFeelClassName());
        this.currentTheme = pref.get(THEME, DEFAULT_THEME);
        this.updateLookAndFeel();
    }

    protected static boolean isLookAndFeelOSX() {
        return UIManager.getLookAndFeel().getName().startsWith("Mac");
    }

    public static boolean isLookAndFeelNimbus() {
        return UIManager.getLookAndFeel().getName().startsWith("Nimbus");
    }

    private static void installLookAndFeel(String desc, String className) {
        try {
            Class.forName(className);
        }
        catch (Exception e) {
            return;
        }
        try {
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo(desc, className));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTheme(String theme) {
        Preferences pref = Preferences.userNodeForPackage(MainFrame.class);
        this.currentTheme = theme;
        pref.put(THEME, theme);
        try {
            Class<?> themeClass = Class.forName(theme);
            MetalTheme themeObject = (MetalTheme)themeClass.newInstance();
            MetalLookAndFeel.setCurrentTheme(themeObject);
        }
        catch (Exception e) {
            this.currentTheme = DEFAULT_THEME;
            Logger.getAnonymousLogger().severe("Could not install theme: " + theme + "\n" + e.toString());
        }
    }

    private String getCurrentTheme() {
        return this.currentTheme;
    }

    private void updateLookAndFeel() {
        try {
            Class<?> lafClass = Class.forName(this.currentLookAndFeel);
            Object o = lafClass.newInstance();
            if (o instanceof MetalLookAndFeel) {
                this.setTheme(this.currentTheme);
            }
            UIManager.setLookAndFeel(this.currentLookAndFeel);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.updateComponentTreeUI(ThemeManager.this.frame);
                }
            });
            UIManager.getLookAndFeelDefaults().put("ClassLoader", this.frame.getClass().getClassLoader());
            this.refreshThemesState();
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ThemeManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ThemeManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ThemeManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ThemeManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected JMenu buildLookAndFeelMenu() {
        UIManager.LookAndFeelInfo[] lf;
        String lfName = UIManager.getLookAndFeel().getName();
        ButtonGroup lfButtonGroup = new ButtonGroup();
        JMenu lfMenu = new JMenu();
        lfMenu.setText(this.rb.getString("Menu.LookAndFeel.Name"));
        lfMenu.setMnemonic(this.rb.getMnemonic("Menu.LookAndFeel.Mnemonic"));
        for (UIManager.LookAndFeelInfo element : lf = UIManager.getInstalledLookAndFeels()) {
            if (!ThemeManager.isLookAndFeelAvailable(element.getClassName())) continue;
            JRadioButtonMenuItem button = new JRadioButtonMenuItem();
            button.setText(element.getName());
            button.setActionCommand(LF);
            button.setName(element.getClassName());
            button.addActionListener(this);
            lfButtonGroup.add(button);
            lfMenu.add(button);
            if (!element.getName().equals(lfName)) continue;
            button.setSelected(true);
        }
        return lfMenu;
    }

    private void buildThemeList() {
        this.addTheme(OCEAN);
        this.addTheme(STEEL);
        this.addTheme("jgnash.ui.plaf.theme.CDETheme");
        this.addTheme("jgnash.ui.plaf.theme.TinyMetalTheme");
        this.addTheme("com.jgoodies.looks.plastic.theme.BrownSugar");
        this.addTheme("com.jgoodies.looks.plastic.theme.DarkStar");
        this.addTheme("com.jgoodies.looks.plastic.theme.DesertBlue");
        this.addTheme("com.jgoodies.looks.plastic.theme.DesertBluer");
        this.addTheme("com.jgoodies.looks.plastic.theme.DesertGreen");
        this.addTheme("com.jgoodies.looks.plastic.theme.DesertRed");
        this.addTheme("com.jgoodies.looks.plastic.theme.DesertYellow");
        this.addTheme("com.jgoodies.looks.plastic.theme.ExperienceBlue");
        this.addTheme("com.jgoodies.looks.plastic.theme.ExperienceGreen");
        this.addTheme("com.jgoodies.looks.plastic.theme.ExperienceRoyale");
        this.addTheme("com.jgoodies.looks.plastic.theme.LightGray");
        this.addTheme("com.jgoodies.looks.plastic.theme.Silver");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyBlue");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyBluer");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyGreen");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyKrupp");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyPink");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyRed");
        this.addTheme("com.jgoodies.looks.plastic.theme.SkyYellow");
    }

    private void addTheme(String theme) {
        try {
            Class<?> c = Class.forName(theme);
            this.themeList.add(c.newInstance());
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().warning("Could not add theme: " + theme);
        }
    }

    protected JMenu buildThemeMenu() {
        this.themesMenu = new JMenu();
        this.themesMenu.setText(this.rb.getString("Menu.Themes.Name"));
        this.themesMenu.setMnemonic(this.rb.getMnemonic("Menu.Themes.Mnemonic"));
        ButtonGroup themeButtonGroup = new ButtonGroup();
        this.buildThemeList();
        for (Object aThemeList : this.themeList) {
            MetalTheme theme = (MetalTheme)aThemeList;
            JRadioButtonMenuItem button = new JRadioButtonMenuItem();
            button.setText(theme.getName());
            button.setActionCommand(THEME);
            button.setName(theme.getClass().getName());
            button.addActionListener(this);
            themeButtonGroup.add(button);
            this.themesMenu.add(button);
            if (!aThemeList.getClass().getName().equals(this.getCurrentTheme())) continue;
            button.setSelected(true);
        }
        this.refreshThemesState();
        return this.themesMenu;
    }

    private void refreshThemesState() {
        if (this.themesMenu != null) {
            try {
                LookAndFeel laf = UIManager.getLookAndFeel();
                if (laf instanceof MetalLookAndFeel) {
                    this.themesMenu.setEnabled(true);
                } else {
                    this.themesMenu.setEnabled(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isLookAndFeelAvailable(String laf) {
        try {
            Class<?> lnfClass = Class.forName(laf);
            LookAndFeel newLAF = (LookAndFeel)lnfClass.newInstance();
            return newLAF.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Preferences pref = Preferences.userNodeForPackage(MainFrame.class);
        String action = e.getActionCommand();
        String name = ((JMenuItem)e.getSource()).getName();
        if (action.equals(LF)) {
            pref.put(LF, name);
        } else if (action.equals(THEME)) {
            pref.put(THEME, name);
        }
        this.themeList.clear();
        this.themesMenu.removeAll();
        this.frame = null;
        this.themesMenu = null;
        UIApplication.restartUI();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ThemeManager.this.frame = (JFrame)((Object)UIApplication.getFrame());
            }
        });
    }

    public static void reduceNimbusButtonMargin(JButton button) {
        UIDefaults buttonDefaults = new UIDefaults();
        buttonDefaults.put("Button.contentMargins", new Insets(6, 6, 6, 6));
        button.putClientProperty("Nimbus.Overrides", buttonDefaults);
        button.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
    }

    static {
        ThemeManager.installLookAndFeel("JGoodies Plastic", JGOODIESPLASTICLF);
        ThemeManager.installLookAndFeel("JGoodies Plastic 3D", JGOODIESPLASTIC3DLF);
        ThemeManager.installLookAndFeel("JGoodies Plastic XP", JGOODIESPLASTICXPLF);
        ThemeManager.installLookAndFeel("JGoodies Windows", JGOODIESEXTWINDOWS);
        ThemeManager.installLookAndFeel("MAC Look & Feel", MAC);
        ThemeManager.installLookAndFeel("Substance Business Look & Feel", SUBSTANCE_BUS);
        ThemeManager.installLookAndFeel("Substance Emerald Dusk Look & Feel", SUBSTANCE_EMERALD);
        ThemeManager.installLookAndFeel("Substance Moderate Look & Feel", SUBSTANCE_MODERATE);
        ThemeManager.installLookAndFeel("Substance Raven Look & Feel", SUBSTANCE_RAVEN);
        ThemeManager.installLookAndFeel("NimROD Look & Feel", NIMROD);
        ThemeManager.installLookAndFeel("Tiny Look & Feel", TINY);
    }
}

