/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xml;

import java.io.File;
import java.util.Collection;
import java.util.logging.Logger;
import jgnash.engine.DataStore;
import jgnash.engine.Engine;
import jgnash.engine.StoredObject;
import jgnash.engine.xml.XMLContainer;
import jgnash.engine.xml.XMLEngineDAO;
import jgnash.util.Resource;

public class XMLDataStore
implements DataStore {
    private static Logger log = Logger.getLogger(XMLDataStore.class.getName());
    private static final String FILE_EXT = "xml";
    private Engine engine;
    private XMLContainer container;

    @Override
    public void closeEngine() {
        this.container.commit();
        this.container.close();
        this.container = null;
        this.engine = null;
    }

    @Override
    public Engine getLocalEngine(String fileName, String engineName) {
        File file = new File(fileName);
        this.container = new XMLContainer(file);
        if (file.exists()) {
            this.container.readXML();
        }
        this.engine = new Engine(new XMLEngineDAO(this.container), engineName);
        log.info("Created local XML container and engine");
        return this.engine;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public final String getFileExt() {
        return FILE_EXT;
    }

    @Override
    public final String getFileName() {
        return this.container.getFileName();
    }

    @Override
    public Engine getClientEngine(String host, int port, String user, String password, String engineName) {
        throw new UnsupportedOperationException("Client / Server operation not supported for this type.");
    }

    public String toString() {
        return Resource.get().getString("DataStoreType.XML");
    }

    @Override
    public void saveAs(File file, Collection<StoredObject> objects) {
        XMLContainer.writeXML(objects, file);
    }
}

