/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree.algebra;

import com.db4o.foundation.Iterator4;
import com.db4o.foundation.SortedCollection4;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeSingle;
import com.db4o.internal.btree.BTreeRangeUnion;

class BTreeAlgebra {
    BTreeAlgebra() {
    }

    public static BTreeRange intersect(BTreeRangeUnion bTreeRangeUnion, BTreeRangeSingle bTreeRangeSingle) {
        SortedCollection4 sortedCollection4 = BTreeAlgebra.newBTreeRangeSingleCollection();
        BTreeAlgebra.collectIntersections(sortedCollection4, bTreeRangeUnion, bTreeRangeSingle);
        return BTreeAlgebra.toRange(sortedCollection4);
    }

    public static BTreeRange intersect(BTreeRangeUnion bTreeRangeUnion, BTreeRangeUnion bTreeRangeUnion2) {
        SortedCollection4 sortedCollection4 = BTreeAlgebra.newBTreeRangeSingleCollection();
        Iterator4 iterator4 = bTreeRangeUnion.ranges();
        while (iterator4.moveNext()) {
            BTreeRangeSingle bTreeRangeSingle = (BTreeRangeSingle)iterator4.current();
            BTreeAlgebra.collectIntersections(sortedCollection4, bTreeRangeUnion2, bTreeRangeSingle);
        }
        return BTreeAlgebra.toRange(sortedCollection4);
    }

    private static void collectIntersections(SortedCollection4 sortedCollection4, BTreeRangeUnion bTreeRangeUnion, BTreeRangeSingle bTreeRangeSingle) {
        Iterator4 iterator4 = bTreeRangeUnion.ranges();
        while (iterator4.moveNext()) {
            BTreeRangeSingle bTreeRangeSingle2 = (BTreeRangeSingle)iterator4.current();
            if (!bTreeRangeSingle.overlaps(bTreeRangeSingle2)) continue;
            sortedCollection4.add(bTreeRangeSingle.intersect(bTreeRangeSingle2));
        }
    }

    public static BTreeRange intersect(BTreeRangeSingle bTreeRangeSingle, BTreeRangeSingle bTreeRangeSingle2) {
        BTreePointer bTreePointer = BTreePointer.max(bTreeRangeSingle.first(), bTreeRangeSingle2.first());
        BTreePointer bTreePointer2 = BTreePointer.min(bTreeRangeSingle.end(), bTreeRangeSingle2.end());
        return bTreeRangeSingle.newBTreeRangeSingle(bTreePointer, bTreePointer2);
    }

    public static BTreeRange union(BTreeRangeUnion bTreeRangeUnion, BTreeRangeUnion bTreeRangeUnion2) {
        Iterator4 iterator4 = bTreeRangeUnion.ranges();
        BTreeRange bTreeRange = bTreeRangeUnion2;
        while (iterator4.moveNext()) {
            bTreeRange = bTreeRange.union((BTreeRange)iterator4.current());
        }
        return bTreeRange;
    }

    public static BTreeRange union(BTreeRangeUnion bTreeRangeUnion, BTreeRangeSingle bTreeRangeSingle) {
        if (bTreeRangeSingle.isEmpty()) {
            return bTreeRangeUnion;
        }
        SortedCollection4 sortedCollection4 = BTreeAlgebra.newBTreeRangeSingleCollection();
        sortedCollection4.add(bTreeRangeSingle);
        BTreeRangeSingle bTreeRangeSingle2 = bTreeRangeSingle;
        Iterator4 iterator4 = bTreeRangeUnion.ranges();
        while (iterator4.moveNext()) {
            BTreeRangeSingle bTreeRangeSingle3 = (BTreeRangeSingle)iterator4.current();
            if (BTreeAlgebra.canBeMerged(bTreeRangeSingle3, bTreeRangeSingle2)) {
                sortedCollection4.remove(bTreeRangeSingle2);
                bTreeRangeSingle2 = BTreeAlgebra.merge(bTreeRangeSingle3, bTreeRangeSingle2);
                sortedCollection4.add(bTreeRangeSingle2);
                continue;
            }
            sortedCollection4.add(bTreeRangeSingle3);
        }
        return BTreeAlgebra.toRange(sortedCollection4);
    }

    private static BTreeRange toRange(SortedCollection4 sortedCollection4) {
        if (1 == sortedCollection4.size()) {
            return (BTreeRange)sortedCollection4.singleElement();
        }
        return new BTreeRangeUnion(sortedCollection4);
    }

    private static SortedCollection4 newBTreeRangeSingleCollection() {
        return new SortedCollection4(BTreeRangeSingle.COMPARISON);
    }

    public static BTreeRange union(BTreeRangeSingle bTreeRangeSingle, BTreeRangeSingle bTreeRangeSingle2) {
        if (bTreeRangeSingle.isEmpty()) {
            return bTreeRangeSingle2;
        }
        if (bTreeRangeSingle2.isEmpty()) {
            return bTreeRangeSingle;
        }
        if (BTreeAlgebra.canBeMerged(bTreeRangeSingle, bTreeRangeSingle2)) {
            return BTreeAlgebra.merge(bTreeRangeSingle, bTreeRangeSingle2);
        }
        return new BTreeRangeUnion(new BTreeRangeSingle[]{bTreeRangeSingle, bTreeRangeSingle2});
    }

    private static BTreeRangeSingle merge(BTreeRangeSingle bTreeRangeSingle, BTreeRangeSingle bTreeRangeSingle2) {
        return bTreeRangeSingle.newBTreeRangeSingle(BTreePointer.min(bTreeRangeSingle.first(), bTreeRangeSingle2.first()), BTreePointer.max(bTreeRangeSingle.end(), bTreeRangeSingle2.end()));
    }

    private static boolean canBeMerged(BTreeRangeSingle bTreeRangeSingle, BTreeRangeSingle bTreeRangeSingle2) {
        return bTreeRangeSingle.overlaps(bTreeRangeSingle2) || bTreeRangeSingle.adjacent(bTreeRangeSingle2);
    }
}

