/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.file;

import EDU.purdue.cs.bloat.file.Attribute;
import EDU.purdue.cs.bloat.file.GenericAttribute;
import EDU.purdue.cs.bloat.file.LineNumberTable;
import EDU.purdue.cs.bloat.file.LocalVariableTable;
import EDU.purdue.cs.bloat.reflect.Catch;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.Constant;
import EDU.purdue.cs.bloat.reflect.LineNumberDebugInfo;
import EDU.purdue.cs.bloat.reflect.LocalDebugInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Code
extends Attribute {
    private ClassInfo classInfo;
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private Catch[] handlers;
    private LineNumberTable lineNumbers;
    private LocalVariableTable locals;
    private Attribute[] attrs;

    Code(ClassInfo classInfo, int codeIndex) {
        super(codeIndex, -1);
        this.classInfo = classInfo;
        this.maxStack = -1;
        this.maxLocals = -1;
        this.code = new byte[0];
        this.handlers = new Catch[0];
        this.lineNumbers = null;
        this.locals = null;
        this.attrs = new Attribute[0];
    }

    public Code(ClassInfo classInfo, DataInputStream in, int index, int len) throws IOException {
        super(index, len);
        this.classInfo = classInfo;
        this.maxStack = in.readUnsignedShort();
        this.maxLocals = in.readUnsignedShort();
        int codeLength = in.readInt();
        this.code = new byte[codeLength];
        int read = 0;
        while (read < codeLength) {
            read += in.read(this.code, read, codeLength - read);
        }
        int numHandlers = in.readUnsignedShort();
        this.handlers = new Catch[numHandlers];
        int i = 0;
        while (i < numHandlers) {
            this.handlers[i] = this.readCatch(in);
            ++i;
        }
        int numAttributes = in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        int i2 = 0;
        while (i2 < numAttributes) {
            int nameIndex = in.readUnsignedShort();
            int length = in.readInt();
            Constant name = classInfo.constants()[nameIndex];
            if (name != null) {
                if ("LineNumberTable".equals(name.value())) {
                    this.lineNumbers = new LineNumberTable(in, nameIndex, length);
                    this.attrs[i2] = this.lineNumbers;
                } else if ("LocalVariableTable".equals(name.value())) {
                    this.locals = new LocalVariableTable(in, nameIndex, length);
                    this.attrs[i2] = this.locals;
                }
            }
            if (this.attrs[i2] == null) {
                this.attrs[i2] = new GenericAttribute(in, nameIndex, length);
            }
            ++i2;
        }
    }

    public void writeData(DataOutputStream out) throws IOException {
        out.writeShort(this.maxStack);
        out.writeShort(this.maxLocals);
        out.writeInt(this.code.length);
        out.write(this.code, 0, this.code.length);
        out.writeShort(this.handlers.length);
        int i = 0;
        while (i < this.handlers.length) {
            this.writeCatch(out, this.handlers[i]);
            ++i;
        }
        out.writeShort(this.attrs.length);
        i = 0;
        while (i < this.attrs.length) {
            out.writeShort(this.attrs[i].nameIndex());
            out.writeInt(this.attrs[i].length());
            this.attrs[i].writeData(out);
            ++i;
        }
    }

    private Catch readCatch(DataInputStream in) throws IOException {
        int startPC = in.readUnsignedShort();
        int endPC = in.readUnsignedShort();
        int handlerPC = in.readUnsignedShort();
        int catchType = in.readUnsignedShort();
        return new Catch(startPC, endPC, handlerPC, catchType);
    }

    private void writeCatch(DataOutputStream out, Catch c) throws IOException {
        int startPC = c.startPC();
        int endPC = c.endPC();
        int handlerPC = c.handlerPC();
        int catchType = c.catchTypeIndex();
        out.writeShort(startPC);
        out.writeShort(endPC);
        out.writeShort(handlerPC);
        out.writeShort(catchType);
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public int maxStack() {
        return this.maxStack;
    }

    public int maxLocals() {
        return this.maxLocals;
    }

    public void setExceptionHandlers(Catch[] handlers) {
        this.handlers = handlers;
    }

    public int length() {
        int length = 8 + this.code.length + 2 + this.handlers.length * 8 + 2;
        int i = 0;
        while (i < this.attrs.length) {
            length += 6 + this.attrs[i].length();
            ++i;
        }
        return length;
    }

    public LineNumberDebugInfo[] lineNumbers() {
        if (this.lineNumbers != null) {
            return this.lineNumbers.lineNumbers();
        }
        return new LineNumberDebugInfo[0];
    }

    public LocalDebugInfo[] locals() {
        if (this.locals != null) {
            return this.locals.locals();
        }
        return new LocalDebugInfo[0];
    }

    public void setLineNumbers(LineNumberDebugInfo[] lineNumbers) {
        if (lineNumbers == null) {
            int i = 0;
            while (i < this.attrs.length) {
                if (this.lineNumbers == this.attrs[i]) {
                    Attribute[] a = this.attrs;
                    this.attrs = new Attribute[a.length - 1];
                    System.arraycopy(a, 0, this.attrs, 0, i);
                    System.arraycopy(a, i + 1, this.attrs, i, this.attrs.length - i);
                    break;
                }
                ++i;
            }
            this.lineNumbers = null;
        } else if (this.lineNumbers != null) {
            this.lineNumbers.setLineNumbers(lineNumbers);
        }
    }

    public void setLocals(LocalDebugInfo[] locals) {
        if (locals == null) {
            int i = 0;
            while (i < this.attrs.length) {
                if (this.locals == this.attrs[i]) {
                    Attribute[] a = this.attrs;
                    this.attrs = new Attribute[a.length - 1];
                    System.arraycopy(a, 0, this.attrs, 0, i);
                    System.arraycopy(a, i + 1, this.attrs, i, this.attrs.length - i);
                    break;
                }
                ++i;
            }
            this.locals = null;
        } else if (this.locals != null) {
            this.locals.setLocals(locals);
        }
    }

    public Catch[] exceptionHandlers() {
        return this.handlers;
    }

    public byte[] code() {
        return this.code;
    }

    public int codeLength() {
        return this.code.length;
    }

    public void setCode(byte[] code) {
        this.code = code;
    }

    private Code(Code other) {
        super(other.nameIndex, other.length);
        this.classInfo = other.classInfo;
        this.maxStack = other.maxStack;
        this.maxLocals = other.maxLocals;
        this.code = new byte[other.code.length];
        System.arraycopy(other.code, 0, this.code, 0, other.code.length);
        this.handlers = new Catch[other.handlers.length];
        int i = 0;
        while (i < other.handlers.length) {
            this.handlers[i] = (Catch)other.handlers[i].clone();
            ++i;
        }
        if (other.lineNumbers != null) {
            this.lineNumbers = (LineNumberTable)other.lineNumbers.clone();
        }
        if (other.locals != null) {
            this.locals = (LocalVariableTable)other.locals.clone();
        }
        this.attrs = new Attribute[other.attrs.length];
        i = 0;
        while (i < other.attrs.length) {
            this.attrs[i] = other.attrs[i];
            ++i;
        }
    }

    public Object clone() {
        return new Code(this);
    }

    public String toString() {
        String x = "";
        if (this.handlers != null) {
            int i = 0;
            while (i < this.handlers.length) {
                x = String.valueOf(x) + "\n        " + this.handlers[i];
                ++i;
            }
        }
        return "(code " + this.maxStack + " " + this.maxLocals + " " + this.code.length + x + ")";
    }
}

