<%!
	// Custom Paypal shopping cart 1.0
	// (C) Laszlo Molnar, 2008
	
	// Please note that this configuration will be used for all albums you make with this version of the skin
	// and cutom Paypal shopping cart is selected!
	// If you upgrade the skin you might need to copy this file into the new skin version's /includes folder
	//
	// The mandatory fields are the following:
	// email - the paypal account email
	// currency - the currency of all transactions (you can only have one currency per shopping cart)
	// option - the shopping option name. At least one is required
	// price - the price of the option. At least on is required similarly.
	// 
	// The following variables will taken over from Chameleon user interface if not found or empty here:
	// tableHead, email, currency
	//
	// The following variables must have the same number of fields as the option array:
	// price, shipping
	// select1_applyto, select2_applyto, quantity_applyto (if used)
	//
	// If you would like to omit a certain field or label - besides the mandatory fields -
	// use the double slash (//) before them
	//
	// Don't use quote and ampersand in any of the following strings, because that will trigger 
	// Javascript error. Use their HTML equivalent instead: &quot; &amp; (don't forget the semicolon!)
	
	// The head of the Paypal table. You can use HTML tags to format:
	// <b>Bold</b> <i>Italic</i> <br /> = line break
	
	String tableHead = "<b>Order this item via Paypal</b>! Choose the format and quantity and click <b>Add to Cart</b>!";
	
	// Change it to your Paypal account. Mandatory field!!! 
	// Will be overwritten with the User Interface value if not empty

	String email = "me@mysite.com";

	// Specify the currency with 3-letter code. Mandatory field!!!
	// Will be overwritten with the User Interface value if not empty
	// British Pound: GBP, Euro: EUR, Australian Dollar: AUD, Canadian Dollar: CAD, etc.

	String currency = "USD";
	
	// Shopping options. You must specify at least one option. You need to define as much Price and Shipping
	// as much shopping option you defined here. At least one option is mandatory!!! 

	String option_label = "Type";
	String[] option = { "8x6 Print", "10x8 Print", "20x28 Poster", "Download (small)", "Download (medium)", "Download (large)" };

	// Prices of the different options. Never use currency signs, as that will break the Paypal order.
	// If you plan to use individual prices (see below) you still need to have the prices defined here.
	// They will act as default values if no price data found in a particular file.
	
	String price_label = "Price";
	String[] price = { "1.00", "4.00", "20.00", "2.00", "8.00", "20.00" };

	// The price_source is the metadata field is the source for individual prices.
	// Leave empty if you want the same price for all pictures.
	// Suggested fields: "Windows XP Keywords", "Windows XP Comment", "Iptc.Caption" or "Iptc.Description".
	// If you have more than one option, enter all the prices separated by spaces: 1.00 2.00 4.00

	String price_source = "Windows XP Comment";
	
	// Shipping fee of the different options - will be applied per piece. 
	// You need to have one price for every shopping option, though that can be "0.00".

	String shipping_label = "Shipping";
	String[] shipping = { "1.00", "1.00", "1.00", "0.00", "0.00", "0.00" };
	
	// Additional select box 1. This will make a Combo box of the items below. 
	// The select1_applyto array controls if this combo box appears with the different shopping options.
	// Use true or false. If you don't want this box to appear use false for all fields or you can comment out
	// all the 3 following lines completely - use the // method.

	String select1_label = "Color";
	String[] select1 = { "Color", "B&amp;W", "Sepia" };
	boolean[] select1_applyto = { true, true, true, false, false, false };
	
	// Additional select box 2. The same applies as to select1.

	String select2_label = "Finish";
	String[] select2 = { "Glossy", "Matte" };
	boolean[] select2_applyto = { true, true, false, false, false, false };
	
	// Quantity box. Users can specify any number of items to put in the shopping cart.

	String quantity_label = "Quantity";
	boolean[] quantity_applyto = { true, true, true, false, false, false };	
	
	// Order button text

	String order_label = "Order";
	
	// Handline fee.

	String handling = "0.00";

	// Handling fee: when "true" it is applied once per cart - if "false" applied per item.
	// Paypal had problems with Cartwise handling recently - i.e. it is not added at all

	boolean flatHandlingCartwise = true;
	
	// Use old style button (Black and White) = true  or new (Orange) = false
	
	boolean oldStyleButton = true;
	
	/****************************************************************************************
	 * Do not change the code below this line - or do at your own risk :)
	 ****************************************************************************************/
	 
	 // Initializing variables - executed once per album
	
	if (tableHead == null || tableHead.length() == 0) {
		String s = chameleon.paypalHint;
		if (s != null && s.length() > 0)
			tableHead = s;
		else
			tableHead = "";
	}

	if (email == null || email.length() == 0) {
		s = chameleon.paypalEmail;
		if (s != null && s.length() > 0)
			email = s;
		else
			email = "";
	}

	if (currency == null || currency.length() == 0) {
		s = chameleon.paypalCurrency;
		if (s != null && s.length() > 0)
			currency = s;
		else
			currency = "";
	}

	int columns = 3;

	boolean shipping_used = false;
	if (shipping != void) {
		for (i = 0; i < shipping.length; i++)
			if (!shipping[i].equals("0.00")) {
				shipping_used = true;
				columns++;
				break;
			}
	}
	
	boolean select1_used = false;
	if (select1 != void && select1_applyto != void) {
		for (i = 0; i < select1.length; i++)
			if (select1_applyto[i]) {
				select1_used = true;
				columns++;
				break;
			}
	}

	boolean select2_used = false;
	if (select2 != void && select2_applyto != void) {
		for (i = 0; i < select2.length; i++)
			if (select2_applyto[i]) {
				select2_used = true;
				columns++;
				break;
			}
	}
	
	boolean quantity_used = false;
	if (quantity_applyto != void) {
		for (i = 0; i < quantity_applyto.length; i++)
			if (quantity_applyto[i]) {
				quantity_used = true;
				columns++;
				break;
			}
	}
	
	boolean handling_used = (handling != void) && !handling.equals("0.00");
		
	boolean tablehead_used = (option_label != void && option_label.length() > 0) || 
		(price_label != void && price_label.length() > 0) || 
		(shipping_used && shipping_label != void && shipping_label.length() > 0) ||
		(select1_used && select1_label != void && select1_label.length() > 0) ||
		(select2_used && select2_label != void && select2_label.length() > 0) ||
		(quantity_used && quantity_label != void && quantity_label.length() > 0) ||
		(order_label != void && order_label.length() > 0);
		
%>
<%
	// The code part executed on every page
	
	if (option != void && option.length > 0 && price != void && price.length >= option.length 
		&& email != void && email.length() > 0) {
		
		int i, j;
		String s;
		
		// Reading the Price from an external source
		
		if (price_source != void && price_source.length() > 0 && meta != void && meta != null) {
			s = meta.get(price_source);
			if (s != null) {
				String[] p = s.split("\\s+");
				for (i = 0; i < p.length && i < price.length; i++)
					price[i] = p[i];
			}
		}
		
		// Head of the table
			
		if (tableHead != void && tableHead != null && tableHead.length() > 0)
			out.println("<div class=\"thumb\" style=\"text-align:center; font-size:1.25em; padding:4px; margin:2px;\">" + tableHead + "</div>");

		// Labels of the table
		
		out.println("<table style=\"width:98%;\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" align=\"center\">");
		
		if (tablehead_used) {
			out.println("\t<tr><td class=\"xsmalltxt\">" + ((option_label != void && option_label.length() > 0)? option_label : "&nbsp;") + "</td>");
			out.println("<td class=\"xsmalltxt\" style=\"width:80px\">" + ((price_label != void && price_label.length() > 0)? price_label : "&nbsp;") + "</td>");
			
			if (shipping_used)
				out.println("\t<td class=\"xsmalltxt\" style=\"width:80px\">" + ((shipping_label != void && shipping_label.length() > 0)? shipping_label : "&nbsp;") + "</td>");
			
			if (select1_used)
				out.println("\t<td class=\"xsmalltxt\" style=\"width:120px\">" + ((select1_label != void && select1_label.length() > 0)? select1_label : "&nbsp;") + "</td>");
			
			if (select2_used)
				out.println("\t<td class=\"xsmalltxt\" style=\"width:120px\">" + ((select2_label != void && select2_label.length() > 0)? select2_label : "&nbsp;") + "</td>");
			
			if (quantity_used)
				out.println("\t<td class=\"xsmalltxt\" style=\"width:40px\">" + ((quantity_label != void && quantity_label.length() > 0)? quantity_label : "&nbsp;") + "</td>");
			
			out.println("\t<td class=\"xsmalltxt\" style=\"width:100px\">" + ((order_label != void && order_label.length() > 0)? order_label : "&nbsp;") + "</td></tr>");
		}
		
		out.println("</table>");
		
		// Shopping options table
		
		for (i = 0; i < option.length; i++) {
			
			out.println("<form target=\"paypal\" name=\"paypal" + i + "\" action=\"https://www.paypal.com/cgi-bin/webscr/\" method=\"post\" style=\"margin:0\">");
			out.println("\t<input type=\"hidden\" name=\"cmd\" value=\"_cart\" />");
			out.println("\t<input type=\"hidden\" name=\"business\" value=\"" + email + "\" />");
			out.println("\t<input type=\"hidden\" name=\"currency_code\" value=\"" + currency + "\" />");
			if (shipping_used && i < shipping.length) {
				out.println("\t<input type=\"hidden\" name=\"shipping\" value=\"" + shipping[i] + "\" />");
				out.println("\t<input type=\"hidden\" name=\"shipping2\" value=\"" + shipping[i] + "\" />");
			}
			out.println("\t<input type=\"hidden\" name=\"amount\" value=\"" + price[i] + "\" />");
			out.println("\t<input type=\"hidden\" name=\"item_name\" value=\"" + option[i] + "\" />");
			out.println("\t<input type=\"hidden\" name=\"item_number\" value=\"" + chameleon.stripNonWeb(chameleon.simplePath + "/" + label) + "\" />");
			if (handling_used) {
				if (flatHandlingCartwise)
					out.println("\t<input type=\"hidden\" name=\"handling_cart\" value=\"" + handling + "\" />");
				else
					out.println("\t<input type=\"hidden\" name=\"handling\" value=\"" + handling + "\" />");
			}
			out.println("\t<table style=\"width:98%;\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\" align=\"center\"><tr>");
			out.println("\t\t<td class=\"smalltxt\" style=\"text-align:left; font-weight:bold;\">" + option[i] + "</td>");
			out.println("\t\t<td class=\"smalltxt\" style=\"width:80px\">" + currency + " " + price[i] + "</td>");
			
			if (shipping_used)
				out.println("\t\t<td class=\"smalltxt\" style=\"width:80px\">" + currency + " " + ((i < shipping.length)? shipping[i] : 0) + "</td>");

			if (select1_used) {
				if (i < select1_applyto.length && select1_applyto[i]) {
					out.println("\t\t<td style=\"width:120px\"><input type=\"hidden\" name=\"on0\" value=\"Select1\" />");
					out.println("\t\t\t<select name=\"os0\" style=\"font-size:0.9em;\">");
					for (j = 0; j < select1.length; j++)
						out.println("\t\t\t<option value=\"" + select1[j] + "\">" + select1[j] + "</option>");
					out.println("\t\t\t</select></td>");
				}
				else
					out.println("\t\t<td style=\"width:120px\">&nbsp;</td>");
			}
			
			if (select2_used) {
				if (i < select2_applyto.length && select2_applyto[i]) {
					out.println("\t\t<td style=\"width:120px\"><input type=\"hidden\" name=\"on1\" value=\"Select2\" />");
					out.println("\t\t\t<select name=\"os1\" style=\"font-size:0.9em;\">");
					for (j = 0; j < select2.length; j++)
						out.println("\t\t\t<option value=\"" + select2[j] + "\">" + select2[j] + "</option>");
					out.println("\t\t\t</select></td>");
				}
				else
					out.println("\t\t<td style=\"width:120px\">&nbsp;</td>");
			}
			
			if (quantity_used) {
				if (i < quantity_applyto.length && quantity_applyto[i])
					out.println("\t\t<td style=\"width:40px\"><input type=\"text\" name=\"quantity\" value=\"1\" size=\"2\" style=\"font-size:0.9em;\" /></td>");
				else
					out.println("\t\t<td style=\"width:40px\">&nbsp;</td>");
			}
			
			out.println("\t\t<td style=\"width:100px\"><input type=\"hidden\" name=\"add\" value=\"1\" />");
			if (oldStyleButton == true)
				out.println("\t\t<input type=\"image\" src=\"https://www.paypal.com/images/x-click-but22.gif\" name=\"submit\" alt=\"Pay with PayPal\" />");
			else
				out.println("\t\t<input type=\"image\" src=\"https://www.paypal.com/en_US/i/btn/btn_buynow_SM.gif\" name=\"submit\" alt=\"Pay with PayPal\" />");
			out.println("\t\t</td></tr>");
			out.println("\t</table>");
			out.println("</form>");
		}
	}
	
	// View Cart form / button
	
	out.println("<div style=\"text-align:center; padding:6px;\">");
	out.println("<form target=\"paypal\" name=\"paypalview\" action=\"https://www.paypal.com/cgi-bin/webscr/\" method=\"post\" style=\"margin:0\">");
	out.println("\t<input type=\"hidden\" name=\"cmd\" value=\"_cart\" />");
	out.println("\t<input type=\"hidden\" name=\"business\" value=\"" + email + "\" />");
	if (oldStyleButton == true)
		out.println("\t<input type=\"image\" src=\"https://www.paypal.com/images/view_cart_02.gif\" name=\"submit\" alt=\"View your shopping cart\" />");
	else
		out.println("\t<input type=\"image\" src=\"https://www.paypal.com/en_US/i/btn/btn_viewcart_SM.gif\" name=\"submit\" alt=\"View your shopping cart\" />");
	out.println("\t<input type=\"hidden\" name=\"display\" value=\"1\" />");
	out.println("</form></div>");
%>
