/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.lang.Rational;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.xmp.XmpDirectory;
import java.io.File;
import java.io.InputStream;
import java.util.Calendar;

public class XmpReader
implements MetadataReader {
    private final byte[] _data;
    private Metadata _metadata;
    private static final int FMT_STRING = 1;
    private static final int FMT_RATIONAL = 2;
    private static final int FMT_INT = 3;
    private static final int FMT_DOUBLE = 4;
    private static final String SCHEMA_EXIF_SPECIFIC_PROPERTIES = "http://ns.adobe.com/exif/1.0/";
    private static final String SCHEMA_EXIF_ADDITIONAL_PROPERTIES = "http://ns.adobe.com/exif/1.0/aux/";
    private static final String SCHEMA_EXIF_TIFF_PROPERTIES = "http://ns.adobe.com/tiff/1.0/";

    public XmpReader(JpegSegmentData segmentData) {
        this(segmentData.getSegment((byte)-31, 1));
    }

    public XmpReader(File file) throws JpegProcessingException {
        this(new JpegSegmentReader(file).readSegment((byte)-31, 1));
    }

    public XmpReader(InputStream is) throws JpegProcessingException {
        this(new JpegSegmentReader(is).readSegment((byte)-31, 1));
    }

    public XmpReader(byte[] data) {
        this._data = data;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    public Metadata extract(Metadata metadata) {
        this._metadata = metadata;
        if (this._data == null) {
            return this._metadata;
        }
        XmpDirectory directory = (XmpDirectory)this._metadata.getDirectory(XmpDirectory.class);
        if (this._data.length <= 30) {
            directory.addError("Xmp data segment must contain at least 30 bytes");
            return this._metadata;
        }
        if (!"http://ns.adobe.com/xap/1.0/\u0000".equals(new String(this._data, 0, 29))) {
            directory.addError("Xmp data segment doesn't begin with 'http://ns.adobe.com/xap/1.0/'");
            return this._metadata;
        }
        try {
            byte[] xmpBuffer = new byte[this._data.length - 29];
            System.arraycopy(this._data, 29, xmpBuffer, 0, this._data.length - 29);
            XMPMeta meta = XMPMetaFactory.parseFromBuffer((byte[])xmpBuffer);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:LensInfo", 6, 1);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:Lens", 7, 1);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:SerialNumber", 8, 1);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:Firmware", 9, 1);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_TIFF_PROPERTIES, "tiff:Make", 1, 1);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_TIFF_PROPERTIES, "tiff:Model", 2, 1);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ExposureTime", 3, 1);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ExposureProgram", 12, 3);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ApertureValue", 11, 2);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:FNumber", 5, 2);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:FocalLength", 10, 2);
            this.processXmpTag(meta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ShutterSpeedValue", 4, 2);
            this.processXmpDateTag(meta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:DateTimeOriginal", 13);
            this.processXmpDateTag(meta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:DateTimeDigitized", 14);
            for (XMPPropertyInfo propInfo : meta) {
                String path = propInfo.getPath();
                Object value = propInfo.getValue();
                if (path == null || value == null) continue;
                directory.getRawProperties().put(path, propInfo.getValue().toString());
            }
        }
        catch (XMPException e) {
            directory.addError("Can't parse xmp-data segment");
            return this._metadata;
        }
        return this._metadata;
    }

    void processXmpTag(XMPMeta meta, XmpDirectory directory, String schemaNs, String propName, int tagType, int formatCode) throws XMPException {
        String property = meta.getPropertyString(schemaNs, propName);
        if (null != property) {
            switch (formatCode) {
                case 2: {
                    String[] rationalParts = property.split("/", 2);
                    if (2 == rationalParts.length) {
                        Rational rational = new Rational((long)Float.parseFloat(rationalParts[0]), (long)Float.parseFloat(rationalParts[1]));
                        directory.setRational(tagType, rational);
                        break;
                    }
                    directory.addError("Error in rational format for tag " + tagType);
                    break;
                }
                case 3: {
                    directory.setInt(tagType, Integer.valueOf(property));
                    break;
                }
                case 4: {
                    directory.setDouble(tagType, Double.valueOf(property));
                    break;
                }
                case 1: {
                    directory.setString(tagType, property);
                    break;
                }
                default: {
                    directory.addError("Unknown format code " + formatCode + " for tag " + tagType);
                }
            }
        }
    }

    void processXmpDateTag(XMPMeta meta, XmpDirectory directory, String schemaNs, String propName, int tagType) throws XMPException {
        Calendar cal = meta.getPropertyCalendar(schemaNs, propName);
        if (null != cal) {
            directory.setDate(tagType, cal.getTime());
        }
    }
}

