/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.DirectoryListArgument;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestListings
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestListings.java,v 1.14 2010-04-26 15:56:42 bruceb Exp $";

    protected String getLogName() {
        return "TestListings.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDir() throws Exception {
        this.log.debug("testDir() - ENTRY");
        try {
            block6: {
                this.connect();
                this.ftp.chdir(this.testdir);
                String[] list = this.ftp.dir();
                this.print(list);
                list = this.ftp.dir(".");
                this.print(list);
                this.log.debug("Testing for empty dir: " + this.remoteEmptyDir);
                list = this.ftp.dir(this.remoteEmptyDir);
                this.print(list);
                this.log.debug("End testing for empty dir");
                String randomName = this.generateRandomFilename();
                try {
                    list = this.ftp.dir(randomName);
                    this.print(list);
                }
                catch (FTPException ex) {
                    if (ex.getReplyCode() == 550 || ex.getReplyCode() == 450 || ex.getReplyCode() == 2) break block6;
                    TestListings.fail((String)("dir(" + randomName + ") should throw 450/550 for non-existent dir"));
                }
            }
            this.ftp.quit();
        }
        finally {
            this.log.debug("testDir() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirFull() throws Exception {
        this.log.debug("testDirFull() - ENTRY");
        try {
            block6: {
                this.connect();
                this.ftp.chdir(this.testdir);
                String[] list = this.ftp.dir(".", true);
                this.print(list);
                this.log.debug("******* dirDetails *******");
                FTPFile[] files = this.ftp.dirDetails(".");
                this.print(files);
                this.log.debug("******* end dirDetails *******");
                this.log.debug("Testing for empty dir: " + this.remoteEmptyDir);
                list = this.ftp.dir(this.remoteEmptyDir, true);
                this.print(list);
                this.log.debug("End testing for empty dir");
                String randomName = this.generateRandomFilename();
                this.log.debug("Testing for non-existent dir: " + randomName);
                try {
                    list = this.ftp.dir(randomName, true);
                    this.print(list);
                }
                catch (FTPException ex) {
                    if (ex.getReplyCode() == 550 || ex.getReplyCode() == 450 || ex.getReplyCode() == 2) break block6;
                    TestListings.fail((String)("dir(" + randomName + ") should throw 450/550/2 for non-existent dir"));
                }
            }
            this.ftp.quit();
        }
        finally {
            this.log.debug("testDirFull() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDirFull2() throws Exception {
        this.log.debug("testDirFull2() - ENTRY");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            FTPFile[] files = this.ftp.dirDetails(".");
            DirCallback dirCallback = new DirCallback();
            this.ftp.dirDetails(".", dirCallback);
            if (dirCallback.getFiles().size() != files.length) {
                TestListings.fail((String)"Mismatch in listing length");
            }
            this.log.debug("Listing lengths match!");
            boolean allFound = true;
            for (int i = 0; i < files.length; ++i) {
                if (dirCallback.getFiles().get(files[i].getName()) != null) continue;
                this.log.debug("Failed to find " + files[i].getName());
                allFound = false;
            }
            if (!allFound) {
                Iterator i = dirCallback.getFiles().values().iterator();
                while (i.hasNext()) {
                    this.log.debug(((FTPFile)i.next()).getName());
                }
                TestListings.fail((String)"Failed to find all files");
            }
            this.ftp.quit();
        }
        finally {
            this.log.debug("testDirFull2() - EXIT");
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    public static Test suite() {
        return new TestSuite(TestListings.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestListings.suite());
    }

    class DirCallback
    implements DirectoryListCallback {
        private Map files = new HashMap();

        DirCallback() {
        }

        public void listDirectoryEntry(DirectoryListArgument arg) {
            this.files.put(arg.getEntry().getName(), arg.getEntry());
        }

        public Map getFiles() {
            return this.files;
        }
    }
}

