/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.fileutil;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import org.jdesktop.jdic.fileutil.SolarisNativeFileUtil;
import org.jdesktop.jdic.fileutil.UnixNativeFileUtil;
import org.jdesktop.jdic.fileutil.Win32NativeFileUtil;

abstract class NativeFileUtil {
    NativeFileUtil() {
    }

    public static NativeFileUtil getNativeFileUtil() throws UnsupportedOperationException {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return new Win32NativeFileUtil();
        }
        if (string.startsWith("Linux") || string.startsWith("LINUX")) {
            return new UnixNativeFileUtil();
        }
        if (string.startsWith("Solaris") || string.startsWith("SunOS")) {
            return new SolarisNativeFileUtil();
        }
        throw new UnsupportedOperationException("Your platform is not supported yet");
    }

    public abstract boolean recycle(File var1) throws IOException, SecurityException, UnsupportedOperationException;

    public abstract BigInteger getFreeSpace(File var1) throws IOException, UnsupportedOperationException;

    public abstract BigInteger getTotalSpace(File var1) throws IOException, UnsupportedOperationException;

    public abstract String readFirst(String var1);

    public abstract String readNext();

    public abstract void close();
}

