/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;

public class Debug {
    public static void showErrorDialog(Component parent, Throwable t) {
        Debug.showErrorDialog(parent, t, false);
    }

    public static void showFriendlyErrorDialog(Component parent, Throwable t) {
        Debug.showErrorDialog(parent, t, true);
    }

    private static void showErrorDialog(Component parent, Throwable t, boolean friendly) {
        if (t instanceof RuntimeException && !(t instanceof IllegalArgumentException)) {
            Debug.showStackTraceDialog(parent, t);
        } else {
            String message = friendly ? t.getMessage() : t.toString();
            JOptionPane.showMessageDialog(parent, message, Msg.getString("ui.errorOccured"), 0);
        }
    }

    public static void showStackTraceDialog(Component parent, Throwable t) {
        t.printStackTrace(System.out);
        JScrollPane sp = new JScrollPane();
        StringWriter sw = new StringWriter();
        PrintWriter err = new PrintWriter(sw);
        err.println("An unexpected error occured. Please see detailed description below:");
        err.println("");
        t.printStackTrace(err);
        err.close();
        JSmartTextArea ta = new JSmartTextArea(sw.toString());
        ta.setEditable(false);
        sp.getViewport().add((Component)ta, null);
        JOptionPane.showMessageDialog(parent, sp, Msg.getString("ui.unexpectedErrorOccured"), 0);
    }

    public static void showCopyableError(Component parent, Throwable t, String title) {
        JScrollPane sp = new JScrollPane();
        StringWriter sw = new StringWriter();
        PrintWriter err = new PrintWriter(sw);
        err.println(t.getMessage());
        err.close();
        JSmartTextArea ta = new JSmartTextArea(sw.toString());
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setColumns(80);
        ta.setRows(15);
        sp.getViewport().add((Component)ta, null);
        JOptionPane.showMessageDialog(parent, sp, title, 0);
    }

    public static void printClassInfo(Class c) {
        System.out.println("Class info:");
        do {
            System.out.println(c.getName() + " Loader: " + c.getClassLoader());
        } while ((c = c.getSuperclass()) != null);
    }

    public static void showErrorDialog(JAlbumFrame window, IOException ex) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

