/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JTextField;
import se.datadosen.component.JColorSelector;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.Colors;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.PersistentList;
import se.datadosen.util.annotations.Unbound;

public class BeanBinder {
    public static void debug(Object bean, Object jComponentHolder) throws Exception {
        Class<?> beanClass = bean.getClass();
        Method[] methods = beanClass.getMethods();
        System.out.println("Properties of bean:");
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("get") && !name.startsWith("is")) continue;
            String property = name.startsWith("get") ? name.substring(3) : name.substring(2);
            System.out.println(property);
        }
        System.out.println("GUI componnents:");
        Class<?> guiClass = jComponentHolder.getClass();
        Field[] fields = BeanBinder.getFields(guiClass);
        for (int i = 0; i < fields.length; ++i) {
            Object comp;
            String name = fields[i].getName();
            fields[i].setAccessible(true);
            int mods = fields[i].getModifiers();
            if (Modifier.isPrivate(mods) || Modifier.isProtected(mods) || !((comp = fields[i].get(jComponentHolder)) instanceof JComponent)) continue;
            System.out.println(name + " " + comp.getClass().getName());
        }
    }

    public static void getProperties(Object bean, Object[] holders) throws Exception {
        for (int i = 0; i < holders.length; ++i) {
            BeanBinder.getProperties(bean, holders[i]);
        }
    }

    public static void getProperties(Object bean, Object jComponentHolder) {
        try {
            Class<?> beanClass = bean.getClass();
            Method[] methods = beanClass.getMethods();
            Class<?> guiClass = jComponentHolder.getClass();
            Field[] fields = BeanBinder.getFields(guiClass);
            for (int i = 0; i < fields.length; ++i) {
                Object comp;
                String name = fields[i].getName();
                String getName = "get" + name;
                String isName = "is" + name;
                fields[i].setAccessible(true);
                int mods = fields[i].getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods) || !((comp = fields[i].get(jComponentHolder)) instanceof JComponent) && !(comp instanceof ButtonGroup)) continue;
                block4: for (int j = 0; j < methods.length; ++j) {
                    String metName = methods[j].getName();
                    if (!metName.equalsIgnoreCase(getName) && !metName.equalsIgnoreCase(isName)) continue;
                    Object ret = methods[j].invoke(bean, (Object[])new String[0]);
                    if (ret == null) {
                        ret = "";
                    }
                    if (comp instanceof JTextField) {
                        ((JTextField)comp).setText(ret.toString());
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        JComboBox jc = (JComboBox)comp;
                        boolean setOk = false;
                        for (int k = 0; k < jc.getItemCount(); ++k) {
                            Object item = jc.getItemAt(k);
                            if (!item.equals(ret)) continue;
                            if (jc.getSelectedIndex() != k) {
                                jc.setSelectedIndex(k);
                            }
                            setOk = true;
                            break;
                        }
                        if (setOk) continue;
                        jc.setSelectedItem(ret);
                        continue;
                    }
                    if (comp instanceof JSlider) {
                        JSlider js = (JSlider)comp;
                        js.setValue((Integer)ret);
                        continue;
                    }
                    if (comp instanceof JCheckBox) {
                        ((JCheckBox)comp).setSelected("true".equals(ret.toString()));
                        continue;
                    }
                    if (comp instanceof JColorSelector) {
                        JColorSelector cs = (JColorSelector)comp;
                        if (ret instanceof Color) {
                            cs.setColor((Color)ret);
                            continue;
                        }
                        cs.setColor(ret.toString());
                        continue;
                    }
                    if (comp instanceof ButtonGroup) {
                        ButtonGroup bg = (ButtonGroup)comp;
                        Enumeration<AbstractButton> buttons = bg.getElements();
                        while (buttons.hasMoreElements()) {
                            AbstractButton button = buttons.nextElement();
                            String ac = button.getActionCommand();
                            if (ac == null || !ac.equals(ret.toString())) continue;
                            bg.setSelected(button.getModel(), true);
                            continue block4;
                        }
                        continue;
                    }
                    if (!(comp instanceof PersistentList)) continue;
                    ((PersistentList)comp).setContent((List)ret);
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new BeanBinderException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new BeanBinderException(ex);
        }
    }

    public static Properties getProperties(Object bean) throws Exception {
        return BeanBinder.getProperties(bean, false, new Properties());
    }

    public static Properties getProperties(Object bean, Properties existing) throws Exception {
        return BeanBinder.getProperties(bean, false, existing);
    }

    public static Properties getProperties(Object bean, boolean nullProperties) throws Exception {
        return BeanBinder.getProperties(bean, nullProperties, new Properties());
    }

    public static Properties getProperties(Object bean, boolean nullProperties, Properties existing) throws Exception {
        Class<?> beanClass = bean.getClass();
        Method[] methods = beanClass.getMethods();
        Properties props = existing;
        for (int j = 0; j < methods.length; ++j) {
            String metName = methods[j].getName();
            if (!metName.startsWith("get") && !metName.startsWith("is") || methods[j].getParameterTypes().length != 0 || methods[j].getAnnotation(Unbound.class) != null) continue;
            Object ret = methods[j].invoke(bean, (Object[])new String[0]);
            if (ret == null && nullProperties) {
                ret = "";
            }
            if (ret != null && ret.getClass().getMethod("toString", new Class[0]).getDeclaringClass().equals(Object.class)) continue;
            if (ret instanceof List) {
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                for (Object o : (List)ret) {
                    if (!first) {
                        buf.append(',');
                    }
                    buf.append(o.toString());
                    first = false;
                }
                ret = buf;
            } else if (ret instanceof Color) {
                Color color = (Color)ret;
                ret = "#" + Integer.toHexString(color.getRGB()).substring(2);
            } else if (ret instanceof Enum) {
                ret = ((Enum)ret).name();
            }
            if (ret == null) continue;
            if (metName.startsWith("get")) {
                props.setProperty(BeanBinder.lowerInitial(metName.substring(3)), ret.toString());
                continue;
            }
            props.setProperty(BeanBinder.lowerInitial(metName.substring(2)), ret.toString());
        }
        return props;
    }

    private static String lowerInitial(String s) {
        return "" + Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static void setProperties(Object bean, Map props) throws BeanBinderException {
        Class<?> beanClass = bean.getClass();
        Method[] methods = beanClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Class<?>[] types;
            String sval;
            String metName = methods[j].getName();
            if (!metName.startsWith("set") || methods[j].getAnnotation(Unbound.class) != null) continue;
            String property = BeanBinder.lowerInitial(metName.substring(3));
            Object val = props.get(property);
            String string = sval = val != null ? val.toString() : null;
            if (sval == null) {
                val = props.get(metName.substring(3));
                String string2 = sval = val != null ? val.toString() : null;
            }
            if (sval == null || (types = methods[j].getParameterTypes()).length != 1) continue;
            String type = types[0].getName();
            val = null;
            try {
                if (type.equals("java.lang.String")) {
                    val = sval;
                } else if (type.equals("boolean")) {
                    val = new Boolean(!sval.equals("false"));
                } else if (type.equals("int")) {
                    val = new Integer(sval);
                } else if (type.equals("float")) {
                    val = new Float(sval);
                } else if (type.equals("double")) {
                    val = new Double(sval);
                } else if (type.equals("java.util.List")) {
                    LinkedList<String> list = new LinkedList<String>();
                    StringTokenizer tokens = new StringTokenizer(sval, ",");
                    while (tokens.hasMoreElements()) {
                        list.add(tokens.nextToken());
                    }
                    val = list;
                } else if (type.equals("java.awt.Color")) {
                    val = Colors.getHTMLColor(sval);
                } else if (types[0].isEnum()) {
                    val = Enum.valueOf(types[0], sval);
                }
                if (val == null) continue;
                methods[j].invoke(bean, val);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                throw new BeanBinderException("Invalid value for property " + property + ": " + sval, ex);
            }
        }
    }

    public static void setProperties(Object bean, Object[] source) {
        for (int i = 0; i < source.length; ++i) {
            BeanBinder.setProperties(bean, source[i]);
        }
    }

    public static void setProperties(Object bean, Object jComponentHolder) throws BeanBinderException {
        try {
            HashMap<String, Object> components = new HashMap<String, Object>();
            Class<?> beanClass = bean.getClass();
            Method[] methods = beanClass.getMethods();
            Class<?> guiClass = jComponentHolder.getClass();
            Field[] fields = BeanBinder.getFields(guiClass);
            for (int i = 0; i < fields.length; ++i) {
                Object comp;
                String name = fields[i].getName();
                fields[i].setAccessible(true);
                int mods = fields[i].getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods) || !((comp = fields[i].get(jComponentHolder)) instanceof JComponent) && !(comp instanceof ButtonGroup)) continue;
                components.put(name, comp);
            }
            for (int j = 0; j < methods.length; ++j) {
                Class<?>[] types;
                String name;
                Object comp;
                String metName = methods[j].getName();
                if (!metName.startsWith("set") || methods[j].getAnnotation(Unbound.class) != null) continue;
                char[] chars = metName.substring(3).toCharArray();
                if (chars.length > 0) {
                    chars[0] = Character.toLowerCase(chars[0]);
                }
                if ((comp = components.get(name = new String(chars))) == null || (types = methods[j].getParameterTypes()).length != 1) continue;
                String type = types[0].getName();
                Object val = null;
                try {
                    Object sel;
                    if (type.equals("java.lang.String")) {
                        if (comp instanceof JTextField) {
                            val = ((JTextField)comp).getText();
                        } else if (comp instanceof JComboBox) {
                            sel = ((JComboBox)comp).getSelectedItem();
                            val = sel != null && sel instanceof Item ? ((Item)sel).value.toString() : (sel != null ? sel.toString() : null);
                        } else if (comp instanceof ButtonGroup) {
                            val = ((ButtonGroup)comp).getSelection().getActionCommand();
                        }
                    } else if (type.equals("boolean") && comp instanceof JCheckBox) {
                        val = new Boolean(((JCheckBox)comp).isSelected());
                    } else if (type.equals("java.awt.Color") && comp instanceof JColorSelector) {
                        val = ((JColorSelector)comp).getColor();
                    } else if (type.equals("boolean") && comp instanceof ButtonGroup) {
                        val = new Boolean("true".equals(((ButtonGroup)comp).getSelection().getActionCommand()));
                    } else if (type.equals("int") && comp instanceof JTextField) {
                        val = new Integer(((JTextField)comp).getText());
                    } else if (type.equals("int") && comp instanceof JSlider) {
                        val = new Integer(((JSlider)comp).getValue());
                    } else if (type.equals("int") && comp instanceof JComboBox) {
                        sel = ((JComboBox)comp).getSelectedItem();
                        val = sel != null && sel instanceof Item ? new Integer(((Item)sel).value.toString()) : (sel != null ? new Integer(sel.toString()) : null);
                    } else if (comp instanceof PersistentList) {
                        val = ((PersistentList)comp).getContent();
                    }
                    if (val == null) continue;
                    methods[j].invoke(bean, val);
                    continue;
                }
                catch (InvocationTargetException ex) {
                    throw new BeanBinderException("Setting " + name + " caused:" + ex.getTargetException(), ex.getTargetException(), (JComponent)comp);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static Properties parseArgsOptions(String[] args) {
        Properties props = new Properties();
        String name = null;
        int i = 0;
        while (i < args.length) {
            if (name == null) {
                if (args[i].charAt(0) == '-') {
                    name = args[i].substring(1);
                }
                ++i;
                continue;
            }
            if (args[i].charAt(0) == '-') {
                props.put(name, "");
            } else {
                props.put(name, args[i]);
                ++i;
            }
            name = null;
        }
        if (name != null) {
            props.put(name, "");
        }
        return props;
    }

    static final Field[] getFields(Class guiClass) {
        Class parent = guiClass.getSuperclass();
        if (parent == null || !JComponentHolder.class.isAssignableFrom(guiClass)) {
            return guiClass.getDeclaredFields();
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        while (guiClass != null && JComponentHolder.class.isAssignableFrom(guiClass)) {
            Field[] f = guiClass.getDeclaredFields();
            for (int i = 0; i < f.length; ++i) {
                if (fields.containsKey(f[i].getName())) continue;
                fields.put(f[i].getName(), f[i]);
            }
            guiClass = guiClass.getSuperclass();
        }
        return fields.values().toArray(new Field[0]);
    }
}

