/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.sun.awt.AWTUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Frog;

class SplashScreen
extends Window {
    private ImageIcon icon;
    private Image background;
    private ImageIcon animation;
    private File customSplash;

    public SplashScreen() {
        super(new Frame());
        this.customSplash = new File(Config.getConfig().progDir, "res/splash.png");
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.background != null) {
            g.drawImage(this.background, 0, 0, null);
        }
        g.drawImage(this.icon.getImage(), 0, 0, this);
        if (!this.customSplash.exists()) {
            g.setFont(new Font("SansSerif", 1, 11));
            String versionText = AlbumBean.getInternalVersion();
            g.drawString(versionText, 182, 58);
            if (this.animation != null) {
                g.drawImage(this.animation.getImage(), (this.getWidth() - this.animation.getIconWidth()) / 2, 120, this);
            }
        }
    }

    private void init() throws Exception {
        block5: {
            this.setBackground(new Color(255, 255, 255, 0));
            if (this.customSplash.exists()) {
                this.icon = new ImageIcon(this.customSplash.getAbsolutePath());
            } else {
                this.icon = new ImageIcon(this.getClass().getResource("images/splash.png"));
                this.animation = new ImageIcon(this.getClass().getResource("images/splashprogress.gif"));
            }
            Dimension iconSize = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
            this.setSize(iconSize);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension screenSize = tk.getScreenSize();
            Dimension frameSize = this.getSize();
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            try {
                AWTUtilities.setWindowOpaque((Window)this, (boolean)false);
            }
            catch (Throwable t) {
                if ("Mac OS X".equals(System.getProperty("os.name"))) break block5;
                Robot rbt = new Robot();
                this.background = rbt.createScreenCapture(this.getBounds());
            }
        }
        if (!this.customSplash.exists()) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Frog dor = new Frog();
                    dor.ribbit();
                }
            });
        }
    }
}

