/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import se.datadosen.component.FileChooser;

public class DeferredChooser
implements FileChooser {
    private Class chooserClass;
    private JFileChooser chooser;
    private int fileSelectionMode = -1;
    private String title;
    private File selectedFile;
    private File currentDirectory;
    private FileFilter fileFilter;
    private LinkedList listenerList = new LinkedList();

    public DeferredChooser(Class chooserClass) {
        this.chooserClass = chooserClass;
    }

    public void addActionListener(ActionListener l) {
        if (this.chooser == null) {
            this.listenerList.add(l);
        } else {
            this.chooser.addActionListener(l);
        }
    }

    public void setDialogTitle(String title) {
        if (this.chooser == null) {
            this.title = title;
        } else {
            this.chooser.setDialogTitle(title);
        }
    }

    public void setSelectedFile(File file) {
        if (this.chooser == null) {
            this.selectedFile = file;
        } else {
            this.chooser.setSelectedFile(file);
        }
    }

    public File getSelectedFile() {
        if (this.chooser == null) {
            return this.selectedFile;
        }
        return this.chooser.getSelectedFile();
    }

    public void setFileSelectionMode(int mode) {
        if (this.chooser == null) {
            this.fileSelectionMode = mode;
        } else {
            this.chooser.setFileSelectionMode(mode);
        }
    }

    public void setFileFilter(FileFilter filter) {
        if (this.chooser == null) {
            this.fileFilter = filter;
        } else {
            this.chooser.setFileFilter(filter);
        }
    }

    public void setCurrentDirectory(File dir) {
        if (this.chooser == null) {
            this.currentDirectory = dir;
        } else {
            this.chooser.setCurrentDirectory(dir);
        }
    }

    public File getCurrentDirectory() {
        if (this.chooser == null) {
            return this.currentDirectory;
        }
        return this.chooser.getCurrentDirectory();
    }

    public int showOpenDialog(Component parent) {
        if (this.chooser == null) {
            this.instantiate();
        }
        return this.chooser.showOpenDialog(parent);
    }

    public int showSaveDialog(Component parent) {
        if (this.chooser == null) {
            this.instantiate();
        }
        return this.chooser.showSaveDialog(parent);
    }

    private void instantiate() {
        try {
            this.chooser = (JFileChooser)this.chooserClass.newInstance();
            Iterator it = this.listenerList.iterator();
            while (it.hasNext()) {
                this.chooser.addActionListener((ActionListener)it.next());
            }
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            if (this.fileSelectionMode != -1) {
                this.chooser.setFileSelectionMode(this.fileSelectionMode);
            }
            if (this.currentDirectory != null) {
                this.chooser.setCurrentDirectory(this.currentDirectory);
            }
            if (this.selectedFile != null) {
                this.chooser.setSelectedFile(this.selectedFile);
            }
            if (this.title != null) {
                this.chooser.setDialogTitle(this.title);
            }
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    public void setDialogType(int dialogType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setMultiSelectionEnabled(boolean b) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setFileView(FileView fileView) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public File[] getSelectedFiles() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

