/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.Unbound;

public class Config
implements Serializable {
    private static Config theConfig;
    public File progDir;
    public File skinsDir;
    public ChainedDirectory chainedSkinsDir;
    public File pluginsDir;
    public String language = "default";
    private File configDir;
    private String lookAndFeel;
    private String webHostListUrl = "http://jalbum.net/web-hosts.xml";
    private boolean cleanOutputFiles = true;
    private boolean synchronizeOutputDirectory = true;
    private boolean cacheThumbnails = true;
    private boolean updateProfilePage = true;
    private String afterPublishing = "openPublishingSuccessfulPage";
    private boolean showPreviewInfoBar = true;
    private boolean encryptManifest = false;
    private String manifestPassword;
    private boolean zipstreaming = true;
    private boolean debugMode;
    private String myAlbumsLocation;
    private boolean showTipOfTheDay = true;
    private int traceVersion = 3;
    private boolean includeHiResImagesDefault = true;
    private LabelType labelType = LabelType.caption;
    private FileAddBehavior fileAddBehavior = FileAddBehavior.COPY;

    private Config() {
        this.progDir = new File("").getAbsoluteFile();
        this.newProgDir();
        if (!this.skinsDir.exists() || !this.pluginsDir.exists()) {
            URL url;
            File classPath;
            String instDirName = System.getProperty("jalbum.installation.dir");
            this.progDir = instDirName != null ? new File(instDirName) : ((classPath = new File(System.getProperty("java.class.path"))).exists() ? classPath.getParentFile().getAbsoluteFile() : ((url = JAlbum.class.getResource("../../../")) != null ? new File(url.getFile()).getParentFile() : new File("")));
            this.newProgDir();
        }
        this.setLookAndFeel(System.getProperty("swing.defaultlaf") == null ? UIManager.getSystemLookAndFeelClassName() : System.getProperty("swing.defaultlaf"));
        this.updateChainedSkinsDir();
    }

    private void updateChainedSkinsDir() {
        this.chainedSkinsDir = new ChainedDirectory(this.skinsDir);
        File appdataDir = null;
        String appdata = System.getProperty("appdata");
        if (appdata == null) {
            try {
                appdata = System.getenv("APPDATA");
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (appdata != null) {
            appdataDir = new File(appdata);
        } else if (Platform.isWindows()) {
            File f = new File(System.getProperty("user.home"), "Application Data");
            if (f.exists()) {
                appdataDir = f;
            }
        } else if (Platform.isMac()) {
            appdataDir = new File(System.getProperty("user.home"), "Library");
        } else if (Platform.isLinux()) {
            this.configDir = new File(System.getProperty("user.home"), ".jalbum");
        }
        if (appdataDir != null) {
            this.configDir = new File(appdataDir, "JAlbum");
        }
        if (this.configDir != null) {
            File altSkinsDir = new File(this.configDir, "skins");
            this.chainedSkinsDir = new ChainedDirectory(altSkinsDir, this.chainedSkinsDir);
        }
    }

    public static Config getConfig() {
        if (theConfig == null) {
            theConfig = new Config();
        }
        return theConfig;
    }

    public void setProgramDirectory(File progDir) {
        this.progDir = progDir;
        this.newProgDir();
        this.updateChainedSkinsDir();
    }

    public void setProgramDirectory(String progDir) {
        this.setProgramDirectory(new File(progDir));
    }

    public void setSkinsDirectory(File skinsDir) {
        this.skinsDir = skinsDir;
        this.chainedSkinsDir = new ChainedDirectory(skinsDir);
    }

    public void setSkinsDirectory(String skinsDir) {
        this.setSkinsDirectory(new File(skinsDir));
    }

    public String getLanguage() {
        return this.language;
    }

    @Unbound
    public String getInterpretedLanguage() {
        return this.language.equals("default") ? System.getProperty("user.language") : this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        if (!language.equals("default")) {
            Locale.setDefault(new Locale(language, System.getProperty("user.country")));
        } else {
            Locale.setDefault(new Locale(System.getProperty("user.language"), System.getProperty("user.country")));
        }
        Msg.reloadBundle();
    }

    private void newProgDir() {
        this.skinsDir = new File(this.progDir, "skins");
        this.pluginsDir = new File(this.progDir, "plugins");
    }

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public String getWebHostListUrl() {
        return this.webHostListUrl;
    }

    public void setWebHostListUrl(String webHostListUrl) {
        this.webHostListUrl = webHostListUrl;
    }

    public boolean isCleanOutputFiles() {
        return this.cleanOutputFiles;
    }

    public void setCleanOutputFiles(boolean clean) {
        this.cleanOutputFiles = clean;
    }

    public boolean isSynchronizeOutputDirectory() {
        return this.synchronizeOutputDirectory;
    }

    public void setSynchronizeOutputDirectory(boolean synchronizeOutputDirectory) {
        this.synchronizeOutputDirectory = synchronizeOutputDirectory;
    }

    public boolean isCacheThumbnails() {
        return this.cacheThumbnails;
    }

    public void setCacheThumbnails(boolean cacheThumbnails) {
        this.cacheThumbnails = cacheThumbnails;
    }

    public boolean isUpdateProfilePage() {
        return this.updateProfilePage;
    }

    public void setUpdateProfilePage(boolean updateProfilePage) {
        this.updateProfilePage = updateProfilePage;
    }

    public String getAfterPublishing() {
        return this.afterPublishing;
    }

    public void setAfterPublishing(String afterPublishing) {
        this.afterPublishing = afterPublishing;
    }

    public boolean isShowPreviewInfoBar() {
        return this.showPreviewInfoBar;
    }

    public void setShowPreviewInfoBar(boolean showPreviewInfoBar) {
        this.showPreviewInfoBar = showPreviewInfoBar;
    }

    public boolean isEncryptManifest() {
        return this.encryptManifest;
    }

    public void setEncryptManifest(boolean encryptManifest) {
        this.encryptManifest = encryptManifest;
    }

    public String getManifestPassword() {
        return this.manifestPassword;
    }

    public void setManifestPassword(String manifestPassword) {
        this.manifestPassword = manifestPassword;
    }

    public boolean isZipstreaming() {
        return this.zipstreaming;
    }

    public void setZipstreaming(boolean zipstreaming) {
        this.zipstreaming = zipstreaming;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        JAlbum.logger.setLevel(debugMode ? Level.FINE : Level.WARNING);
    }

    public String getMyAlbumsLocation() {
        if (this.myAlbumsLocation == null || this.myAlbumsLocation.length() == 0) {
            File userHome = FileSystemView.getFileSystemView().getDefaultDirectory();
            File myAlbums = new File(userHome, Msg.get("newproject.myAlbumsDirectory"));
            this.setMyAlbumsLocation(myAlbums.getAbsolutePath());
        }
        return this.myAlbumsLocation;
    }

    public void setMyAlbumsLocation(String myAlbumsLocation) {
        this.myAlbumsLocation = myAlbumsLocation;
    }

    public boolean isShowTipOfTheDay() {
        return this.showTipOfTheDay;
    }

    public void setShowTipOfTheDay(boolean showTipOfTheDay) {
        this.showTipOfTheDay = showTipOfTheDay;
    }

    public LabelType getLabelType() {
        return this.labelType;
    }

    public void setLabelType(LabelType labelType) {
        this.labelType = labelType;
    }

    public FileAddBehavior getFileAddBehavior() {
        return this.fileAddBehavior;
    }

    public void setFileAddBehavior(FileAddBehavior fileAddBehavior) {
        this.fileAddBehavior = fileAddBehavior;
    }

    public boolean isIncludeHiResImagesDefault() {
        return this.includeHiResImagesDefault;
    }

    public void setIncludeHiResImagesDefault(boolean includeHiResImagesDefault) {
        this.includeHiResImagesDefault = includeHiResImagesDefault;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileAddBehavior {
        COPY("ui.copy", 1, 0x40000000),
        LINK("ui.link", 0x40000000, 1);

        private int dndAction;
        private int altDndAction;
        private String nameKey;

        private FileAddBehavior(String nameKey, int dndAction, int altDndAction) {
            this.nameKey = nameKey;
            this.dndAction = dndAction;
            this.altDndAction = altDndAction;
        }

        public String toString() {
            return Msg.get(this.nameKey);
        }

        public int getAction() {
            return this.dndAction;
        }

        public int getAltAction() {
            return this.altDndAction;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LabelType {
        fileName,
        caption;

    }
}

