/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.MapBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlbumObjectProperties {
    public static final String TITLE = "title";
    public static final String RATING = "rating";
    public static final String FILTER_LIST = "filterList";
    public static final String INCLUDE_ORIGINAL = "includeOriginal";
    public static final String IMAGE_SETTINGS_HASH = "imageSettingsHash";
    public static final String IMAGE_LINKING = "imageLinking";
    public static final String FILE_EXTENSION = ".info";
    private File file;
    private AlbumObject ao;
    private Map<String, Object> props = new HashMap<String, Object>();
    private String lastSkin;

    public AlbumObjectProperties(AlbumObject ao) {
        this.ao = ao;
        this.init();
    }

    public AlbumObjectProperties(File f) {
        this.file = f;
        this.init();
    }

    private void ensureClean() {
        String currentSkin = JAlbumContext.getInstance().getEngine().getSkin();
        if (!currentSkin.equals(this.lastSkin)) {
            this.load();
            this.lastSkin = currentSkin;
        }
    }

    private void init() {
        if (!this.load() && this.getAOFile().isDirectory()) {
            try {
                Map fp = AlbumBean.getFolderProperties(this.getAOFile());
                Object title = fp.get(TITLE);
                if (title != null) {
                    this.props.put(TITLE, title);
                    this.save();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Object get(String key) {
        this.ensureClean();
        Object property = this.props.get(key);
        if (property != null && property instanceof HiddenProperty) {
            property = ((HiddenProperty)property).getProperty();
        }
        return property;
    }

    public Object put(String key, Object value) {
        if (value instanceof String && value.toString().length() == 0) {
            return this.props.remove(key);
        }
        return this.props.put(key, value);
    }

    public Object putHidden(String key, Object value) {
        return this.put(key, new HiddenProperty(value));
    }

    public Object remove(String key) {
        return this.props.remove(key);
    }

    public boolean containsKey(String key) {
        this.ensureClean();
        return this.props.containsKey(key);
    }

    public Set<String> keySet() {
        this.ensureClean();
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, Object> e : this.props.entrySet()) {
            if (e.getValue() instanceof HiddenProperty) continue;
            keys.add(e.getKey());
        }
        return keys;
    }

    public boolean save() {
        File f = this.getFile();
        f.getParentFile().mkdir();
        if (!this.props.isEmpty()) {
            try {
                XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(f)));
                e.setExceptionListener(new ExceptionListener(){

                    public void exceptionThrown(Exception e) {
                    }
                });
                e.writeObject(this.props);
                e.close();
                ((AlbumObjectImpl)this.ao).firePropertyChange("properties", null, null);
                return true;
            }
            catch (FileNotFoundException ex) {
                return false;
            }
        }
        f.delete();
        this.getAOFile().setLastModified(new Date().getTime());
        return false;
    }

    private boolean load() {
        File f = this.getFile();
        if (f.exists()) {
            try {
                XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(f)));
                d.setExceptionListener(new ExceptionListener(){

                    public void exceptionThrown(Exception e) {
                    }
                });
                this.props = (Map)d.readObject();
                d.close();
                JAlbumContext.getInstance().getEngine().setDataTypes(this.props, "SlideModel");
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        JAlbumContext.getInstance().getEngine().setDataTypes(this.props, "SlideModel");
        return false;
    }

    public File getFile() {
        return AlbumObjectProperties.getPropertyFile(this.getAOFile());
    }

    private File getAOFile() {
        if (this.ao != null) {
            return this.ao.getFile();
        }
        return this.file;
    }

    public static File getPropertyFile(File f) {
        if (f.isDirectory()) {
            File dir = new File(f, ".jalbum");
            return new File(dir, FILE_EXTENSION);
        }
        return new File(AlbumObjectImpl.getJAlbumFolder(f), f.getName() + FILE_EXTENSION);
    }

    public void loadUI(JComponentHolder ui) {
        this.ensureClean();
        MapBinder.syncUI(this.props, ui);
    }

    public void saveUI(JComponentHolder ui) {
        HashMap<String, Object> oldProps = new HashMap<String, Object>();
        oldProps.putAll(this.props);
        Map<String, Object> newProps = MapBinder.getMap(ui);
        for (Map.Entry<String, Object> e : newProps.entrySet()) {
            Object val = e.getValue();
            if (val == null || "".equals(e.toString())) continue;
            this.props.put(e.getKey(), val);
        }
        if (!((Object)this.props).equals(oldProps)) {
            this.save();
        }
    }

    public static class HiddenProperty {
        private Object property;

        public HiddenProperty() {
        }

        public HiddenProperty(Object property) {
            this.property = property;
        }

        public Object getProperty() {
            return this.property;
        }

        public void setProperty(Object property) {
            this.property = property;
        }
    }
}

