/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.text.View;

public class WrappableJLabel
extends JLabel {
    private int preferredWidth = -1;
    private String text;

    public WrappableJLabel() {
    }

    public WrappableJLabel(Icon image) {
        super(image);
    }

    public WrappableJLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public WrappableJLabel(String text) {
        super(text);
    }

    public WrappableJLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public WrappableJLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public void setText(String text) {
        this.text = text;
        if (text.length() < 10) {
            super.setText(text + " ");
        } else {
            super.setText("<html>" + text + "</html>");
        }
    }

    public String getPlainText() {
        return this.text;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.preferredWidth == -1) {
            return dim;
        }
        if (dim.width <= this.preferredWidth) {
            return dim;
        }
        dim = WrappableJLabel.getPreferredSize(this, true, this.preferredWidth);
        return dim != null ? dim : super.getPreferredSize();
    }

    private static Dimension getPreferredSize(JLabel label, boolean width, int prefSize) {
        JLabel dummy = label;
        View view = (View)dummy.getClientProperty("html");
        if (view != null) {
            view.setSize(width ? (float)prefSize : 0.0f, width ? 0.0f : (float)prefSize);
            float w = view.getPreferredSpan(0);
            float h = view.getPreferredSpan(1);
            return new Dimension((int)Math.ceil(w), (int)Math.ceil(h));
        }
        return null;
    }
}

