/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import se.datadosen.component.DirectoryChooser;

public class MacDirectoryChooser
implements DirectoryChooser {
    private FileDialog dialog;

    public MacDirectoryChooser(Frame parent) {
        this.dialog = new FileDialog(parent);
    }

    public MacDirectoryChooser(Dialog parent) {
        this.dialog = new FileDialog(parent);
    }

    public void setCurrentDirectory(File dir) {
        this.dialog.setDirectory(dir.getAbsolutePath());
    }

    public File getCurrentDirectory() {
        return new File(this.dialog.getDirectory());
    }

    public void setSelectedFile(File file) {
        this.setCurrentDirectory(file.getParentFile());
        this.dialog.setFile(file.getName());
    }

    public File getSelectedFile() {
        if (this.dialog.getFile() == null) {
            return null;
        }
        return new File(this.dialog.getDirectory(), this.dialog.getFile());
    }

    public void setDialogTitle(String title) {
        this.dialog.setTitle(title);
    }

    public int showChooser() {
        File selected = this.getSelectedFile();
        if (selected != null) {
            this.setCurrentDirectory(selected);
        }
        String def = System.getProperty("apple.awt.fileDialogForDirectories", "false");
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        this.dialog.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", def);
        return this.dialog.getFile() != null ? 0 : 1;
    }
}

