/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.datadosen.util.Colors;

public class JColorSelector
extends JPanel {
    protected String title;
    protected Color color = Color.black;
    private TexturePaint disabledColor;
    protected JTextField textComponent;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (JColorSelector.this.textComponent != null) {
                if (evt.getPropertyName().equals("color")) {
                    JColorSelector.this.textComponent.setText(JColorSelector.this.getHTMLColor());
                } else if (evt.getPropertyName().equals("enabled")) {
                    JColorSelector.this.textComponent.setEnabled(JColorSelector.this.isEnabled());
                }
            }
        }
    };
    private DocumentListener documentListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent e) {
            JColorSelector.this.textComponentChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            JColorSelector.this.textComponentChanged();
        }

        public void changedUpdate(DocumentEvent e) {
            JColorSelector.this.textComponentChanged();
        }
    };
    Vector listeners;
    private final int Y_OFFSET = 1;

    public JColorSelector() {
        this("");
    }

    public JColorSelector(String title) {
        this.title = title;
        this.addPropertyChangeListener(this.propertyChangeListener);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void textComponentChanged() {
        this.removePropertyChangeListener(this.propertyChangeListener);
        this.setColor(this.textComponent.getText());
        this.addPropertyChangeListener(this.propertyChangeListener);
    }

    public JColorSelector(JTextField comp) {
        this("");
        this.setTextComponent(comp);
    }

    public JColorSelector(String title, JTextField comp) {
        this(title);
        this.setTextComponent(comp);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public JTextField getTextComponent() {
        return this.textComponent;
    }

    public void setTextComponent(JTextField textComponent) {
        if (textComponent != null) {
            textComponent.getDocument().removeDocumentListener(this.documentListener);
        }
        this.textComponent = textComponent;
        textComponent.getDocument().addDocumentListener(this.documentListener);
        textComponent.setText(this.getHTMLColor());
    }

    public String getHTMLColor() {
        return Colors.toHTMLColor(this.color);
    }

    public String toString() {
        return this.getHTMLColor();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(String htmlColor) {
        try {
            this.setColor(Colors.getHTMLColor(htmlColor));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.disabledColor = this.createDisabledColor(color);
        this.repaint();
        this.firePropertyChange("color", oldColor, this.getHTMLColor());
    }

    private TexturePaint createDisabledColor(Color c) {
        int s = 20;
        BufferedImage im = new BufferedImage(s, s, 2);
        Graphics2D g = im.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(c);
        g.setStroke(new BasicStroke(2.0f));
        for (int i = -s; i <= s; i += 6) {
            g.drawLine(0 + i, 0, s + i, s);
        }
        g.dispose();
        return new TexturePaint(im, new Rectangle(0, 0, s, s));
    }

    private void init() throws Exception {
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(20, 15 + this.Y_OFFSET));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (!JColorSelector.this.isEnabled()) {
                    return;
                }
                Color newColor = JColorChooser.showDialog(SwingUtilities.getWindowAncestor(JColorSelector.this), JColorSelector.this.title, JColorSelector.this.color);
                if (newColor != null) {
                    JColorSelector.this.setColor(newColor);
                    JColorSelector.this.fireActionOccured(new ActionEvent(JColorSelector.this, 0, JColorSelector.this.getHTMLColor()));
                }
            }
        });
        this.setColor(this.color);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(l);
            this.listeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.listeners = v;
        }
    }

    protected void fireActionOccured(ActionEvent e) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)this.listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    protected void paintComponent(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isEnabled() || this.disabledColor == null) {
            g.setColor(this.color.brighter());
            g.fillRoundRect(0, this.Y_OFFSET, w - 1, h - this.Y_OFFSET - 1, 5, 5);
            g.setColor(this.color);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g.setPaint(this.disabledColor);
        }
        g.fillRoundRect(1, this.Y_OFFSET + 1, w - 2, h - this.Y_OFFSET - 2, 0, 0);
        g.setColor(this.color.darker());
        g.drawRoundRect(0, this.Y_OFFSET, w - 1, h - this.Y_OFFSET - 1, 5, 5);
    }
}

