/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.Entry;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.IFD;
import photoorganizer.formats.Rational;
import photoorganizer.formats.StrippedJpeg;

public class Exif
extends AbstractImageInfo {
    public static final String FORMAT = "Exif";
    public static final byte[] EXIF_MARK = new byte[]{69, 120, 105, 102, 0, 0};
    static final int FIRST_IFD_OFF = 6;
    static final int MIN_JPEG_SIZE = 100;
    public static final int NEWSUBFILETYPE = 254;
    public static final int IMAGEWIDTH = 256;
    public static final int IMAGELENGTH = 257;
    public static final int BITSPERSAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRICINTERPRETATION = 262;
    public static final int FILLORDER = 266;
    public static final int DOCUMENTNAME = 269;
    public static final int IMAGEDESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIPOFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLESPERPIXEL = 277;
    public static final int ROWSPERSTRIP = 278;
    public static final int STRIPBYTECOUNTS = 279;
    public static final int XRESOLUTION = 282;
    public static final int YRESOLUTION = 283;
    public static final int PLANARCONFIGURATION = 284;
    public static final int RESOLUTIONUNIT = 296;
    public static final int TRANSFERFUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATETIME = 306;
    public static final int ARTIST = 315;
    public static final int WHITEPOINT = 318;
    public static final int PRIMARYCHROMATICITIES = 319;
    public static final int SUBIFDS = 330;
    public static final int JPEGTABLES = 347;
    public static final int TRANSFERRANGE = 342;
    public static final int JPEGPROC = 512;
    public static final int JPEGINTERCHANGEFORMAT = 513;
    public static final int JPEGINTERCHANGEFORMATLENGTH = 514;
    public static final int YCBCRCOEFFICIENTS = 529;
    public static final int YCBCRSUBSAMPLING = 530;
    public static final int YCBCRPOSITIONING = 531;
    public static final int REFERENCEBLACKWHITE = 532;
    public static final int CFAREPEATPATTERNDIM = 33421;
    public static final int CFAPATTERN = 33422;
    public static final int BATTERYLEVEL = 33423;
    public static final int COPYRIGHT = 33432;
    public static final int EXPOSURETIME = 33434;
    public static final int FNUMBER = 33437;
    public static final int IPTC_NAA = 33723;
    public static final int EXIFOFFSET = 34665;
    public static final int INTERCOLORPROFILE = 34675;
    public static final int EXPOSUREPROGRAM = 34850;
    public static final int SPECTRALSENSITIVITY = 34852;
    public static final int GPSINFO = 34853;
    public static final int ISOSPEEDRATINGS = 34855;
    public static final int OECF = 34856;
    public static final int EXIFVERSION = 36864;
    public static final int DATETIMEORIGINAL = 36867;
    public static final int DATETIMEDIGITIZED = 36868;
    public static final int COMPONENTSCONFIGURATION = 37121;
    public static final int COMPRESSEDBITSPERPIXEL = 37122;
    public static final int SHUTTERSPEEDVALUE = 37377;
    public static final int APERTUREVALUE = 37378;
    public static final int BRIGHTNESSVALUE = 37379;
    public static final int EXPOSUREBIASVALUE = 37380;
    public static final int MAXAPERTUREVALUE = 37381;
    public static final int SUBJECTDISTANCE = 37382;
    public static final int METERINGMODE = 37383;
    public static final int LIGHTSOURCE = 37384;
    public static final int FLASH = 37385;
    public static final int FOCALLENGTH = 37386;
    public static final int MAKERNOTE = 37500;
    public static final int USERCOMMENT = 37510;
    public static final int SUBSECTIME = 37520;
    public static final int SUBSECTIMEORIGINAL = 37521;
    public static final int SUBSECTIMEDIGITIZED = 37522;
    public static final int FLASHPIXVERSION = 40960;
    public static final int COLORSPACE = 40961;
    public static final int EXIFIMAGEWIDTH = 40962;
    public static final int EXIFIMAGELENGTH = 40963;
    public static final int INTEROPERABILITYOFFSET = 40965;
    public static final int FLASHENERGY = 41483;
    public static final int SPATIALFREQUENCYRESPONSE = 41484;
    public static final int FOCALPLANEXRESOLUTION = 41486;
    public static final int FOCALPLANEYRESOLUTION = 41487;
    public static final int FOCALPLANERESOLUTIONUNIT = 41488;
    public static final int SUBJECTLOCATION = 41492;
    public static final int EXPOSUREINDEX = 41493;
    public static final int SENSINGMETHOD = 41495;
    public static final int FILESOURCE = 41728;
    public static final int SCENETYPE = 41729;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String EXT_BMP = "bmp";
    public static final String EXT_JPEG = "Jpeg";
    public static final String[] EXPOSURE_PROGRAMS = new String[]{"P0", "P1", "Normal", "P3", "P5"};
    public static final String[] METERING_MODES = new String[]{"P0", "P1", "Normal", "P3", "PATTERN"};
    static final int DIR_ENTRY_SIZE = 12;
    public static final int[] TYPELENGTH = new int[]{1, 1, 2, 4, 8, 1, 1, 2, 4, 8};
    protected int currentimage;
    protected int version;
    protected IFD[] ifds;

    public Exif(InputStream is, byte[] data, int offset, String name, String comments) throws FileFormatException {
        super(is, data, offset, name, comments);
    }

    public Exif() {
        this.ifds = new IFD[2];
        this.intel = true;
        this.version = 2;
    }

    public String getFormat() {
        return FORMAT;
    }

    public static byte[] getMarkerData() {
        return new byte[]{-1, -31, 0, 40, 69, 120, 105, 102, 0, 0, 73, 73, 42, 0, 8, 0, 0, 0, 1, 0, 15, 1, 2, 0, 5, 0, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 70, 65, 75, 69, 0, 0};
    }

    public Entry getTagValue(int tag, boolean main) {
        return this.getTagValue(new Integer(tag), -1, main);
    }

    public Entry getTagValue(Integer tag, int subTag, boolean main) {
        return this.ifds[main ? 0 : 1] != null ? this.ifds[main ? 0 : 1].getEntry(tag, subTag) : null;
    }

    public void setTagValue(int tag, int subTag, Entry value, boolean main) {
        this.ifds[main ? 0 : 1].setEntry(new Integer(tag), subTag, value);
    }

    int getThumbnailLength() {
        Entry e = this.getTagValue(514, false);
        if (e == null) {
            return -1;
        }
        return (Integer)e.getValue(0);
    }

    int getThumbnailOffset() {
        Entry e = this.getTagValue(513, false);
        if (e == null) {
            return -1;
        }
        return (Integer)e.getValue(0);
    }

    public boolean saveThumbnailImage(StrippedJpeg im, OutputStream os) throws IOException {
        if (os == null || im == null) {
            return false;
        }
        boolean success = false;
        int offset = this.getThumbnailOffset();
        if (offset > 0) {
            int length = this.getThumbnailLength();
            if (length > 100) {
                int jpeg_offset;
                InputStream is = im.createInputStream();
                byte[] image = new byte[length];
                Exif.skip(is, this.offset + offset + 6);
                Exif.read(is, image);
                is.close();
                for (jpeg_offset = 0; (image[jpeg_offset] != -1 || image[jpeg_offset + 1] != -40) && jpeg_offset < image.length - 1; ++jpeg_offset) {
                }
                if (image.length - jpeg_offset > 100) {
                    os.write(image, jpeg_offset, image.length - jpeg_offset);
                    success = true;
                }
            }
        } else {
            Entry e = this.getTagValue(273, false);
            if (e != null) {
                InputStream is = im.createInputStream();
                offset = (Integer)e.getValue(0);
                if (offset > 0) {
                    Exif.skip(is, offset);
                    e = this.getTagValue(279, false);
                    if (e != null) {
                        int length = (Integer)e.getValue(0);
                        int imgwidth = 0;
                        int imglength = 0;
                        e = this.getTagValue(256, false);
                        if (e != null) {
                            imgwidth = (Integer)e.getValue(0);
                        }
                        if ((e = this.getTagValue(257, false)) != null) {
                            imglength = (Integer)e.getValue(0);
                        }
                        int bitspix = 8;
                        e = this.getTagValue(258, false);
                        if (e != null) {
                            bitspix = (Integer)e.getValue(0);
                        }
                        int simpleperpix = 3;
                        e = this.getTagValue(277, false);
                        if (e != null) {
                            simpleperpix = (Integer)e.getValue(0);
                        }
                        this.data = new byte[54];
                        System.arraycopy(BMP_SIG, 0, this.data, 0, BMP_SIG.length);
                        offset = 2;
                        int scanline_len = imgwidth * simpleperpix + 3 & 0xFFFFFFFC;
                        offset = this.i2bsI(offset, 54 + scanline_len * imglength, 4);
                        offset = this.i2bsI(offset, 0, 4);
                        offset = this.i2bsI(offset, 54, 4);
                        offset = this.i2bsI(offset, 40, 4);
                        offset = this.i2bsI(offset, imgwidth, 4);
                        offset = this.i2bsI(offset, imglength, 4);
                        offset = this.i2bsI(offset, 1, 2);
                        offset = this.i2bsI(offset, simpleperpix * bitspix, 2);
                        offset = this.i2bsI(offset, 0, 4);
                        offset = this.i2bsI(offset, scanline_len * imglength, 4);
                        offset = this.i2bsI(offset, 2834, 4);
                        offset = this.i2bsI(offset, 2834, 4);
                        offset = this.i2bsI(offset, 0, 4);
                        offset = this.i2bsI(offset, 0, 4);
                        os.write(this.data);
                        this.data = new byte[length];
                        Exif.read(is, this.data);
                        int filler = scanline_len - imgwidth * simpleperpix;
                        scanline_len = imgwidth * simpleperpix;
                        byte[] filldata = null;
                        if (filler != 0) {
                            filldata = new byte[filler];
                        }
                        for (offset = length - scanline_len; offset >= 0; offset -= scanline_len) {
                            for (int ro = 0; ro < scanline_len; ro += 3) {
                                os.write(this.data[offset + ro + 2]);
                                os.write(this.data[offset + ro + 1]);
                                os.write(this.data[offset + ro]);
                            }
                            if (filler == 0) continue;
                            os.write(filldata);
                        }
                    }
                }
                success = true;
            }
        }
        if (!success) {
            return super.saveThumbnailImage(im, os);
        }
        return true;
    }

    public String getThumbnailExtension() {
        return this.getThumbnailOffset() > 0 ? EXT_JPEG : EXT_BMP;
    }

    public Icon getThumbnailIcon(StrippedJpeg im, Dimension size) {
        int offset = this.getThumbnailOffset();
        if (offset > 0) {
            int length = this.getThumbnailLength();
            if (length > 100) {
                int jpeg_offset;
                try {
                    InputStream is = im.createInputStream();
                    byte[] image = new byte[length];
                    Exif.skip(is, this.offset + offset + 6);
                    is.read(image);
                    is.close();
                    for (jpeg_offset = 0; (image[jpeg_offset] != -1 || image[jpeg_offset + 1] != -40) && jpeg_offset < image.length - 1; ++jpeg_offset) {
                    }
                    if (jpeg_offset < image.length - 100) {
                        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(image, jpeg_offset, image.length - jpeg_offset));
                    }
                }
                catch (IOException e) {
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("Bad index " + jpeg_offset + " for " + this.getName());
                }
            }
        } else {
            Entry e = this.getTagValue(273, false);
            if (e != null) {
                InputStream is = im.createInputStream();
                offset = (Integer)e.getValue(0);
                if (offset > 0) {
                    try {
                        Exif.skip(is, offset);
                        e = this.getTagValue(279, false);
                        if (e != null) {
                            int length = (Integer)e.getValue(0);
                            this.data = new byte[length];
                            Exif.read(is, this.data);
                            int imgwidth = 0;
                            int imglength = 0;
                            e = this.getTagValue(256, false);
                            if (e != null) {
                                imgwidth = (Integer)e.getValue(0);
                            }
                            if ((e = this.getTagValue(257, false)) != null) {
                                imglength = (Integer)e.getValue(0);
                            }
                            int bitspix = 8;
                            e = this.getTagValue(258, false);
                            if (e != null) {
                                bitspix = (Integer)e.getValue(0);
                            }
                            int simpleperpix = 3;
                            e = this.getTagValue(277, false);
                            if (e != null) {
                                simpleperpix = (Integer)e.getValue(0);
                            }
                            int[] image = new int[imgwidth * imglength];
                            for (int i = 0; i < image.length; ++i) {
                                image[i] = ((this.data[i * 3] & 0xFF) << 16) + ((this.data[i * 3 + 1] & 0xFF) << 8) + (this.data[i * 3 + 2] & 0xFF) + -16777216;
                            }
                            MemoryImageSource mis = new MemoryImageSource(imgwidth, imglength, image, 0, imgwidth);
                            Image img = Toolkit.getDefaultToolkit().createImage(mis);
                            image = null;
                            is.close();
                            return new ImageIcon(img);
                        }
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                }
            }
        }
        System.err.println("Embedded thumbnail not found for " + im.getFile());
        return null;
    }

    public int getResolutionX() {
        Entry e = this.getTagValue(40962, true);
        if (e != null) {
            return (Integer)e.getValue(0);
        }
        return -1;
    }

    public void setResolutionX(int xRes) {
        Entry e = this.getTagValue(40962, true);
        if (e == null) {
            e = new Entry(4);
            this.setTagValue(40962, 0, e, true);
        }
        e.setValue(0, new Integer(xRes));
    }

    public int getResolutionY() {
        Entry e = this.getTagValue(40963, true);
        if (e != null) {
            return (Integer)e.getValue(0);
        }
        return -1;
    }

    public void setResolutionY(int yRes) {
        Entry e = this.getTagValue(40963, true);
        if (e == null) {
            e = new Entry(4);
            this.setTagValue(40963, 0, e, true);
        }
        e.setValue(0, new Integer(yRes));
    }

    public int getMetering() {
        Entry e = this.getTagValue(37383, true);
        if (e != null) {
            return (Integer)e.getValue(0);
        }
        return 0;
    }

    public String getMeteringAsString() {
        int m = this.getMetering();
        if (m >= 0 && m < METERING_MODES.length) {
            return METERING_MODES[m];
        }
        return "" + m;
    }

    public int getExpoProgram() {
        Entry e = this.getTagValue(34850, true);
        if (e != null) {
            return (Integer)e.getValue(0);
        }
        return 0;
    }

    public String getExpoProgramAsString() {
        int ep = this.getExpoProgram();
        if (ep >= 0 && ep < EXPOSURE_PROGRAMS.length) {
            return EXPOSURE_PROGRAMS[ep];
        }
        return "" + ep;
    }

    public String getMake() {
        Entry e = this.getTagValue(271, true);
        if (e != null) {
            return e.toString();
        }
        return "n/a";
    }

    public String getModel() {
        Entry e = this.getTagValue(272, true);
        if (e != null) {
            return e.toString();
        }
        return "n/a";
    }

    public String getDataTimeOriginalString() {
        String result;
        Entry e = this.getTagValue(36867, true);
        if (e != null && (result = e.toString()).indexOf("0000:00:00") < 0) {
            return result;
        }
        return dateformat.format(new Date());
    }

    public float getFNumber() {
        Entry e = this.getTagValue(33437, true);
        if (e != null) {
            return ((Rational)e.getValue(0)).floatValue();
        }
        e = this.getTagValue(37378, true);
        if (e != null) {
            return this.apertureToFnumber(((Rational)e.getValue(0)).floatValue());
        }
        return -1.0f;
    }

    public Rational getShutter() {
        Entry e = this.getTagValue(33434, true);
        if (e != null) {
            return (Rational)e.getValue(0);
        }
        e = this.getTagValue(37377, true);
        try {
            return TV_TO_SEC[(int)((Rational)e.getValue(0)).floatValue()];
        }
        catch (NullPointerException x) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new Rational(0, 1);
    }

    public boolean isFlash() {
        Entry e = this.getTagValue(37385, true);
        if (e != null) {
            return (Integer)e.getValue(0) == 1;
        }
        return false;
    }

    public float getFocalLength() {
        Entry e = this.getTagValue(37386, true);
        if (e != null) {
            return Math.round((float)((double)(38.0f * ((Rational)e.getValue(0)).floatValue()) / 5.8));
        }
        return 0.0f;
    }

    public String getQuality() {
        Entry e = this.getTagValue(37122, true);
        if (e == null) {
            return "Unknown";
        }
        switch (((Rational)e.getValue(0)).intValue()) {
            case 1: {
                return "BASIC";
            }
            case 2: {
                return "NORMAL";
            }
            case 4: {
                return "FINE";
            }
        }
        return this.getTagValue(37122, true).toString();
    }

    public String getReport() {
        StringBuffer report = new StringBuffer();
        Entry e = this.getTagValue(33434, true);
        report.append("Shutter: ");
        if (e != null) {
            report.append(e.toString());
        } else {
            e = this.getTagValue(37377, true);
            if (e != null) {
                report.append(e.toString());
            } else {
                report.append("n/a");
            }
        }
        report.append(", Aperture: ");
        e = this.getTagValue(33437, true);
        if (e == null) {
            e = this.getTagValue(37378, true);
            if (e != null) {
                report.append(fnumberformat.format((double)((Rational)e.getValue(0)).floatValue() * 0.4 + 1.0));
            } else {
                report.append("n/a");
            }
        } else {
            report.append(fnumberformat.format(((Rational)e.getValue(0)).floatValue()));
        }
        report.append(", Flash: ");
        e = this.getTagValue(37385, true);
        if (e != null) {
            report.append((Integer)e.getValue(0) == 1 ? YES : NO);
        } else {
            report.append("n/a");
        }
        return report.toString();
    }

    public void readInfo() {
        this.ifds = new IFD[2];
        this.offset -= this.data.length;
        this.intel = this.data[6] == 73;
        boolean bl = this.motorola = this.data[6] == 77;
        if (!this.intel && !this.motorola) {
            return;
        }
        this.version = this.s2n(8, 2);
        this.processAllIFDs();
        this.data = null;
    }

    public void writeInfo(StrippedJpeg im, OutputStream out, int op) throws IOException {
        this.writeInfo(im, out, op, "ISO8859_1");
    }

    public void writeInfo(StrippedJpeg im, OutputStream out, int op, String encoding) throws IOException {
        if (this.ifds == null) {
            throw new IllegalStateException("EXIF data not filled.");
        }
        switch (op) {
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                Entry resY = this.getTagValue(40963, true);
                if (resY != null) {
                    Object yVal = resY.getValue(0);
                    Entry resX = this.getTagValue(40962, true);
                    if (resX != null) {
                        resY.setValue(0, resX.getValue(0));
                        resX.setValue(0, yVal);
                    }
                }
                for (int i = 0; i < 2; ++i) {
                    Entry eRes = this.getTagValue(282, i == 0);
                    this.setTagValue(282, 0, this.getTagValue(283, i == 0), i == 0);
                    this.setTagValue(283, 0, eRes, i == 0);
                }
                break;
            }
        }
        out.write(EXIF_MARK);
        if (this.intel) {
            out.write(73);
            out.write(73);
        } else {
            out.write(77);
            out.write(77);
        }
        out.write(this.n2s(this.version, 2));
        int emptySlot = EXIF_MARK.length + 2;
        out.write(this.n2s(emptySlot, 4));
        for (int k = 0; k < 2; ++k) {
            emptySlot = this.writeIfd(out, emptySlot, this.ifds[k], im, op, encoding);
        }
    }

    protected int writeIfd(OutputStream out, int emptySlot, IFD ifd, StrippedJpeg im, int op, String encoding) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(1024);
        int ne = (ifd.getEntries() == null ? 0 : ifd.getEntries().size()) + (ifd.getIFDs() == null ? 0 : ifd.getIFDs().length);
        out.write(this.n2s(ne, 2));
        emptySlot += ne * 12 + 2 + 4;
        for (Map.Entry me : ifd.getEntries().entrySet()) {
            int i;
            int tag = (Integer)me.getKey();
            if (tag == 514) continue;
            Entry e = (Entry)me.getValue();
            out.write(this.n2s(tag, 2));
            int type = e.getType();
            out.write(this.n2s(type, 2));
            if (type == 2) {
                byte[] str = e.toString().getBytes(encoding);
                out.write(this.n2s(str.length + 1, 4));
                if (str.length + 1 > 4) {
                    out.write(this.n2s(emptySlot, 4));
                    buf.write(str);
                    buf.write(0);
                    emptySlot += str.length + 1;
                    continue;
                }
                out.write(str);
                if (str.length >= 4) continue;
                for (int i2 = 0; i2 < 4 - str.length; ++i2) {
                    out.write(0);
                }
                continue;
            }
            Object[] vs = e.getValues();
            out.write(this.n2s(vs.length, 4));
            int tlen = TYPELENGTH[type - 1];
            if (vs.length * tlen > 4) {
                out.write(this.n2s(emptySlot, 4));
                boolean signed = true;
                boolean rational = type % 5 == 0;
                for (int i3 = 0; i3 < vs.length; ++i3) {
                    if (rational) {
                        buf.write(this.n2s(((Rational)vs[i3]).getNum(), 4));
                        buf.write(this.n2s(((Rational)vs[i3]).getDen(), 4));
                        emptySlot += 8;
                        continue;
                    }
                    buf.write(this.n2s((Integer)vs[i3], tlen));
                    emptySlot += tlen;
                }
                continue;
            }
            if (tag == 513) {
                int length = this.getThumbnailLength();
                if (length <= 100) continue;
                try {
                    int jpeg_offset;
                    InputStream is = im.createInputStream();
                    byte[] image = new byte[length];
                    Exif.skip(is, this.offset + this.getThumbnailOffset() + 6);
                    is.read(image);
                    is.close();
                    for (jpeg_offset = 0; (image[jpeg_offset] != -1 || image[jpeg_offset + 1] != -40) && jpeg_offset < image.length - 1; ++jpeg_offset) {
                    }
                    if (jpeg_offset >= image.length - 100) continue;
                    ByteArrayInputStream tis = new ByteArrayInputStream(image, jpeg_offset, image.length - jpeg_offset);
                    int l = buf.size();
                    new StrippedJpeg(tis).transform(buf, op, false, null);
                    l = buf.size() - l;
                    out.write(this.n2s(emptySlot, 4));
                    emptySlot += l;
                    tis = null;
                    out.write(this.n2s(514, 2));
                    out.write(this.n2s(4, 2));
                    out.write(this.n2s(1, 4));
                    out.write(this.n2s(l, 4));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                continue;
            }
            for (i = 0; i < vs.length; ++i) {
                out.write(this.n2s((Integer)vs[i], tlen));
            }
            if (vs.length * tlen >= 4) continue;
            for (i = 0; i < 4 - vs.length * tlen; ++i) {
                out.write(0);
            }
        }
        IFD[] ifds = ifd.getIFDs();
        for (int k = 0; ifds != null && k < ifds.length; ++k) {
            IFD ifd1 = ifds[k];
            out.write(this.n2s(ifd1.getTag(), 2));
            out.write(this.n2s(ifd1.getType(), 2));
            out.write(this.n2s(1, 4));
            out.write(this.n2s(emptySlot, 4));
            emptySlot = this.writeIfd(buf, emptySlot, ifd1, im, op, encoding);
        }
        out.write(this.n2s(emptySlot, 4));
        out.write(buf.toByteArray());
        return emptySlot;
    }

    protected int firstIFD() {
        return this.s2n(10, 4) + 6;
    }

    protected int nextIFD(int ifd) {
        int entries = this.s2n(ifd, 2);
        return this.s2n(ifd + 2 + 12 * entries, 4) + 6;
    }

    protected void processAllIFDs() {
        int i = this.firstIFD();
        for (int iifd = 0; i > 6 && iifd < 2; ++iifd) {
            this.ifds[iifd] = new IFD(iifd);
            this.storeIFD(i, this.ifds[iifd]);
            i = this.nextIFD(i);
        }
    }

    protected void storeIFD(int ifdoffset, IFD ifd) {
        int entries = this.s2n(ifdoffset, 2);
        for (int i = 0; i < entries; ++i) {
            int entry = ifdoffset + 2 + 12 * i;
            int tag = this.s2n(entry, 2);
            int type = this.s2n(entry + 2, 2);
            if (type < 1 || type > 10) continue;
            int typelen = TYPELENGTH[type - 1];
            int count = this.s2n(entry + 4, 4);
            int offset = entry + 8;
            if (count * typelen > 4) {
                offset = this.s2n(offset, 4) + 6;
            }
            if (type == 2) {
                try {
                    ifd.addEntry(tag, new Entry(type, new String(this.data, offset, count - 1, "Default")));
                }
                catch (UnsupportedEncodingException e) {
                    System.err.println("storeIFD: getString() " + e);
                }
                continue;
            }
            Object[] values = new Object[count];
            boolean signed = true;
            for (int j = 0; j < count; ++j) {
                values[j] = type % 5 != 0 ? new Integer(this.s2n(offset, typelen, signed)) : new Rational(this.s2n(offset, 4, signed), this.s2n(offset + 4, 4, signed));
                offset += typelen;
                if ((tag == 34665 || tag == 40965) && j == 0 && (Integer)values[0] > 0) {
                    IFD iifd = new IFD(tag, type);
                    this.storeIFD((Integer)values[0] + 6, iifd);
                    ifd.addIFD(iifd);
                    continue;
                }
                ifd.addEntry(tag, new Entry(type, values));
            }
        }
    }

    public IFD[] getIFDs() {
        return this.ifds;
    }
}

