<% if (thumbnailBorderSize < 0 || thumbnailBorderType == "none") {
	thumbnailBorderSize = 0;
}
if (selectedThumbnailBorderSize < 0 || selectedThumbnailBorderType == "none") {
	selectedThumbnailBorderSize = 0;
}
if (folderIconBorderSize < 0 || folderIconBorderType == "none") {
	folderIconBorderSize = 0;
}
browserThumbWidth = fixedSizeBrowserScaling ? fixedWidth : maxThumbWidth;
browserThumbHeight = fixedSizeBrowserScaling ? fixedHeight : maxThumbHeight;
thumbItemSize = browserThumbWidth + thumbnailMargin + thumbnailBorderSize * 2;
selectedThumbItemSize = browserThumbWidth + thumbnailMargin + selectedThumbnailBorderSize * 2;
scrollerWidth = thumbItemSize * (scrollerSize-1) + selectedThumbItemSize;
scrollerContainerWidth = scrollerWidth;
arrowCount = 0; 
if (navigation) {
	arrowCount += 2;
	scrollerContainerWidth += (arrowWidth + arrowMargin) * 2 - thumbnailMargin;
	if (fastNavigation) {
		arrowCount += 2;
		scrollerContainerWidth += arrowWidth * 2 + arrowMargin * 4;
	}
}
folderItemWidth = maxThumbWidth + (folderIconBorderSize * 2) + folderMargin;
folderItemHeight = maxThumbHeight + (folderIconBorderSize * 2) + folderMargin; 
totalFoldersWidth = totalFolderCount * folderItemWidth;
foldersWidth = folderCount > totalFolderCount ? totalFoldersWidth : folderCount * folderItemWidth; %>
<style type="text/css">
	.thumbnails li {
		width: ${browserThumbWidth}px;
		height: ${browserThumbHeight}px;
	}

	#middle_container {
		height: <%= navigation && fixedFooterPosition ? (maxHeight + (showMetadata ? metadataBottomMargin : bottomMargin)) + "px" : "auto" %>;
	}

	#scroller_container {
		margin-top: ${scrollerMargin}px;
		margin-bottom: <%= scrollerMargin - thumbnailMargin %>px;
		width: ${scrollerContainerWidth}px;	
	}

	#image_scroller {
		margin: <%= arrowCount > 0 ? ("0 " + (arrowMargin - thumbnailMargin) + "px 0 " + arrowMargin + "px") : "0" %>;
		width: ${scrollerWidth}px;
	}
	
	#thumbnails_container {
		width: <%= thumbItemSize * (totalThumbnailCount-1) + selectedThumbItemSize %>px;
	}
	
	#scroller_container,
	#image_scroller,
	#thumbnails_container {
		height: <%= selectedThumbItemSize > thumbItemSize ? selectedThumbItemSize : thumbItemSize %>px;
	}
	
	#folders_container {
		<%= totalThumbnailCount == 0 ? "border-bottom: none;" : "" %>;
	}		
	
	.folders {
		width: ${foldersWidth}px;
	}
	
	.folders li {
		width: ${folderItemWidth}px;
		height: ${folderItemHeight}px;
	}
	
	.caption,
	.description {
		width: <%= navigation ? scrollerWidth + "px" : "auto"; %>;
	}
</style>
