import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.*;

/**
 * Title:        JAlbum simple image filter blurring images
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */
public class BlurFilter implements JAFilter {

		// Implements JAFilter
    public String getName() {
        return "Blur filter";
    }

		// Implements JAFilter
    public String getDescription() {
        return "Blur images";
    }

		// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
		Graphics2D g = bi.createGraphics();

		if (bi.getType() == BufferedImage.TYPE_3BYTE_BGR) {
			bi=convertType(bi, BufferedImage.TYPE_INT_RGB);
		}
		if (bi.getType() == BufferedImage.TYPE_4BYTE_ABGR) {
			bi=convertType(bi, BufferedImage.TYPE_INT_ARGB);
		}
		Kernel kernel = new Kernel(5, 5,
			new float[] {
				1f/25f, 1f/25f, 1f/25f,1f/25f, 1f/25f,
				1f/25f, 1f/25f, 1f/25f,1f/25f, 1f/25f,
				1f/25f, 1f/25f, 1f/25f,1f/25f, 1f/25f,
				1f/25f, 1f/25f, 1f/25f,1f/25f, 1f/25f,
				1f/25f, 1f/25f, 1f/25f,1f/25f, 1f/25f,
			});

		BufferedImageOp op = new ConvolveOp(kernel, ConvolveOp.EDGE_NO_OP, null);
		bi = op.filter(bi, null);
		return bi;
    }
    
	private BufferedImage convertType(BufferedImage src, int type) {
		ColorConvertOp cco=new ColorConvertOp(null);
		BufferedImage dest=new BufferedImage(src.getWidth(), src.getHeight(), type);
		cco.filter(src, dest);
		return dest;
	}
}
