/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JHyperTextDialog;
import se.datadosen.jalbum.JPublishWizard;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SlowOperation;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.BeanBinder;
import us.monoid.web.AbstractContent;
import us.monoid.web.RobustResty;

public class JAddAccountDialog
extends JSmartDialog {
    private boolean isExisting = true;
    private boolean altActivationUrl;
    private JAlbumFrameIcons icons = JAlbumFrameIcons.getInstance();
    private JLabel tipLabel = new JLabel(Msg.get("ui.signupTipLabel"));
    private JRadioButton addExisting = new JRadioButton(Msg.get("publish.useExisting"));
    private JRadioButton addMyJAlbum = new JRadioButton(Msg.get("publish.useMyJAlbum"));
    private ButtonGroup addType = new ButtonGroup(){
        {
            this.add(JAddAccountDialog.this.addExisting);
            this.add(JAddAccountDialog.this.addMyJAlbum);
            JAddAccountDialog.this.addExisting.setSelected(true);
        }
    };
    ControlPanel myjalbumPanel = new ControlPanel(Msg.get("publish.myJAlbumAccount"));
    JLabel userNameLabel = new JLabel(Msg.get("ui.userName"));
    JTextField userName = new JSmartTextField(16);
    JLabel passwordLabel = new JLabel(Msg.get("ui.password"));
    JPasswordField password = new JPasswordField(16);
    JTextPane moreInfoPane = new JTextPane();
    Action okAction = new AbstractAction(Msg.get("ok")){

        public void actionPerformed(ActionEvent e) {
            if (JAddAccountDialog.this.isExisting) {
                ((JPublishWizard)JAddAccountDialog.this.getOwner()).accountsStep.addAccount(new AccountProfile(Msg.get("publish.NewAccount")));
                JAddAccountDialog.this.setVisible(false);
            } else {
                JAddAccountDialog.this.activateAccount();
            }
        }
    };
    Action cancelAction = new AbstractAction(Msg.get("cancel")){

        public void actionPerformed(ActionEvent e) {
            JAddAccountDialog.this.setVisible(false);
        }
    };

    public JAddAccountDialog(JPublishWizard parent, boolean modal, boolean altActivationUrl) throws ElementException, IOException {
        super((Dialog)parent, modal);
        this.altActivationUrl = altActivationUrl;
        if (altActivationUrl) {
            System.out.println("Using alt signup URL at " + JAlbumSite.getTrueInstance().getMyJAlbumAltActivationUrl());
        }
        this.init(parent);
    }

    private void postPage(final URL url, final Map data) throws Throwable {
        SlowOperation activateOp = new SlowOperation(){

            public void operation() throws Throwable {
                RobustResty r = new RobustResty();
                String result = r.text(url.toURI(), (AbstractContent)RobustResty.form(data)).toString();
                this.setResult(result);
            }

            public void abort() {
            }
        };
        boolean done = activateOp.launch(this, new JLabel(Msg.get("publish.communicating") + " " + "...", ((JPublishWizard)this.getOwner()).accountsStep.serverIcon, 10), (Icon)((JPublishWizard)this.getOwner()).accountsStep.serverConnectionIcon, Msg.get("publish.myJAlbumHosting"));
        if (done) {
            String result;
            String doc = (String)activateOp.getResult();
            if (this.altActivationUrl) {
                System.out.println("Result from server:\n" + doc);
            }
            if ((result = Elements.contentOfElement("result", doc)) == null) {
                throw new Exception("Script error. Please contact hosting@jalbum.net:\n" + doc);
            }
            String message = Elements.contentOfElement("message", doc);
            String htmlMessage = Elements.contentOfElement("htmlMessage", doc);
            Element account = Elements.getElementByName("account", doc, false);
            String confirmationText = Elements.contentOfElement("requireConfirmation", doc);
            if (result.equals("ok")) {
                if (message != null) {
                    JOptionPane.showMessageDialog(this, message, Msg.get("wiz.signupOkTitle"), 1);
                }
                if (htmlMessage != null) {
                    JHyperTextDialog dialog = new JHyperTextDialog(this, Msg.get("publish.myJAlbumHosting"), htmlMessage, -1, confirmationText);
                    dialog.setVisible(true);
                    if (dialog.isOkPressed() && confirmationText != null) {
                        data.put("confirmed", "true");
                        this.postPage(url, data);
                    }
                }
                if (account != null) {
                    Map<String, String> attributes = account.getAttributes();
                    AccountProfile newProfile = new AccountProfile(attributes.get("ftpServer"));
                    BeanBinder.setProperties((Object)newProfile, attributes);
                    JPublishWizard publishWizard = (JPublishWizard)this.getOwner();
                    publishWizard.accountsStep.addAccount(newProfile);
                    this.setVisible(false);
                    publishWizard.accountsStep.connectAction.actionPerformed(null);
                }
            } else if (result.equals("fail")) {
                if (message != null) {
                    JOptionPane.showMessageDialog(this, message, Msg.get("publish.myJAlbumHosting"), 0);
                } else {
                    JHyperTextDialog dialog = new JHyperTextDialog(this, Msg.get("publish.myJAlbumHosting"), htmlMessage, 0);
                    dialog.setVisible(true);
                }
            }
        }
    }

    private void activateAccount() {
        try {
            URL url = new URL(this.altActivationUrl ? JAlbumSite.getTrueInstance().getMyJAlbumAltActivationUrl() : JAlbumSite.getTrueInstance().getMyJAlbumActivationUrl());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("userName", this.userName.getText());
            data.put("password", new String(this.password.getPassword()));
            data.put("language", Config.getConfig().getInterpretedLanguage());
            data.put("confirmed", "true");
            this.postPage(url, data);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, t.getMessage(), Msg.get("publish.myJAlbumHosting"), 0);
        }
    }

    private void manageDisabling() {
        this.okAction.setEnabled(this.userName.getText().length() > 1 && this.password.getPassword().length > 1);
    }

    private void init(JDialog parent) throws IOException, ElementException {
        this.setTitle(Msg.get("publish.addAccount"));
        if (this.altActivationUrl) {
            this.setTitle(this.getTitle() + " - Test");
        }
        this.tipLabel.setIcon(this.icons.tipIcon);
        this.addExisting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JAddAccountDialog.this.isExisting) {
                    return;
                }
                JAddAccountDialog.this.isExisting = true;
                JComponent c = (JComponent)JAddAccountDialog.this.getContentPane();
                c.remove(JAddAccountDialog.this.myjalbumPanel);
                JAddAccountDialog.this.pack();
                JAddAccountDialog.this.okAction.setEnabled(true);
            }
        });
        this.addMyJAlbum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!JAddAccountDialog.this.isExisting) {
                    return;
                }
                JAddAccountDialog.this.isExisting = false;
                JComponent c = (JComponent)JAddAccountDialog.this.getContentPane();
                c.add("br hfill", JAddAccountDialog.this.myjalbumPanel);
                JAddAccountDialog.this.pack();
                JAddAccountDialog.this.userName.requestFocusInWindow();
                JAddAccountDialog.this.manageDisabling();
            }
        });
        this.userName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                JAddAccountDialog.this.manageDisabling();
            }
        });
        this.password.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                JAddAccountDialog.this.manageDisabling();
            }
        });
        this.moreInfoPane.setContentType("text/html");
        this.moreInfoPane.setOpaque(false);
        this.moreInfoPane.setEditable(false);
        String info = Msg.get("publish.moreInfo", JAlbumSite.getTrueInstance().getMyJAlbumInfoUrl());
        this.moreInfoPane.setText("<html><body><font face=\"sansserif\" size=3>" + info + "</font></body></html>");
        this.moreInfoPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        BrowserLauncher.openURL(e.getURL().toExternalForm());
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(JAddAccountDialog.this, ex.getMessage(), Msg.get("wiz.openFailed"), 0);
                    }
                }
            }
        });
        JComponent c = (JComponent)this.getContentPane();
        c.setLayout(new RiverLayout());
        c.add("br", this.tipLabel);
        c.add("p", this.addExisting);
        c.add("br", this.addMyJAlbum);
        this.myjalbumPanel.add("br", this.userNameLabel);
        this.myjalbumPanel.add("tab", this.userName);
        this.myjalbumPanel.add("br", this.passwordLabel);
        this.myjalbumPanel.add("tab", this.password);
        this.myjalbumPanel.add("p", this.moreInfoPane);
        this.registerActions(this.okAction, this.cancelAction);
        this.pack();
        this.addMyJAlbum.doClick();
    }
}

