/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.Platform;

public class JCollapsiblePanel
extends JPanel
implements JComponentHolder {
    private static ImageIcon collapsedTriangle = new ImageIcon(new BufferedImage(9, 9, 6));
    private static ImageIcon expandedTriangle = new ImageIcon(JCollapsiblePanel.class.getResource("images/triangle1-dark.png"));
    private JPanel contentPanel = new JComponentHolderPanel();
    private JTriangleLabel titleLabel = new JTriangleLabel(collapsedTriangle);
    private JPanel titlePanel = new JPanel(new FlowLayout(3));
    private Border titleBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.lightGray);
    private JPanel bottomPanel = new JPanel();
    private boolean expanded = false;

    public void add(Component comp, Object constraints, int index) {
        this.contentPanel.add(comp, constraints, index);
    }

    public void add(Component comp, Object constraints) {
        this.contentPanel.add(comp, constraints);
    }

    public Component add(Component comp, int index) {
        return this.contentPanel.add(comp, index);
    }

    public Component add(String name, Component comp) {
        return this.contentPanel.add(name, comp);
    }

    public Component add(Component comp) {
        return this.contentPanel.add(comp);
    }

    public JCollapsiblePanel() {
        this.init(null);
    }

    public JCollapsiblePanel(LayoutManager layout) {
        this.contentPanel.setLayout(layout);
        this.init(null);
    }

    public JCollapsiblePanel(String title) {
        this.init(title);
    }

    public JCollapsiblePanel(String title, LayoutManager layout) {
        this.contentPanel.setLayout(layout);
        this.init(title);
    }

    private void init(String title) {
        super.setLayout(new BorderLayout());
        super.setOpaque(false);
        this.titlePanel.setOpaque(false);
        this.contentPanel.setOpaque(false);
        this.bottomPanel.setOpaque(false);
        this.titlePanel.setBorder(this.titleBorder);
        this.titleLabel.setText(title);
        if (System.getProperty("mrj.version") != null) {
            Font f = this.titleLabel.getFont();
            this.titleLabel.setFont(f.deriveFont(f.getSize2D() - 1.0f));
        }
        this.titlePanel.add(this.titleLabel);
        super.add((Component)this.titlePanel, "North");
        this.titlePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JCollapsiblePanel.this.setExpanded(!JCollapsiblePanel.this.expanded);
            }

            public void mouseEntered(MouseEvent e) {
                JCollapsiblePanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent e) {
                JCollapsiblePanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.bottomPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.lightGray));
    }

    public JLabel getLabel() {
        return this.titleLabel;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void setContentPanel(JPanel contentPanel) {
        if (this.expanded) {
            super.remove(this.contentPanel);
            super.add((Component)contentPanel, "Center");
            this.invalidate();
        }
        this.contentPanel = contentPanel;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded == expanded) {
            return;
        }
        this.expanded = expanded;
        this.titleLabel.setExpanded(expanded);
        if (expanded) {
            super.add((Component)this.contentPanel, "Center");
            this.titlePanel.setBorder(null);
            super.add((Component)this.bottomPanel, "South");
        } else {
            this.titlePanel.setBorder(this.titleBorder);
            super.remove(this.contentPanel);
            super.remove(this.bottomPanel);
        }
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.firePropertyChange("expanded", !expanded, expanded);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    class JTriangleLabel
    extends JLabel {
        private boolean expanded;

        public JTriangleLabel(Icon image) {
            super(image);
            this.expanded = false;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }

        protected void paintComponent(Graphics g2) {
            Graphics2D g = (Graphics2D)g2;
            AlphaComposite composite = AlphaComposite.getInstance(3, 0.75f);
            g.setComposite(composite);
            super.paintComponent(g);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setColor(this.getForeground());
            Insets in = this.getInsets();
            Icon icon = this.getIcon();
            AffineTransform backup = g.getTransform();
            if (Platform.isWindows()) {
                g.translate(0.0, 0.5);
            }
            if (Platform.isMac()) {
                g.translate(0.5, 0.0);
            }
            int yOff = this.getHeight() / 2;
            g.translate(in.left, yOff);
            if (this.expanded) {
                g.fillPolygon(new int[]{icon.getIconWidth() / 2, 0, icon.getIconWidth()}, new int[]{icon.getIconHeight() / 2, 1 - icon.getIconHeight() / 2, 1 - icon.getIconHeight() / 2}, 3);
            } else {
                g.fillPolygon(new int[]{icon.getIconWidth(), 1, 1}, new int[]{0, icon.getIconHeight() / 2, -icon.getIconHeight() / 2}, 3);
            }
            g.setTransform(backup);
        }
    }

    private static class JComponentHolderPanel
    extends JPanel
    implements JComponentHolder {
        private JComponentHolderPanel() {
        }
    }
}

