/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ComponentUtilities {
    public static void whenSelectedEnable(AbstractButton button, JComponent ... comps) {
        ComponentUtilities.whenSelectedEnable(button, false, comps);
    }

    public static void whenSelectedDisable(AbstractButton button, JComponent ... comps) {
        ComponentUtilities.whenSelectedEnable(button, true, comps);
    }

    public static void whenSelectedEnable(AbstractButton button, JComponent comp) {
        ComponentUtilities.whenSelectedEnable(button, false, comp);
    }

    public static void whenSelectedDisable(AbstractButton button, JComponent comp) {
        ComponentUtilities.whenSelectedEnable(button, true, comp);
    }

    public static void whenEqualsEnable(JComboBox cbox, Object value, JComponent ... comps) {
        ComponentUtilities.whenEqualsEnable(cbox, value, false, comps);
    }

    public static void whenEqualsDisable(JComboBox cbox, Object value, JComponent ... comps) {
        ComponentUtilities.whenEqualsEnable(cbox, value, true, comps);
    }

    public static void whenEqualsEnable(JComboBox cbox, Object value, JComponent comp) {
        ComponentUtilities.whenEqualsEnable(cbox, value, false, comp);
    }

    public static void whenEqualsDisable(JComboBox cbox, Object value, JComponent comp) {
        ComponentUtilities.whenEqualsEnable(cbox, value, true, comp);
    }

    private static void whenEqualsEnable(final JComboBox cbox, final Object value, final boolean invert, final JComponent ... comps) {
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                for (JComponent comp : comps) {
                    comp.setEnabled(value.equals(cbox.getSelectedItem()) ^ invert);
                }
            }
        };
        cbox.addItemListener(il);
        il.itemStateChanged(null);
    }

    private static void whenSelectedEnable(final AbstractButton button, final boolean invert, final JComponent ... comps) {
        ChangeListener cl = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                for (JComponent comp : comps) {
                    comp.setEnabled(button.isSelected() ^ invert);
                }
            }
        };
        button.addChangeListener(cl);
        cl.stateChanged(null);
    }
}

