/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs.ftp;

import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.ftp.FtpFile;
import it.sauronsoftware.ftp4j.FTPClient;
import it.sauronsoftware.ftp4j.FTPDataTransferListener;
import it.sauronsoftware.ftp4j.FTPException;
import it.sauronsoftware.ftp4j.FTPFile;
import it.sauronsoftware.ftp4j.FTPIllegalReplyException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import se.datadosen.jalbum.TransferProtocol;

public class Ftp4jAdapter
implements RemoteFS {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private FTPClient ftpClient = new FTPClient();
    private boolean connected = false;
    private int port;
    private FTPDataTransferListener monitor = null;
    private int ftpSecurity = 0;
    private boolean abortConnect;

    public Ftp4jAdapter(TransferProtocol protocol) {
        switch (protocol) {
            case ftp: {
                this.ftpSecurity = 0;
                break;
            }
            case ftps: {
                this.ftpSecurity = 1;
                break;
            }
            case ftpes: {
                this.ftpSecurity = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Protocol " + (Object)((Object)protocol) + " not supported by ftp4j");
            }
        }
        this.ftpClient.setCharset(DEFAULT_ENCODING);
        if (protocol == TransferProtocol.ftps || protocol == TransferProtocol.ftpes) {
            TrustManager[] trustManager = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManager, new SecureRandom());
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            this.ftpClient.setSSLSocketFactory(sslSocketFactory);
            this.ftpClient.setSecurity(this.ftpSecurity);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.ftpClient.getPort();
    }

    public void setForceUTF8(boolean force) {
        if (force) {
            this.ftpClient.setCharset("UTF-8");
        } else {
            this.ftpClient.setCharset(DEFAULT_ENCODING);
        }
    }

    public boolean isForceUTF8() {
        return "UTF-8".equals(this.ftpClient.getCharset());
    }

    public void setPassiveMode(boolean passive) {
        this.ftpClient.setPassive(passive);
    }

    public boolean isPassiveMode() {
        return this.ftpClient.isPassive();
    }

    public String getDirectory() throws RemoteFSException, IOException {
        try {
            return this.ftpClient.currentDirectory();
        }
        catch (IllegalStateException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPIllegalReplyException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void rename(String from, String to) throws RemoteFSException, IOException {
        try {
            this.ftpClient.rename(from, to);
        }
        catch (IllegalStateException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPIllegalReplyException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void setDirectory(String directory) throws RemoteFSException, IOException {
        try {
            this.ftpClient.changeDirectory(directory);
        }
        catch (IllegalStateException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPIllegalReplyException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void toParentDirectory() throws IOException, RemoteFSException {
        try {
            this.ftpClient.changeDirectoryUp();
        }
        catch (IllegalStateException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPIllegalReplyException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void createDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.ftpClient.createDirectory(name);
        }
        catch (IllegalStateException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPIllegalReplyException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void removeDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.ftpClient.deleteDirectory(name);
        }
        catch (IllegalStateException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPIllegalReplyException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        try {
            this.ftpClient.connect(server, this.port);
            this.ftpClient.login(user, password);
            this.connected = true;
            if (this.abortConnect) {
                this.ftpClient.disconnect(true);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            try {
                this.ftpClient.disconnect(true);
            }
            catch (Exception ex1) {
                // empty catch block
            }
            throw new RemoteFSException(ex);
        }
        finally {
            this.abortConnect = true;
            if (true) {
                this.abortConnect = false;
            }
        }
    }

    public void disconnect() throws IOException, RemoteFSException {
        this.connected = false;
        try {
            this.ftpClient.disconnect(true);
        }
        catch (IllegalStateException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPIllegalReplyException ex) {
            throw new RemoteFSException(ex);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public boolean isConnected() {
        return this.ftpClient.isConnected();
    }

    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        return this.getFiles(".");
    }

    public RemoteFile[] getFiles(String dir) throws IOException, RemoteFSException {
        try {
            FTPFile[] files = this.ftpClient.list(dir);
            RemoteFile[] finalFiles = new FtpFile[files.length];
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                long size = files[i].getSize();
                Date date = files[i].getModifiedDate();
                finalFiles[i] = new FtpFile(name, size, date, files[i].getType() == 1, files[i].getType() == 2);
            }
            return finalFiles;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteFSException(e);
        }
    }

    public void putFile(File file) throws IOException, RemoteFSException {
        try {
            this.ftpClient.upload(file, this.monitor);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void putFile(File file, String path) throws IOException, RemoteFSException {
        try {
            FileInputStream fis = new FileInputStream(file);
            this.ftpClient.upload(path, (InputStream)fis, 0L, 0L, this.monitor);
            fis.close();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void put(InputStream in, String path) throws IOException, RemoteFSException {
        try {
            this.ftpClient.upload(path, in, 0L, 0L, this.monitor);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void get(String path, OutputStream out) throws IOException, RemoteFSException {
        try {
            this.ftpClient.download(path, out, 0L, this.monitor);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void removeFile(String filename) throws IOException, RemoteFSException {
        try {
            this.ftpClient.deleteFile(filename);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void setProgressMonitor(final RemoteFSProgressMonitor monitor) {
        this.monitor = new FTPDataTransferListener(){
            private long bytesTransferred;

            public void started() {
                this.bytesTransferred = 0L;
            }

            public void transferred(int length) {
                this.bytesTransferred += (long)length;
                monitor.bytesTransferred(this.bytesTransferred);
            }

            public void completed() {
            }

            public void aborted() {
            }

            public void failed() {
            }
        };
    }

    public void abortConnect() throws IOException, RemoteFSException {
        block2: {
            try {
                this.ftpClient.disconnect(false);
            }
            catch (Exception ex) {
                if (!this.ftpClient.isConnected()) break block2;
                this.ftpClient.abruptlyCloseCommunication();
            }
        }
    }

    public boolean exists(String path) throws IOException, RemoteFSException {
        try {
            this.ftpClient.fileSize(path);
            return true;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void getUnmonitored(String path, OutputStream out) throws IOException, RemoteFSException {
        throw new RemoteFSException("Not supported");
    }
}

