/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import java.io.Serializable;

public class Rational
extends Number
implements Serializable {
    private final long numerator;
    private final long denominator;
    private int maxSimplificationCalculations = 1000;

    public Rational(long numerator, long denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Rational(Integer numerator, Integer denominator) {
        this.numerator = numerator.intValue();
        this.denominator = denominator.intValue();
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public final byte byteValue() {
        return (byte)this.doubleValue();
    }

    public final int intValue() {
        return (int)this.doubleValue();
    }

    public final long longValue() {
        return (long)this.doubleValue();
    }

    public final short shortValue() {
        return (short)this.doubleValue();
    }

    public final long getDenominator() {
        return this.denominator;
    }

    public final long getNumerator() {
        return this.numerator;
    }

    public Rational getReciprocal() {
        return new Rational(this.denominator, this.numerator);
    }

    public boolean isInteger() {
        return this.denominator == 1L || this.denominator != 0L && this.numerator % this.denominator == 0L || this.denominator == 0L && this.numerator == 0L;
    }

    public String toString() {
        return this.numerator + "/" + this.denominator;
    }

    public String toSimpleString(boolean allowDecimal) {
        String doubleString;
        if (this.denominator == 0L && this.numerator != 0L) {
            return this.toString();
        }
        if (this.isInteger()) {
            return Integer.toString(this.intValue());
        }
        if (Math.abs(this.numerator) != 1L && this.denominator % this.numerator == 0L) {
            long newDenominator = Math.abs(this.denominator / this.numerator);
            return new Rational((long)Long.signum(this.denominator / this.numerator), newDenominator).toSimpleString(allowDecimal);
        }
        Rational simplifiedInstance = this.getSimplifiedInstance();
        if (allowDecimal && (doubleString = Double.toString(simplifiedInstance.doubleValue())).length() < 5) {
            return doubleString;
        }
        return simplifiedInstance.toString();
    }

    private boolean tooComplexForSimplification() {
        double maxPossibleCalculations = (double)(Math.min(this.denominator, this.numerator) - 1L) / 5.0 + 2.0;
        return maxPossibleCalculations > (double)this.maxSimplificationCalculations;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rational)) {
            return false;
        }
        Rational that = (Rational)obj;
        return this.doubleValue() == that.doubleValue();
    }

    public Rational getSimplifiedInstance() {
        if (this.tooComplexForSimplification()) {
            return this;
        }
        int factor = 2;
        while ((long)factor <= Math.min(this.denominator, this.numerator)) {
            if (!(factor % 2 == 0 && factor > 2 || factor % 5 == 0 && factor > 5 || this.denominator % (long)factor != 0L || this.numerator % (long)factor != 0L)) {
                return new Rational(this.numerator / (long)factor, this.denominator / (long)factor);
            }
            ++factor;
        }
        return this;
    }
}

