/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.fileutil;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import org.jdesktop.jdic.fileutil.NativeFileUtil;

class SolarisNativeFileUtil
extends NativeFileUtil {
    SolarisNativeFileUtil() {
    }

    public boolean recycle(File file) throws IOException, SecurityException {
        throw new UnsupportedOperationException("Your platform doesn't support this method");
    }

    public BigInteger getFreeSpace(File file) throws IOException {
        if (file.isFile()) {
            BigInteger bigInteger = new BigInteger(Long.toString(this.getFreeSpace(file.getCanonicalFile().getParent())));
            return bigInteger;
        }
        if (file.isDirectory()) {
            BigInteger bigInteger = new BigInteger(Long.toString(this.getFreeSpace(file.getCanonicalPath())));
            return bigInteger;
        }
        return BigInteger.ZERO;
    }

    public BigInteger getTotalSpace(File file) throws IOException {
        if (file.isFile()) {
            BigInteger bigInteger = new BigInteger(Long.toString(this.getTotalSpace(file.getCanonicalFile().getParent())));
            return bigInteger;
        }
        if (file.isDirectory()) {
            BigInteger bigInteger = new BigInteger(Long.toString(this.getTotalSpace(file.getCanonicalPath())));
            return bigInteger;
        }
        return BigInteger.ZERO;
    }

    public void close() {
        this.findClose();
    }

    public String readFirst(String string) {
        String string2 = this.findFirst(string);
        if (string2 != null) {
            if (string2.equals(".") || string2.equals("..")) {
                string2 = this.readNext();
            }
            string2 = File.separator + string2;
        }
        return string2;
    }

    public String readNext() {
        String string = this.findNext();
        if (string != null) {
            if (string.equals(".") || string.equals("..")) {
                string = this.findNext();
            }
            string = File.separator + string;
        }
        return string;
    }

    private native long getFreeSpace(String var1);

    private native long getTotalSpace(String var1);

    private native String findFirst(String var1);

    private native String findNext();

    private native boolean findClose();

    static {
        System.loadLibrary("jdic_fileutil");
    }
}

