/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPConst;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.impl.ParameterAsserts;
import com.adobe.xmp.impl.Utils;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPNode;
import com.adobe.xmp.impl.XMPNodeUtils;
import com.adobe.xmp.impl.xpath.XMPPath;
import com.adobe.xmp.impl.xpath.XMPPathParser;
import com.adobe.xmp.options.PropertyOptions;
import com.adobe.xmp.properties.XMPAliasInfo;
import java.util.Iterator;

public class XMPUtilsImpl
implements XMPConst {
    private static final int UCK_NORMAL = 0;
    private static final int UCK_SPACE = 1;
    private static final int UCK_COMMA = 2;
    private static final int UCK_SEMICOLON = 3;
    private static final int UCK_QUOTE = 4;
    private static final int UCK_CONTROL = 5;
    private static final String SPACES = " \u3000\u303f";
    private static final String COMMAS = ",\uff0c\uff64\ufe50\ufe51\u3001\u060c\u055d";
    private static final String SEMICOLA = ";\uff1b\ufe54\u061b\u037e";
    private static final String QUOTES = "\"[]\u00ab\u00bb\u301d\u301e\u301f\u2015\u2039\u203a";
    private static final String CONTROLS = "\u2028\u2029";

    private XMPUtilsImpl() {
    }

    public static String catenateArrayItems(XMPMeta xMPMeta, String string, String string2, String string3, String string4, boolean bl) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertArrayName(string2);
        ParameterAsserts.assertImplementation(xMPMeta);
        if (string3 == null || string3.length() == 0) {
            string3 = "; ";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "\"";
        }
        XMPMetaImpl xMPMetaImpl = (XMPMetaImpl)xMPMeta;
        XMPNode xMPNode = null;
        XMPNode xMPNode2 = null;
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        xMPNode = XMPNodeUtils.findNode(xMPMetaImpl.getRoot(), xMPPath, false, null);
        if (xMPNode == null) {
            return "";
        }
        if (!xMPNode.getOptions().isArray() || xMPNode.getOptions().isArrayAlternate()) {
            throw new XMPException("Named property must be non-alternate array", 4);
        }
        XMPUtilsImpl.checkSeparator(string3);
        char c = string4.charAt(0);
        char c2 = XMPUtilsImpl.checkQuotes(string4, c);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = xMPNode.iterateChildren();
        while (iterator.hasNext()) {
            xMPNode2 = (XMPNode)iterator.next();
            if (xMPNode2.getOptions().isCompositeProperty()) {
                throw new XMPException("Array items must be simple", 4);
            }
            String string5 = XMPUtilsImpl.applyQuotes(xMPNode2.getValue(), c, c2, bl);
            stringBuffer.append(string5);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static void separateArrayItems(XMPMeta xMPMeta, String string, String string2, String string3, PropertyOptions propertyOptions, boolean bl) throws XMPException {
        ParameterAsserts.assertSchemaNS(string);
        ParameterAsserts.assertArrayName(string2);
        if (string3 == null) {
            throw new XMPException("Parameter must not be null", 4);
        }
        ParameterAsserts.assertImplementation(xMPMeta);
        XMPMetaImpl xMPMetaImpl = (XMPMetaImpl)xMPMeta;
        XMPNode xMPNode = XMPUtilsImpl.separateFindCreateArray(string, string2, propertyOptions, xMPMetaImpl);
        int n = 0;
        int n2 = 0;
        char c = '\u0000';
        char c2 = '\u0000';
        int n3 = 0;
        int n4 = string3.length();
        while (n3 < n4) {
            char c3;
            char c4;
            String string4;
            int n5;
            for (n5 = n3; n5 < n4 && (n2 = XMPUtilsImpl.classifyCharacter(c = string3.charAt(n5))) != 0 && n2 != 4; ++n5) {
            }
            if (n5 >= n4) break;
            if (n2 != 4) {
                for (n3 = n5; n3 < n4 && ((n2 = XMPUtilsImpl.classifyCharacter(c = string3.charAt(n3))) == 0 || n2 == 4 || n2 == 2 && bl || n2 == 1 && n3 + 1 < n4 && ((n = XMPUtilsImpl.classifyCharacter(c = string3.charAt(n3 + 1))) == 0 || n == 4 || n == 2 && bl)); ++n3) {
                }
                string4 = string3.substring(n5, n3);
            } else {
                c4 = c;
                c3 = XMPUtilsImpl.getClosingQuote(c4);
                string4 = "";
                for (n3 = ++n5; n3 < n4; ++n3) {
                    c = string3.charAt(n3);
                    n2 = XMPUtilsImpl.classifyCharacter(c);
                    if (n2 != 4 || !XMPUtilsImpl.isSurroundingQuote(c, c4, c3)) {
                        string4 = string4 + c;
                        continue;
                    }
                    if (n3 + 1 < n4) {
                        c2 = string3.charAt(n3 + 1);
                        n = XMPUtilsImpl.classifyCharacter(c2);
                    } else {
                        n = 3;
                        c2 = ';';
                    }
                    if (c == c2) {
                        string4 = string4 + c;
                        ++n3;
                        continue;
                    }
                    if (!XMPUtilsImpl.isClosingingQuote(c, c4, c3)) {
                        string4 = string4 + c;
                        continue;
                    }
                    ++n3;
                    break;
                }
            }
            c4 = '\uffffffff';
            for (c3 = '\u0001'; c3 <= xMPNode.getChildrenLength(); ++c3) {
                if (!string4.equals(xMPNode.getChild(c3).getValue())) continue;
                c4 = c3;
                break;
            }
            XMPNode xMPNode2 = null;
            if (c4 >= '\u0000') continue;
            xMPNode2 = new XMPNode("[]", string4, null);
            xMPNode.addChild(xMPNode2);
        }
    }

    private static XMPNode separateFindCreateArray(String string, String string2, PropertyOptions propertyOptions, XMPMetaImpl xMPMetaImpl) throws XMPException {
        if (!(propertyOptions = XMPNodeUtils.verifySetOptions(propertyOptions, null)).isOnlyArrayOptions()) {
            throw new XMPException("Options can only provide array form", 103);
        }
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        XMPNode xMPNode = XMPNodeUtils.findNode(xMPMetaImpl.getRoot(), xMPPath, false, null);
        if (xMPNode != null) {
            PropertyOptions propertyOptions2 = xMPNode.getOptions();
            if (!propertyOptions2.isArray() || propertyOptions2.isArrayAlternate()) {
                throw new XMPException("Named property must be non-alternate array", 102);
            }
            if (propertyOptions.equalArrayTypes(propertyOptions2)) {
                throw new XMPException("Mismatch of specified and existing array form", 102);
            }
        } else {
            xMPNode = XMPNodeUtils.findNode(xMPMetaImpl.getRoot(), xMPPath, true, propertyOptions.setArray(true));
            if (xMPNode == null) {
                throw new XMPException("Failed to create named array", 102);
            }
        }
        return xMPNode;
    }

    public static void removeProperties(XMPMeta xMPMeta, String string, String string2, boolean bl, boolean bl2) throws XMPException {
        block5: {
            XMPMetaImpl xMPMetaImpl;
            block6: {
                block4: {
                    ParameterAsserts.assertImplementation(xMPMeta);
                    xMPMetaImpl = (XMPMetaImpl)xMPMeta;
                    if (string2 == null || string2.length() <= 0) break block4;
                    if (string == null || string.length() == 0) {
                        throw new XMPException("Property name requires schema namespace", 4);
                    }
                    XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
                    XMPNode xMPNode = XMPNodeUtils.findNode(xMPMetaImpl.getRoot(), xMPPath, false, null);
                    if (xMPNode == null || !bl && Utils.isInternalProperty(xMPPath.getSegment(0).getName(), xMPPath.getSegment(1).getName())) break block5;
                    XMPNode xMPNode2 = xMPNode.getParent();
                    xMPNode2.removeChild(xMPNode);
                    if (!xMPNode2.getOptions().isSchemaNode() || xMPNode2.hasChildren()) break block5;
                    xMPNode2.getParent().removeChild(xMPNode2);
                    break block5;
                }
                if (string == null || string.length() <= 0) break block6;
                XMPNode xMPNode = XMPNodeUtils.findSchemaNode(xMPMetaImpl.getRoot(), string, false);
                if (xMPNode != null && XMPUtilsImpl.removeSchemaChildren(xMPNode, bl)) {
                    xMPMetaImpl.getRoot().removeChild(xMPNode);
                }
                if (!bl2) break block5;
                XMPAliasInfo[] xMPAliasInfoArray = XMPMetaFactory.getSchemaRegistry().findAliases(string);
                for (int i = 0; i < xMPAliasInfoArray.length; ++i) {
                    XMPAliasInfo xMPAliasInfo = xMPAliasInfoArray[i];
                    XMPPath xMPPath = XMPPathParser.expandXPath(xMPAliasInfo.getNamespace(), xMPAliasInfo.getPropName());
                    XMPNode xMPNode3 = XMPNodeUtils.findNode(xMPMetaImpl.getRoot(), xMPPath, false, null);
                    if (xMPNode3 == null) continue;
                    XMPNode xMPNode4 = xMPNode3.getParent();
                    xMPNode4.removeChild(xMPNode3);
                }
                break block5;
            }
            Iterator iterator = xMPMetaImpl.getRoot().iterateChildren();
            while (iterator.hasNext()) {
                XMPNode xMPNode = (XMPNode)iterator.next();
                if (!XMPUtilsImpl.removeSchemaChildren(xMPNode, bl)) continue;
                iterator.remove();
            }
        }
    }

    public static void appendProperties(XMPMeta xMPMeta, XMPMeta xMPMeta2, boolean bl, boolean bl2, boolean bl3) throws XMPException {
        ParameterAsserts.assertImplementation(xMPMeta);
        ParameterAsserts.assertImplementation(xMPMeta2);
        XMPMetaImpl xMPMetaImpl = (XMPMetaImpl)xMPMeta;
        XMPMetaImpl xMPMetaImpl2 = (XMPMetaImpl)xMPMeta2;
        Iterator iterator = xMPMetaImpl.getRoot().iterateChildren();
        while (iterator.hasNext()) {
            XMPNode xMPNode = (XMPNode)iterator.next();
            XMPNode xMPNode2 = XMPNodeUtils.findSchemaNode(xMPMetaImpl2.getRoot(), xMPNode.getName(), false);
            boolean bl4 = false;
            if (xMPNode2 == null) {
                xMPNode2 = new XMPNode(xMPNode.getName(), xMPNode.getValue(), new PropertyOptions().setSchemaNode(true));
                xMPMetaImpl2.getRoot().addChild(xMPNode2);
                bl4 = true;
            }
            Iterator iterator2 = xMPNode.iterateChildren();
            while (iterator2.hasNext()) {
                XMPNode xMPNode3 = (XMPNode)iterator2.next();
                if (!bl && Utils.isInternalProperty(xMPNode.getName(), xMPNode3.getName())) continue;
                XMPUtilsImpl.appendSubtree(xMPMetaImpl2, xMPNode3, xMPNode2, bl2, bl3);
            }
            if (xMPNode2.hasChildren() || !bl4 && !bl3) continue;
            xMPMetaImpl2.getRoot().removeChild(xMPNode2);
        }
    }

    private static boolean removeSchemaChildren(XMPNode xMPNode, boolean bl) {
        Iterator iterator = xMPNode.iterateChildren();
        while (iterator.hasNext()) {
            XMPNode xMPNode2 = (XMPNode)iterator.next();
            if (!bl && Utils.isInternalProperty(xMPNode.getName(), xMPNode2.getName())) continue;
            iterator.remove();
        }
        return !xMPNode.hasChildren();
    }

    private static void appendSubtree(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, XMPNode xMPNode2, boolean bl, boolean bl2) throws XMPException {
        block18: {
            XMPNode xMPNode3;
            block17: {
                xMPNode3 = XMPNodeUtils.findChildNode(xMPNode2, xMPNode.getName(), false);
                boolean bl3 = false;
                if (bl2) {
                    boolean bl4 = xMPNode.getOptions().isSimple() ? xMPNode.getValue() == null || xMPNode.getValue().length() == 0 : (bl3 = !xMPNode.hasChildren());
                }
                if (!bl2 || !bl3) break block17;
                if (xMPNode3 == null) break block18;
                xMPNode2.removeChild(xMPNode3);
                break block18;
            }
            if (xMPNode3 == null) {
                xMPNode2.addChild((XMPNode)xMPNode.clone());
            } else if (bl) {
                xMPMetaImpl.setNode(xMPNode3, xMPNode.getValue(), xMPNode.getOptions(), true);
                xMPNode2.removeChild(xMPNode3);
                xMPNode3 = (XMPNode)xMPNode.clone();
                xMPNode2.addChild(xMPNode3);
            } else {
                PropertyOptions propertyOptions;
                PropertyOptions propertyOptions2 = xMPNode.getOptions();
                if (propertyOptions2 != (propertyOptions = xMPNode3.getOptions())) {
                    return;
                }
                if (propertyOptions2.isStruct()) {
                    Iterator iterator = xMPNode.iterateChildren();
                    while (iterator.hasNext()) {
                        XMPNode xMPNode4 = (XMPNode)iterator.next();
                        XMPUtilsImpl.appendSubtree(xMPMetaImpl, xMPNode4, xMPNode3, bl, bl2);
                        if (!bl2 || xMPNode3.hasChildren()) continue;
                        xMPNode2.removeChild(xMPNode3);
                    }
                } else if (propertyOptions2.isArrayAltText()) {
                    Iterator iterator = xMPNode.iterateChildren();
                    while (iterator.hasNext()) {
                        XMPNode xMPNode5 = (XMPNode)iterator.next();
                        if (!xMPNode5.hasQualifier() || !"xml:lang".equals(xMPNode5.getQualifier(1).getName())) continue;
                        int n = XMPNodeUtils.lookupLanguageItem(xMPNode3, xMPNode5.getQualifier(1).getValue());
                        if (bl2 && (xMPNode5.getValue() == null || xMPNode5.getValue().length() == 0)) {
                            if (n == -1) continue;
                            xMPNode3.removeChild(n);
                            if (xMPNode3.hasChildren()) continue;
                            xMPNode2.removeChild(xMPNode3);
                            continue;
                        }
                        if (n != -1) continue;
                        if (!"x-default".equals(xMPNode5.getQualifier(1).getValue()) || !xMPNode3.hasChildren()) {
                            xMPNode5.cloneSubtree(xMPNode3);
                            continue;
                        }
                        XMPNode xMPNode6 = new XMPNode(xMPNode5.getName(), xMPNode5.getValue(), xMPNode5.getOptions());
                        xMPNode5.cloneSubtree(xMPNode6);
                        xMPNode3.addChild(1, xMPNode6);
                    }
                } else if (propertyOptions2.isArray()) {
                    Iterator iterator = xMPNode.iterateChildren();
                    while (iterator.hasNext()) {
                        XMPNode xMPNode7 = (XMPNode)iterator.next();
                        boolean bl5 = false;
                        Iterator iterator2 = xMPNode3.iterateChildren();
                        while (iterator2.hasNext()) {
                            XMPNode xMPNode8 = (XMPNode)iterator2.next();
                            if (!XMPUtilsImpl.itemValuesMatch(xMPNode7, xMPNode8)) continue;
                            bl5 = true;
                        }
                        if (bl5) continue;
                        xMPNode3 = (XMPNode)xMPNode7.clone();
                        xMPNode2.addChild(xMPNode3);
                    }
                }
            }
        }
    }

    private static boolean itemValuesMatch(XMPNode xMPNode, XMPNode xMPNode2) throws XMPException {
        PropertyOptions propertyOptions;
        PropertyOptions propertyOptions2 = xMPNode.getOptions();
        if (propertyOptions2.equals(propertyOptions = xMPNode2.getOptions())) {
            return false;
        }
        if (propertyOptions2.getOptions() == 0) {
            if (!xMPNode.getValue().equals(xMPNode2.getValue())) {
                return false;
            }
            if (xMPNode.getOptions().getHasLanguage() != xMPNode2.getOptions().getHasLanguage()) {
                return false;
            }
            if (xMPNode.getOptions().getHasLanguage() && !xMPNode.getQualifier(1).getValue().equals(xMPNode2.getQualifier(1).getValue())) {
                return false;
            }
        } else if (propertyOptions2.isStruct()) {
            if (xMPNode.getChildrenLength() != xMPNode2.getChildrenLength()) {
                return false;
            }
            Iterator iterator = xMPNode.iterateChildren();
            while (iterator.hasNext()) {
                XMPNode xMPNode3 = (XMPNode)iterator.next();
                XMPNode xMPNode4 = XMPNodeUtils.findChildNode(xMPNode2, xMPNode3.getName(), false);
                if (xMPNode4 != null && XMPUtilsImpl.itemValuesMatch(xMPNode3, xMPNode4)) continue;
                return false;
            }
        } else {
            assert (propertyOptions2.isArray());
            Iterator iterator = xMPNode.iterateChildren();
            while (iterator.hasNext()) {
                XMPNode xMPNode5 = (XMPNode)iterator.next();
                boolean bl = false;
                Iterator iterator2 = xMPNode2.iterateChildren();
                while (iterator2.hasNext()) {
                    XMPNode xMPNode6 = (XMPNode)iterator2.next();
                    if (!XMPUtilsImpl.itemValuesMatch(xMPNode5, xMPNode6)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    private static void checkSeparator(String string) throws XMPException {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            int n = XMPUtilsImpl.classifyCharacter(string.charAt(i));
            if (n == 3) {
                if (bl) {
                    throw new XMPException("Separator can have only one semicolon", 4);
                }
                bl = true;
                continue;
            }
            if (n == 1) continue;
            throw new XMPException("Separator can have only spaces and one semicolon", 4);
        }
        if (!bl) {
            throw new XMPException("Separator must have one semicolon", 4);
        }
    }

    private static char checkQuotes(String string, char c) throws XMPException {
        char c2;
        int n = XMPUtilsImpl.classifyCharacter(c);
        if (n != 4) {
            throw new XMPException("Invalid quoting character", 4);
        }
        if (string.length() == 1) {
            c2 = c;
        } else {
            c2 = string.charAt(1);
            n = XMPUtilsImpl.classifyCharacter(c2);
            if (n != 4) {
                throw new XMPException("Invalid quoting character", 4);
            }
        }
        if (c2 != XMPUtilsImpl.getClosingQuote(c)) {
            throw new XMPException("Mismatched quote pair", 4);
        }
        return c2;
    }

    private static int classifyCharacter(char c) {
        if (SPACES.indexOf(c) >= 0 || '\u2000' <= c && c <= '\u200b') {
            return 1;
        }
        if (COMMAS.indexOf(c) >= 0) {
            return 2;
        }
        if (SEMICOLA.indexOf(c) >= 0) {
            return 3;
        }
        if (QUOTES.indexOf(c) >= 0 || '\u3008' <= c && c <= '\u300f' || '\u2018' <= c && c <= '\u201f') {
            return 4;
        }
        if (c < ' ' || CONTROLS.indexOf(c) >= 0) {
            return 5;
        }
        return 0;
    }

    private static char getClosingQuote(char c) {
        switch (c) {
            case '\"': {
                return '\"';
            }
            case '[': {
                return ']';
            }
            case '\u00ab': {
                return '\u00bb';
            }
            case '\u00bb': {
                return '\u00ab';
            }
            case '\u2015': {
                return '\u2015';
            }
            case '\u2018': {
                return '\u2019';
            }
            case '\u201a': {
                return '\u201b';
            }
            case '\u201c': {
                return '\u201d';
            }
            case '\u201e': {
                return '\u201f';
            }
            case '\u2039': {
                return '\u203a';
            }
            case '\u203a': {
                return '\u2039';
            }
            case '\u3008': {
                return '\u3009';
            }
            case '\u300a': {
                return '\u300b';
            }
            case '\u300c': {
                return '\u300d';
            }
            case '\u300e': {
                return '\u300f';
            }
            case '\u301d': {
                return '\u301f';
            }
        }
        return '\u0000';
    }

    private static String applyQuotes(String string, char c, char c2, boolean bl) {
        int n;
        if (string == null) {
            string = "";
        }
        boolean bl2 = false;
        for (n = 0; n < string.length(); ++n) {
            char c3 = string.charAt(n);
            int n2 = XMPUtilsImpl.classifyCharacter(c3);
            if (n == 0 && n2 == 4) break;
            if (n2 == 1) {
                if (bl2) break;
                bl2 = true;
                continue;
            }
            bl2 = false;
            if (n2 == 3 || n2 == 5 || n2 == 2 && !bl) break;
        }
        if (n < string.length()) {
            int n3;
            StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
            for (n3 = 0; n3 <= n && XMPUtilsImpl.classifyCharacter(string.charAt(n)) != 4; ++n3) {
            }
            stringBuffer.append(c).append(string.substring(0, n3));
            for (int i = n3; i < string.length(); ++i) {
                stringBuffer.append(string.charAt(i));
                if (XMPUtilsImpl.classifyCharacter(string.charAt(i)) != 4 || !XMPUtilsImpl.isSurroundingQuote(string.charAt(i), c, c2)) continue;
                stringBuffer.append(string.charAt(i));
            }
            stringBuffer.append(c2);
            string = stringBuffer.toString();
        }
        return string;
    }

    private static boolean isSurroundingQuote(char c, char c2, char c3) {
        return c == c2 || XMPUtilsImpl.isClosingingQuote(c, c2, c3);
    }

    private static boolean isClosingingQuote(char c, char c2, char c3) {
        return c == c3 || c2 == '\u301d' && c == '\u301e' || c == '\u301f';
    }
}

