/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.options.PropertyOptions;
import com.adobe.xmp.properties.XMPProperty;
import com.drew.metadata.Metadata;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.xmp.XmpDirectory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.formats.jpeg.xmp.JpegXmpRewriter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Flag;
import se.datadosen.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpManager {
    public static final String dc_NS = "http://purl.org/dc/elements/1.1/";
    public static final String rdf_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String xap_NS = "http://ns.adobe.com/xap/1.0/";
    public static final String xapRights_NS = "http://ns.adobe.com/xap/1.0/rights/";
    private AlbumObject ao;
    private XMPMeta meta;
    private JpegXmpRewriter rewriter = new JpegXmpRewriter();

    public XmpManager(AlbumObject ao) throws XMPException, IOException {
        this.ao = ao;
        this.init();
    }

    private void init() throws XMPException, IOException {
        try {
            Metadata m = this.ao.getMetadata().getMetadata();
            if (m.containsDirectory(XmpDirectory.class)) {
                XmpDirectory xmpDir = (XmpDirectory)m.getDirectory(XmpDirectory.class);
                this.meta = xmpDir.getXMPMeta();
                if (this.meta != null) {
                    return;
                }
            }
            boolean xmpIsEmpty = false;
            String xml = Sanselan.getXmpXml((File)this.ao.getFile());
            if (xml != null) {
                this.meta = XMPMetaFactory.parseFromString((String)xml);
            } else {
                this.meta = XMPMetaFactory.create();
                xmpIsEmpty = true;
            }
            if (m.containsDirectory(IptcDirectory.class)) {
                this.importIPTCDefaults((IptcDirectory)m.getDirectory(IptcDirectory.class), xmpIsEmpty);
            }
        }
        catch (ImageReadException ex) {
            throw new IOException(ex);
        }
    }

    public XMPMeta getXMPMeta() {
        return this.meta;
    }

    public void save() throws IOException {
        String newXml;
        try {
            newXml = XMPMetaFactory.serializeToString((XMPMeta)this.meta, null);
        }
        catch (XMPException ex) {
            throw new IOException(ex);
        }
        long lastModified = this.ao.getFile().lastModified();
        byte[] fileBytes = IO.readBytes(this.ao.getFile());
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.ao.getFile()));
        try {
            try {
                this.rewriter.updateXmpXml(fileBytes, (OutputStream)os, newXml);
                IO.close(os);
            }
            catch (Exception ex) {
                IO.close(os);
                try {
                    IO.writeBytes(fileBytes, this.ao.getFile());
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw new IOException(ex);
            }
            Object var9_6 = null;
            this.ao.getFile().setLastModified(lastModified);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.ao.getFile().setLastModified(lastModified);
            throw throwable;
        }
    }

    private void removeXmp() throws IOException, ImageReadException, ImageWriteException {
        byte[] fileBytes = IO.readBytes(this.ao.getFile());
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.ao.getFile()));
        this.rewriter.removeXmpXml(fileBytes, (OutputStream)os);
        IO.close(os);
    }

    public String getDescription() {
        try {
            XMPProperty desc = this.meta.getLocalizedText(dc_NS, "dc:description", "", "x-default");
            return desc != null ? desc.getValue().toString() : null;
        }
        catch (XMPException ex) {
            return null;
        }
    }

    public void setDescription(String description) throws XMPException {
        this.meta.setLocalizedText(dc_NS, "dc:description", "", "x-default", description);
    }

    public Integer getRating() {
        try {
            return this.meta.getPropertyInteger(xap_NS, "Rating");
        }
        catch (XMPException ex) {
            return null;
        }
    }

    public void setRating(Integer rating) throws XMPException {
        this.meta.setPropertyInteger(xap_NS, "Rating", rating.intValue());
    }

    public String getTitle() {
        try {
            XMPProperty title = this.meta.getLocalizedText(dc_NS, "dc:title", "", "x-default");
            return title != null ? title.getValue().toString() : null;
        }
        catch (XMPException ex) {
            return null;
        }
    }

    public void setTitle(String title) throws XMPException {
        this.meta.setLocalizedText(dc_NS, "dc:title", "", "x-default", title);
    }

    public String getCreator() throws XMPException {
        XMPProperty p = this.meta.getArrayItem(dc_NS, "dc:creator", 1);
        return p != null ? p.getValue().toString() : null;
    }

    public void setCreator(String creator) throws XMPException {
        try {
            this.meta.setArrayItem(dc_NS, "dc:creator", 1, creator);
        }
        catch (XMPException ex) {
            this.meta.appendArrayItem(dc_NS, "dc:creator", new PropertyOptions(1024), creator, null);
        }
    }

    public String getRights() throws XMPException {
        XMPProperty p = this.meta.getLocalizedText(dc_NS, "dc:rights", "", "x-default");
        return p != null ? p.getValue().toString() : null;
    }

    public void setRights(String rights) throws XMPException {
        this.meta.setLocalizedText(dc_NS, "dc:rights", "", "x-default", rights);
    }

    public String getRightsURL() throws XMPException {
        return this.meta.getPropertyString(xapRights_NS, "WebStatement");
    }

    public void setRightsURL(String rightsURL) throws XMPException {
        this.meta.setProperty(xapRights_NS, "WebStatement", (Object)rightsURL);
    }

    public Set<String> getKeywordSet() throws XMPException {
        XMPProperty p;
        HashSet<String> keywords = new HashSet<String>();
        int i = 1;
        while ((p = this.meta.getArrayItem(dc_NS, "dc:subject", i)) != null) {
            String keyword = p.getValue().toString().trim();
            if (keyword.length() > 0) {
                keywords.add(keyword);
            }
            ++i;
        }
        return keywords;
    }

    public String getKeywords() throws XMPException {
        XMPProperty p;
        StringBuilder buf = new StringBuilder();
        int i = 1;
        while ((p = this.meta.getArrayItem(dc_NS, "dc:subject", i)) != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(p.getValue().toString().trim());
            ++i;
        }
        return i > 1 ? buf.toString() : null;
    }

    public void setKeywords(String keywords) throws XMPException {
        int count;
        String[] keyArray = keywords.split(",|;");
        for (int i = count = this.meta.countArrayItems(dc_NS, "dc:subject"); i >= 1; --i) {
            this.meta.deleteArrayItem(dc_NS, "dc:subject", i);
        }
        PropertyOptions arrayOptions = new PropertyOptions(512);
        for (String keyword : keyArray) {
            if ((keyword = keyword.trim()).length() <= 0) continue;
            this.meta.appendArrayItem(dc_NS, "dc:subject", arrayOptions, keyword, null);
        }
    }

    public Flag getFlag() throws XMPException {
        String s = this.meta.getPropertyString(xap_NS, "Label");
        if (s == null) {
            return Flag.NoFlag;
        }
        try {
            return Flag.valueOf(s);
        }
        catch (IllegalArgumentException ex) {
            if (Config.getConfig().isDebugMode()) {
                System.err.println("Unknown Flag (Label) for " + this.ao.getFile() + ": " + s);
            }
            return Flag.NoFlag;
        }
    }

    public void setFlag(Flag flag) throws XMPException {
        if (flag == Flag.NoFlag) {
            this.meta.deleteProperty(xap_NS, "Label");
        } else {
            this.meta.setProperty(xap_NS, "Label", (Object)flag.name());
        }
    }

    private void importIPTCDefaults(IptcDirectory dir, boolean xmpIsEmpty) throws XMPException {
        String s = dir.getString(592);
        if (s == null) {
            s = dir.getString(634);
        }
        if (s != null && (xmpIsEmpty || this.getCreator() == null)) {
            this.setCreator(s);
        }
        switch (((AlbumObjectImpl)this.ao).factory.engine.getTitleSource()) {
            case IPTCObjectName: {
                if (!dir.containsTag(517)) break;
                s = dir.getString(517);
                break;
            }
            case IPTCHeadline: {
                if (!dir.containsTag(617)) break;
                s = dir.getString(617);
            }
        }
        if (s != null && (xmpIsEmpty || this.getTitle() == null)) {
            this.setTitle(s);
        }
        if ((s = dir.getString(537)) != null && (xmpIsEmpty || this.getKeywords() == null)) {
            this.setKeywords(s);
        }
        if ((s = dir.getString(628)) != null && (xmpIsEmpty || this.getRights() == null)) {
            this.setRights(s);
        }
    }
}

